/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.UrlTemplate;
import com.google.android.exoplayer2.util.Util;
import com.google.common.math.BigIntegerMath;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

@Deprecated
public abstract class SegmentBase {
    @Nullable
    final RangedUri initialization;
    final long timescale;
    final long presentationTimeOffset;

    public SegmentBase(@Nullable RangedUri initialization, long timescale, long presentationTimeOffset) {
        this.initialization = initialization;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
    }

    @Nullable
    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public long getPresentationTimeOffsetUs() {
        return Util.scaleLargeTimestamp((long)this.presentationTimeOffset, (long)1000000L, (long)this.timescale);
    }

    public static final class SegmentTimelineElement {
        final long startTime;
        final long duration;

        public SegmentTimelineElement(long startTime, long duration) {
            this.startTime = startTime;
            this.duration = duration;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SegmentTimelineElement that = (SegmentTimelineElement)o;
            return this.startTime == that.startTime && this.duration == that.duration;
        }

        public int hashCode() {
            return 31 * (int)this.startTime + (int)this.duration;
        }
    }

    public static final class SegmentTemplate
    extends MultiSegmentBase {
        @Nullable
        final UrlTemplate initializationTemplate;
        @Nullable
        final UrlTemplate mediaTemplate;
        final long endNumber;

        public SegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long endNumber, long duration, @Nullable List<SegmentTimelineElement> segmentTimeline, long availabilityTimeOffsetUs, @Nullable UrlTemplate initializationTemplate, @Nullable UrlTemplate mediaTemplate, long timeShiftBufferDepthUs, long periodStartUnixTimeUs) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline, availabilityTimeOffsetUs, timeShiftBufferDepthUs, periodStartUnixTimeUs);
            this.initializationTemplate = initializationTemplate;
            this.mediaTemplate = mediaTemplate;
            this.endNumber = endNumber;
        }

        @Override
        @Nullable
        public RangedUri getInitialization(Representation representation) {
            if (this.initializationTemplate != null) {
                String urlString = this.initializationTemplate.buildUri(representation.format.id, 0L, representation.format.bitrate, 0L);
                return new RangedUri(urlString, 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long sequenceNumber) {
            long time = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber)))).startTime : (sequenceNumber - this.startNumber) * this.duration;
            String uriString = this.mediaTemplate.buildUri(representation.format.id, sequenceNumber, representation.format.bitrate, time);
            return new RangedUri(uriString, 0L, -1L);
        }

        @Override
        public long getSegmentCount(long periodDurationUs) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size();
            }
            if (this.endNumber != -1L) {
                return this.endNumber - this.startNumber + 1L;
            }
            if (periodDurationUs != -9223372036854775807L) {
                BigInteger numerator = BigInteger.valueOf(periodDurationUs).multiply(BigInteger.valueOf(this.timescale));
                BigInteger denominator = BigInteger.valueOf(this.duration).multiply(BigInteger.valueOf(1000000L));
                return BigIntegerMath.divide((BigInteger)numerator, (BigInteger)denominator, (RoundingMode)RoundingMode.CEILING).longValue();
            }
            return -1L;
        }
    }

    public static final class SegmentList
    extends MultiSegmentBase {
        @Nullable
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, @Nullable List<SegmentTimelineElement> segmentTimeline, long availabilityTimeOffsetUs, @Nullable List<RangedUri> mediaSegments, long timeShiftBufferDepthUs, long periodStartUnixTimeUs) {
            super(initialization, timescale, presentationTimeOffset, startNumber, duration, segmentTimeline, availabilityTimeOffsetUs, timeShiftBufferDepthUs, periodStartUnixTimeUs);
            this.mediaSegments = mediaSegments;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, long sequenceNumber) {
            return this.mediaSegments.get((int)(sequenceNumber - this.startNumber));
        }

        @Override
        public long getSegmentCount(long periodDurationUs) {
            return this.mediaSegments.size();
        }

        @Override
        public boolean isExplicit() {
            return true;
        }
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final long startNumber;
        final long duration;
        @Nullable
        final List<SegmentTimelineElement> segmentTimeline;
        private final long timeShiftBufferDepthUs;
        private final long periodStartUnixTimeUs;
        @VisibleForTesting
        final long availabilityTimeOffsetUs;

        public MultiSegmentBase(@Nullable RangedUri initialization, long timescale, long presentationTimeOffset, long startNumber, long duration, @Nullable List<SegmentTimelineElement> segmentTimeline, long availabilityTimeOffsetUs, long timeShiftBufferDepthUs, long periodStartUnixTimeUs) {
            super(initialization, timescale, presentationTimeOffset);
            this.startNumber = startNumber;
            this.duration = duration;
            this.segmentTimeline = segmentTimeline;
            this.availabilityTimeOffsetUs = availabilityTimeOffsetUs;
            this.timeShiftBufferDepthUs = timeShiftBufferDepthUs;
            this.periodStartUnixTimeUs = periodStartUnixTimeUs;
        }

        public long getSegmentNum(long timeUs, long periodDurationUs) {
            long firstSegmentNum = this.getFirstSegmentNum();
            long segmentCount = this.getSegmentCount(periodDurationUs);
            if (segmentCount == 0L) {
                return firstSegmentNum;
            }
            if (this.segmentTimeline == null) {
                long durationUs = this.duration * 1000000L / this.timescale;
                long segmentNum = this.startNumber + timeUs / durationUs;
                return segmentNum < firstSegmentNum ? firstSegmentNum : (segmentCount == -1L ? segmentNum : Math.min(segmentNum, firstSegmentNum + segmentCount - 1L));
            }
            long lowIndex = firstSegmentNum;
            long highIndex = firstSegmentNum + segmentCount - 1L;
            while (lowIndex <= highIndex) {
                long midIndex = lowIndex + (highIndex - lowIndex) / 2L;
                long midTimeUs = this.getSegmentTimeUs(midIndex);
                if (midTimeUs < timeUs) {
                    lowIndex = midIndex + 1L;
                    continue;
                }
                if (midTimeUs > timeUs) {
                    highIndex = midIndex - 1L;
                    continue;
                }
                return midIndex;
            }
            return lowIndex == firstSegmentNum ? lowIndex : highIndex;
        }

        public final long getSegmentDurationUs(long sequenceNumber, long periodDurationUs) {
            if (this.segmentTimeline != null) {
                long duration = this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber))).duration;
                return duration * 1000000L / this.timescale;
            }
            long segmentCount = this.getSegmentCount(periodDurationUs);
            return segmentCount != -1L && sequenceNumber == this.getFirstSegmentNum() + segmentCount - 1L ? periodDurationUs - this.getSegmentTimeUs(sequenceNumber) : this.duration * 1000000L / this.timescale;
        }

        public final long getSegmentTimeUs(long sequenceNumber) {
            long unscaledSegmentTime = this.segmentTimeline != null ? this.segmentTimeline.get((int)((int)(sequenceNumber - this.startNumber))).startTime - this.presentationTimeOffset : (sequenceNumber - this.startNumber) * this.duration;
            return Util.scaleLargeTimestamp((long)unscaledSegmentTime, (long)1000000L, (long)this.timescale);
        }

        public abstract RangedUri getSegmentUrl(Representation var1, long var2);

        public long getFirstSegmentNum() {
            return this.startNumber;
        }

        public long getFirstAvailableSegmentNum(long periodDurationUs, long nowUnixTimeUs) {
            long segmentCount = this.getSegmentCount(periodDurationUs);
            if (segmentCount != -1L || this.timeShiftBufferDepthUs == -9223372036854775807L) {
                return this.getFirstSegmentNum();
            }
            long liveEdgeTimeInPeriodUs = nowUnixTimeUs - this.periodStartUnixTimeUs;
            long timeShiftBufferStartInPeriodUs = liveEdgeTimeInPeriodUs - this.timeShiftBufferDepthUs;
            long timeShiftBufferStartSegmentNum = this.getSegmentNum(timeShiftBufferStartInPeriodUs, periodDurationUs);
            return Math.max(this.getFirstSegmentNum(), timeShiftBufferStartSegmentNum);
        }

        public long getAvailableSegmentCount(long periodDurationUs, long nowUnixTimeUs) {
            long segmentCount = this.getSegmentCount(periodDurationUs);
            if (segmentCount != -1L) {
                return segmentCount;
            }
            long liveEdgeTimeInPeriodUs = nowUnixTimeUs - this.periodStartUnixTimeUs;
            long availabilityTimeOffsetUs = liveEdgeTimeInPeriodUs + this.availabilityTimeOffsetUs;
            long firstIncompleteSegmentNum = this.getSegmentNum(availabilityTimeOffsetUs, periodDurationUs);
            long firstAvailableSegmentNum = this.getFirstAvailableSegmentNum(periodDurationUs, nowUnixTimeUs);
            return (int)(firstIncompleteSegmentNum - firstAvailableSegmentNum);
        }

        public long getNextSegmentAvailableTimeUs(long periodDurationUs, long nowUnixTimeUs) {
            if (this.segmentTimeline != null) {
                return -9223372036854775807L;
            }
            long firstIncompleteSegmentNum = this.getFirstAvailableSegmentNum(periodDurationUs, nowUnixTimeUs) + this.getAvailableSegmentCount(periodDurationUs, nowUnixTimeUs);
            return this.getSegmentTimeUs(firstIncompleteSegmentNum) + this.getSegmentDurationUs(firstIncompleteSegmentNum, periodDurationUs) - this.availabilityTimeOffsetUs;
        }

        public boolean isExplicit() {
            return this.segmentTimeline != null;
        }

        public abstract long getSegmentCount(long var1);
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        final long indexStart;
        final long indexLength;

        public SingleSegmentBase(@Nullable RangedUri initialization, long timescale, long presentationTimeOffset, long indexStart, long indexLength) {
            super(initialization, timescale, presentationTimeOffset);
            this.indexStart = indexStart;
            this.indexLength = indexLength;
        }

        public SingleSegmentBase() {
            this(null, 1L, 0L, 0L, 0L);
        }

        @Nullable
        public RangedUri getIndex() {
            return this.indexLength <= 0L ? null : new RangedUri(null, this.indexStart, this.indexLength);
        }
    }
}

