/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.offline;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.offline.DownloadException;
import com.google.android.exoplayer2.offline.SegmentDownloader;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.DashUtil;
import com.google.android.exoplayer2.source.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.ParsingLoadable;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.util.RunnableFutureTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class DashDownloader
extends SegmentDownloader<DashManifest> {
    @Deprecated
    public DashDownloader(Uri manifestUri, List<StreamKey> streamKeys, CacheDataSource.Factory cacheDataSourceFactory) {
        this(manifestUri, streamKeys, cacheDataSourceFactory, Runnable::run);
    }

    public DashDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory) {
        this(mediaItem, cacheDataSourceFactory, Runnable::run);
    }

    @Deprecated
    public DashDownloader(Uri manifestUri, List<StreamKey> streamKeys, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(new MediaItem.Builder().setUri(manifestUri).setStreamKeys(streamKeys).build(), cacheDataSourceFactory, executor);
    }

    public DashDownloader(MediaItem mediaItem, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this(mediaItem, new DashManifestParser(), cacheDataSourceFactory, executor);
    }

    public DashDownloader(MediaItem mediaItem, ParsingLoadable.Parser<DashManifest> manifestParser, CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        super(mediaItem, manifestParser, cacheDataSourceFactory, executor);
    }

    protected List<SegmentDownloader.Segment> getSegments(DataSource dataSource, DashManifest manifest, boolean removing) throws IOException, InterruptedException {
        ArrayList<SegmentDownloader.Segment> segments = new ArrayList<SegmentDownloader.Segment>();
        for (int i = 0; i < manifest.getPeriodCount(); ++i) {
            Period period = manifest.getPeriod(i);
            long periodStartUs = C.msToUs((long)period.startMs);
            long periodDurationUs = manifest.getPeriodDurationUs(i);
            List<AdaptationSet> adaptationSets = period.adaptationSets;
            for (int j = 0; j < adaptationSets.size(); ++j) {
                this.addSegmentsForAdaptationSet(dataSource, adaptationSets.get(j), periodStartUs, periodDurationUs, removing, segments);
            }
        }
        return segments;
    }

    private void addSegmentsForAdaptationSet(DataSource dataSource, AdaptationSet adaptationSet, long periodStartUs, long periodDurationUs, boolean removing, ArrayList<SegmentDownloader.Segment> out) throws IOException, InterruptedException {
        for (int i = 0; i < adaptationSet.representations.size(); ++i) {
            RangedUri indexUri;
            DashSegmentIndex index;
            Representation representation = adaptationSet.representations.get(i);
            try {
                index = this.getSegmentIndex(dataSource, adaptationSet.type, representation, removing);
                if (index == null) {
                    throw new DownloadException("Missing segment index");
                }
            }
            catch (IOException e) {
                if (removing) continue;
                throw e;
            }
            int segmentCount = index.getSegmentCount(periodDurationUs);
            if (segmentCount == -1) {
                throw new DownloadException("Unbounded segment index");
            }
            String baseUrl = representation.baseUrl;
            RangedUri initializationUri = representation.getInitializationUri();
            if (initializationUri != null) {
                DashDownloader.addSegment(periodStartUs, baseUrl, initializationUri, out);
            }
            if ((indexUri = representation.getIndexUri()) != null) {
                DashDownloader.addSegment(periodStartUs, baseUrl, indexUri, out);
            }
            long firstSegmentNum = index.getFirstSegmentNum();
            long lastSegmentNum = firstSegmentNum + (long)segmentCount - 1L;
            for (long j = firstSegmentNum; j <= lastSegmentNum; ++j) {
                DashDownloader.addSegment(periodStartUs + index.getTimeUs(j), baseUrl, index.getSegmentUrl(j), out);
            }
        }
    }

    private static void addSegment(long startTimeUs, String baseUrl, RangedUri rangedUri, ArrayList<SegmentDownloader.Segment> out) {
        DataSpec dataSpec = new DataSpec(rangedUri.resolveUri(baseUrl), rangedUri.start, rangedUri.length);
        out.add(new SegmentDownloader.Segment(startTimeUs, dataSpec));
    }

    @Nullable
    private DashSegmentIndex getSegmentIndex(final DataSource dataSource, final int trackType, final Representation representation, boolean removing) throws IOException, InterruptedException {
        DashSegmentIndex index = representation.getIndex();
        if (index != null) {
            return index;
        }
        RunnableFutureTask<@NullableType ChunkIndex, IOException> runnable = new RunnableFutureTask<ChunkIndex, IOException>(this){

            protected @NullableType ChunkIndex doWork() throws IOException {
                return DashUtil.loadChunkIndex(dataSource, trackType, representation);
            }
        };
        ChunkIndex seekMap = (ChunkIndex)this.execute((RunnableFutureTask)runnable, removing);
        return seekMap == null ? null : new DashWrappingSegmentIndex(seekMap, representation.presentationTimeOffsetUs);
    }
}

