/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.Descriptor;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;
import com.google.android.exoplayer2.source.dash.manifest.SegmentBase;
import com.google.android.exoplayer2.source.dash.manifest.SingleSegmentIndex;
import java.util.Collections;
import java.util.List;

public abstract class Representation {
    public static final long REVISION_ID_DEFAULT = -1L;
    public final long revisionId;
    public final Format format;
    public final String baseUrl;
    public final long presentationTimeOffsetUs;
    public final List<Descriptor> inbandEventStreams;
    private final RangedUri initializationUri;

    public static Representation newInstance(long revisionId, Format format, String baseUrl, SegmentBase segmentBase) {
        return Representation.newInstance(revisionId, format, baseUrl, segmentBase, null);
    }

    public static Representation newInstance(long revisionId, Format format, String baseUrl, SegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams) {
        return Representation.newInstance(revisionId, format, baseUrl, segmentBase, inbandEventStreams, null);
    }

    public static Representation newInstance(long revisionId, Format format, String baseUrl, SegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, @Nullable String cacheKey) {
        if (segmentBase instanceof SegmentBase.SingleSegmentBase) {
            return new SingleSegmentRepresentation(revisionId, format, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase, inbandEventStreams, cacheKey, -1L);
        }
        if (segmentBase instanceof SegmentBase.MultiSegmentBase) {
            return new MultiSegmentRepresentation(revisionId, format, baseUrl, (SegmentBase.MultiSegmentBase)segmentBase, inbandEventStreams);
        }
        throw new IllegalArgumentException("segmentBase must be of type SingleSegmentBase or MultiSegmentBase");
    }

    private Representation(long revisionId, Format format, String baseUrl, SegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams) {
        this.revisionId = revisionId;
        this.format = format;
        this.baseUrl = baseUrl;
        this.inbandEventStreams = inbandEventStreams == null ? Collections.emptyList() : Collections.unmodifiableList(inbandEventStreams);
        this.initializationUri = segmentBase.getInitialization(this);
        this.presentationTimeOffsetUs = segmentBase.getPresentationTimeOffsetUs();
    }

    @Nullable
    public RangedUri getInitializationUri() {
        return this.initializationUri;
    }

    @Nullable
    public abstract RangedUri getIndexUri();

    @Nullable
    public abstract DashSegmentIndex getIndex();

    @Nullable
    public abstract String getCacheKey();

    public static class MultiSegmentRepresentation
    extends Representation
    implements DashSegmentIndex {
        private final SegmentBase.MultiSegmentBase segmentBase;

        public MultiSegmentRepresentation(long revisionId, Format format, String baseUrl, SegmentBase.MultiSegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams) {
            super(revisionId, format, baseUrl, segmentBase, inbandEventStreams);
            this.segmentBase = segmentBase;
        }

        @Override
        @Nullable
        public RangedUri getIndexUri() {
            return null;
        }

        @Override
        public DashSegmentIndex getIndex() {
            return this;
        }

        @Override
        @Nullable
        public String getCacheKey() {
            return null;
        }

        @Override
        public RangedUri getSegmentUrl(long segmentIndex) {
            return this.segmentBase.getSegmentUrl(this, segmentIndex);
        }

        @Override
        public long getSegmentNum(long timeUs, long periodDurationUs) {
            return this.segmentBase.getSegmentNum(timeUs, periodDurationUs);
        }

        @Override
        public long getTimeUs(long segmentIndex) {
            return this.segmentBase.getSegmentTimeUs(segmentIndex);
        }

        @Override
        public long getDurationUs(long segmentIndex, long periodDurationUs) {
            return this.segmentBase.getSegmentDurationUs(segmentIndex, periodDurationUs);
        }

        @Override
        public long getFirstSegmentNum() {
            return this.segmentBase.getFirstSegmentNum();
        }

        @Override
        public int getSegmentCount(long periodDurationUs) {
            return this.segmentBase.getSegmentCount(periodDurationUs);
        }

        @Override
        public boolean isExplicit() {
            return this.segmentBase.isExplicit();
        }
    }

    public static class SingleSegmentRepresentation
    extends Representation {
        public final Uri uri;
        public final long contentLength;
        @Nullable
        private final String cacheKey;
        @Nullable
        private final RangedUri indexUri;
        @Nullable
        private final SingleSegmentIndex segmentIndex;

        public static SingleSegmentRepresentation newInstance(long revisionId, Format format, String uri, long initializationStart, long initializationEnd, long indexStart, long indexEnd, List<Descriptor> inbandEventStreams, @Nullable String cacheKey, long contentLength) {
            RangedUri rangedUri = new RangedUri(null, initializationStart, initializationEnd - initializationStart + 1L);
            SegmentBase.SingleSegmentBase segmentBase = new SegmentBase.SingleSegmentBase(rangedUri, 1L, 0L, indexStart, indexEnd - indexStart + 1L);
            return new SingleSegmentRepresentation(revisionId, format, uri, segmentBase, inbandEventStreams, cacheKey, contentLength);
        }

        public SingleSegmentRepresentation(long revisionId, Format format, String baseUrl, SegmentBase.SingleSegmentBase segmentBase, @Nullable List<Descriptor> inbandEventStreams, @Nullable String cacheKey, long contentLength) {
            super(revisionId, format, baseUrl, segmentBase, inbandEventStreams);
            this.uri = Uri.parse((String)baseUrl);
            this.indexUri = segmentBase.getIndex();
            this.cacheKey = cacheKey;
            this.contentLength = contentLength;
            this.segmentIndex = this.indexUri != null ? null : new SingleSegmentIndex(new RangedUri(null, 0L, contentLength));
        }

        @Override
        @Nullable
        public RangedUri getIndexUri() {
            return this.indexUri;
        }

        @Override
        @Nullable
        public DashSegmentIndex getIndex() {
            return this.segmentIndex;
        }

        @Override
        @Nullable
        public String getCacheKey() {
            return this.cacheKey;
        }
    }
}

