/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.offline.FilterableManifest;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.ProgramInformation;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DashManifest
implements FilterableManifest<DashManifest> {
    public final long availabilityStartTimeMs;
    public final long durationMs;
    public final long minBufferTimeMs;
    public final boolean dynamic;
    public final long minUpdatePeriodMs;
    public final long timeShiftBufferDepthMs;
    public final long suggestedPresentationDelayMs;
    public final long publishTimeMs;
    @Nullable
    public final UtcTimingElement utcTiming;
    @Nullable
    public final Uri location;
    @Nullable
    public final ProgramInformation programInformation;
    private final List<Period> periods;

    @Deprecated
    public DashManifest(long availabilityStartTimeMs, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdatePeriodMs, long timeShiftBufferDepthMs, long suggestedPresentationDelayMs, long publishTimeMs, @Nullable UtcTimingElement utcTiming, @Nullable Uri location, List<Period> periods) {
        this(availabilityStartTimeMs, durationMs, minBufferTimeMs, dynamic, minUpdatePeriodMs, timeShiftBufferDepthMs, suggestedPresentationDelayMs, publishTimeMs, null, utcTiming, location, periods);
    }

    public DashManifest(long availabilityStartTimeMs, long durationMs, long minBufferTimeMs, boolean dynamic, long minUpdatePeriodMs, long timeShiftBufferDepthMs, long suggestedPresentationDelayMs, long publishTimeMs, @Nullable ProgramInformation programInformation, @Nullable UtcTimingElement utcTiming, @Nullable Uri location, List<Period> periods) {
        this.availabilityStartTimeMs = availabilityStartTimeMs;
        this.durationMs = durationMs;
        this.minBufferTimeMs = minBufferTimeMs;
        this.dynamic = dynamic;
        this.minUpdatePeriodMs = minUpdatePeriodMs;
        this.timeShiftBufferDepthMs = timeShiftBufferDepthMs;
        this.suggestedPresentationDelayMs = suggestedPresentationDelayMs;
        this.publishTimeMs = publishTimeMs;
        this.programInformation = programInformation;
        this.utcTiming = utcTiming;
        this.location = location;
        this.periods = periods == null ? Collections.emptyList() : periods;
    }

    public final int getPeriodCount() {
        return this.periods.size();
    }

    public final Period getPeriod(int index) {
        return this.periods.get(index);
    }

    public final long getPeriodDurationMs(int index) {
        return index == this.periods.size() - 1 ? (this.durationMs == -9223372036854775807L ? -9223372036854775807L : this.durationMs - this.periods.get((int)index).startMs) : this.periods.get((int)(index + 1)).startMs - this.periods.get((int)index).startMs;
    }

    public final long getPeriodDurationUs(int index) {
        return C.msToUs((long)this.getPeriodDurationMs(index));
    }

    public final DashManifest copy(List<StreamKey> streamKeys) {
        LinkedList<StreamKey> keys = new LinkedList<StreamKey>(streamKeys);
        Collections.sort(keys);
        keys.add(new StreamKey(-1, -1, -1));
        ArrayList<Period> copyPeriods = new ArrayList<Period>();
        long shiftMs = 0L;
        for (int periodIndex = 0; periodIndex < this.getPeriodCount(); ++periodIndex) {
            if (keys.peek().periodIndex != periodIndex) {
                long periodDurationMs = this.getPeriodDurationMs(periodIndex);
                if (periodDurationMs == -9223372036854775807L) continue;
                shiftMs += periodDurationMs;
                continue;
            }
            Period period = this.getPeriod(periodIndex);
            ArrayList<AdaptationSet> copyAdaptationSets = DashManifest.copyAdaptationSets(period.adaptationSets, keys);
            Period copiedPeriod = new Period(period.id, period.startMs - shiftMs, copyAdaptationSets, period.eventStreams);
            copyPeriods.add(copiedPeriod);
        }
        long newDuration = this.durationMs != -9223372036854775807L ? this.durationMs - shiftMs : -9223372036854775807L;
        return new DashManifest(this.availabilityStartTimeMs, newDuration, this.minBufferTimeMs, this.dynamic, this.minUpdatePeriodMs, this.timeShiftBufferDepthMs, this.suggestedPresentationDelayMs, this.publishTimeMs, this.programInformation, this.utcTiming, this.location, copyPeriods);
    }

    private static ArrayList<AdaptationSet> copyAdaptationSets(List<AdaptationSet> adaptationSets, LinkedList<StreamKey> keys) {
        StreamKey key = keys.poll();
        int periodIndex = key.periodIndex;
        ArrayList<AdaptationSet> copyAdaptationSets = new ArrayList<AdaptationSet>();
        do {
            int adaptationSetIndex = key.groupIndex;
            AdaptationSet adaptationSet = adaptationSets.get(adaptationSetIndex);
            List<Representation> representations = adaptationSet.representations;
            ArrayList<Representation> copyRepresentations = new ArrayList<Representation>();
            do {
                Representation representation = representations.get(key.trackIndex);
                copyRepresentations.add(representation);
                key = keys.poll();
            } while (key.periodIndex == periodIndex && key.groupIndex == adaptationSetIndex);
            copyAdaptationSets.add(new AdaptationSet(adaptationSet.id, adaptationSet.type, copyRepresentations, adaptationSet.accessibilityDescriptors, adaptationSet.essentialProperties, adaptationSet.supplementalProperties));
        } while (key.periodIndex == periodIndex);
        keys.addFirst(key);
        return copyAdaptationSets;
    }
}

