/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.metadata.emsg.EventMessageEncoder;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.dash.manifest.EventStream;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class EventSampleStream
implements SampleStream {
    private final Format upstreamFormat;
    private final EventMessageEncoder eventMessageEncoder;
    private long[] eventTimesUs;
    private boolean eventStreamAppendable;
    private EventStream eventStream;
    private boolean isFormatSentDownstream;
    private int currentIndex;
    private long pendingSeekPositionUs;

    public EventSampleStream(EventStream eventStream, Format upstreamFormat, boolean eventStreamAppendable) {
        this.upstreamFormat = upstreamFormat;
        this.eventStream = eventStream;
        this.eventMessageEncoder = new EventMessageEncoder();
        this.pendingSeekPositionUs = -9223372036854775807L;
        this.eventTimesUs = eventStream.presentationTimesUs;
        this.updateEventStream(eventStream, eventStreamAppendable);
    }

    public String eventStreamId() {
        return this.eventStream.id();
    }

    public void updateEventStream(EventStream eventStream, boolean eventStreamAppendable) {
        long lastReadPositionUs = this.currentIndex == 0 ? -9223372036854775807L : this.eventTimesUs[this.currentIndex - 1];
        this.eventStreamAppendable = eventStreamAppendable;
        this.eventStream = eventStream;
        this.eventTimesUs = eventStream.presentationTimesUs;
        if (this.pendingSeekPositionUs != -9223372036854775807L) {
            this.seekToUs(this.pendingSeekPositionUs);
        } else if (lastReadPositionUs != -9223372036854775807L) {
            this.currentIndex = Util.binarySearchCeil((long[])this.eventTimesUs, (long)lastReadPositionUs, (boolean)false, (boolean)false);
        }
    }

    public void seekToUs(long positionUs) {
        this.currentIndex = Util.binarySearchCeil((long[])this.eventTimesUs, (long)positionUs, (boolean)true, (boolean)false);
        boolean isPendingSeek = this.eventStreamAppendable && this.currentIndex == this.eventTimesUs.length;
        this.pendingSeekPositionUs = isPendingSeek ? positionUs : -9223372036854775807L;
    }

    public boolean isReady() {
        return true;
    }

    public void maybeThrowError() throws IOException {
    }

    public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, boolean formatRequired) {
        int sampleIndex;
        byte[] serializedEvent;
        if (formatRequired || !this.isFormatSentDownstream) {
            formatHolder.format = this.upstreamFormat;
            this.isFormatSentDownstream = true;
            return -5;
        }
        if (this.currentIndex == this.eventTimesUs.length) {
            if (!this.eventStreamAppendable) {
                buffer.setFlags(4);
                return -4;
            }
            return -3;
        }
        if ((serializedEvent = this.eventMessageEncoder.encode(this.eventStream.events[sampleIndex = this.currentIndex++])) != null) {
            buffer.ensureSpaceForWrite(serializedEvent.length);
            buffer.data.put(serializedEvent);
            buffer.timeUs = this.eventTimesUs[sampleIndex];
            buffer.setFlags(1);
            return -4;
        }
        return -3;
    }

    public int skipData(long positionUs) {
        int newIndex = Math.max(this.currentIndex, Util.binarySearchCeil((long[])this.eventTimesUs, (long)positionUs, (boolean)true, (boolean)false));
        int skipped = newIndex - this.currentIndex;
        this.currentIndex = newIndex;
        return skipped;
    }
}

