/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.metadata.emsg.EventMessageDecoder;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class PlayerEmsgHandler
implements Handler.Callback {
    private static final int EMSG_MANIFEST_EXPIRED = 1;
    private final Allocator allocator;
    private final PlayerEmsgCallback playerEmsgCallback;
    private final EventMessageDecoder decoder;
    private final Handler handler;
    private final TreeMap<Long, Long> manifestPublishTimeToExpiryTimeUs;
    private DashManifest manifest;
    private long expiredManifestPublishTimeUs;
    private long lastLoadedChunkEndTimeUs;
    private long lastLoadedChunkEndTimeBeforeRefreshUs;
    private boolean isWaitingForManifestRefresh;
    private boolean released;

    public PlayerEmsgHandler(DashManifest manifest, PlayerEmsgCallback playerEmsgCallback, Allocator allocator) {
        this.manifest = manifest;
        this.playerEmsgCallback = playerEmsgCallback;
        this.allocator = allocator;
        this.manifestPublishTimeToExpiryTimeUs = new TreeMap();
        this.handler = Util.createHandler((Handler.Callback)this);
        this.decoder = new EventMessageDecoder();
        this.lastLoadedChunkEndTimeUs = -9223372036854775807L;
        this.lastLoadedChunkEndTimeBeforeRefreshUs = -9223372036854775807L;
    }

    public void updateManifest(DashManifest newManifest) {
        this.isWaitingForManifestRefresh = false;
        this.expiredManifestPublishTimeUs = -9223372036854775807L;
        this.manifest = newManifest;
        this.removePreviouslyExpiredManifestPublishTimeValues();
    }

    boolean maybeRefreshManifestBeforeLoadingNextChunk(long presentationPositionUs) {
        long expiredPointUs;
        if (!this.manifest.dynamic) {
            return false;
        }
        if (this.isWaitingForManifestRefresh) {
            return true;
        }
        boolean manifestRefreshNeeded = false;
        Map.Entry<Long, Long> expiredEntry = this.ceilingExpiryEntryForPublishTime(this.manifest.publishTimeMs);
        if (expiredEntry != null && (expiredPointUs = expiredEntry.getValue().longValue()) < presentationPositionUs) {
            this.expiredManifestPublishTimeUs = expiredEntry.getKey();
            this.notifyManifestPublishTimeExpired();
            manifestRefreshNeeded = true;
        }
        if (manifestRefreshNeeded) {
            this.maybeNotifyDashManifestRefreshNeeded();
        }
        return manifestRefreshNeeded;
    }

    boolean maybeRefreshManifestOnLoadingError(Chunk chunk) {
        boolean isAfterForwardSeek;
        if (!this.manifest.dynamic) {
            return false;
        }
        if (this.isWaitingForManifestRefresh) {
            return true;
        }
        boolean bl = isAfterForwardSeek = this.lastLoadedChunkEndTimeUs != -9223372036854775807L && this.lastLoadedChunkEndTimeUs < chunk.startTimeUs;
        if (isAfterForwardSeek) {
            this.maybeNotifyDashManifestRefreshNeeded();
            return true;
        }
        return false;
    }

    void onChunkLoadCompleted(Chunk chunk) {
        if (this.lastLoadedChunkEndTimeUs != -9223372036854775807L || chunk.endTimeUs > this.lastLoadedChunkEndTimeUs) {
            this.lastLoadedChunkEndTimeUs = chunk.endTimeUs;
        }
    }

    public static boolean isPlayerEmsgEvent(String schemeIdUri, String value) {
        return "urn:mpeg:dash:event:2012".equals(schemeIdUri) && ("1".equals(value) || "2".equals(value) || "3".equals(value));
    }

    public PlayerTrackEmsgHandler newPlayerTrackEmsgHandler() {
        return new PlayerTrackEmsgHandler(new SampleQueue(this.allocator));
    }

    public void release() {
        this.released = true;
        this.handler.removeCallbacksAndMessages(null);
    }

    public boolean handleMessage(Message message) {
        if (this.released) {
            return true;
        }
        switch (message.what) {
            case 1: {
                ManifestExpiryEventInfo messageObj = (ManifestExpiryEventInfo)message.obj;
                this.handleManifestExpiredMessage(messageObj.eventTimeUs, messageObj.manifestPublishTimeMsInEmsg);
                return true;
            }
        }
        return false;
    }

    private void handleManifestExpiredMessage(long eventTimeUs, long manifestPublishTimeMsInEmsg) {
        Long previousExpiryTimeUs = this.manifestPublishTimeToExpiryTimeUs.get(manifestPublishTimeMsInEmsg);
        if (previousExpiryTimeUs == null) {
            this.manifestPublishTimeToExpiryTimeUs.put(manifestPublishTimeMsInEmsg, eventTimeUs);
        } else if (previousExpiryTimeUs > eventTimeUs) {
            this.manifestPublishTimeToExpiryTimeUs.put(manifestPublishTimeMsInEmsg, eventTimeUs);
        }
    }

    @Nullable
    private Map.Entry<Long, Long> ceilingExpiryEntryForPublishTime(long publishTimeMs) {
        return this.manifestPublishTimeToExpiryTimeUs.ceilingEntry(publishTimeMs);
    }

    private void removePreviouslyExpiredManifestPublishTimeValues() {
        Iterator<Map.Entry<Long, Long>> it = this.manifestPublishTimeToExpiryTimeUs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Long> entry = it.next();
            long expiredManifestPublishTime = entry.getKey();
            if (expiredManifestPublishTime >= this.manifest.publishTimeMs) continue;
            it.remove();
        }
    }

    private void notifyManifestPublishTimeExpired() {
        this.playerEmsgCallback.onDashManifestPublishTimeExpired(this.expiredManifestPublishTimeUs);
    }

    private void maybeNotifyDashManifestRefreshNeeded() {
        if (this.lastLoadedChunkEndTimeBeforeRefreshUs != -9223372036854775807L && this.lastLoadedChunkEndTimeBeforeRefreshUs == this.lastLoadedChunkEndTimeUs) {
            return;
        }
        this.isWaitingForManifestRefresh = true;
        this.lastLoadedChunkEndTimeBeforeRefreshUs = this.lastLoadedChunkEndTimeUs;
        this.playerEmsgCallback.onDashManifestRefreshRequested();
    }

    private static long getManifestPublishTimeMsInEmsg(EventMessage eventMessage) {
        try {
            return Util.parseXsDateTime((String)Util.fromUtf8Bytes((byte[])eventMessage.messageData));
        }
        catch (ParserException ignored) {
            return -9223372036854775807L;
        }
    }

    private static final class ManifestExpiryEventInfo {
        public final long eventTimeUs;
        public final long manifestPublishTimeMsInEmsg;

        public ManifestExpiryEventInfo(long eventTimeUs, long manifestPublishTimeMsInEmsg) {
            this.eventTimeUs = eventTimeUs;
            this.manifestPublishTimeMsInEmsg = manifestPublishTimeMsInEmsg;
        }
    }

    public final class PlayerTrackEmsgHandler
    implements TrackOutput {
        private final SampleQueue sampleQueue;
        private final FormatHolder formatHolder;
        private final MetadataInputBuffer buffer;

        PlayerTrackEmsgHandler(SampleQueue sampleQueue) {
            this.sampleQueue = sampleQueue;
            this.formatHolder = new FormatHolder();
            this.buffer = new MetadataInputBuffer();
        }

        public void format(Format format) {
            this.sampleQueue.format(format);
        }

        public int sampleData(ExtractorInput input, int length, boolean allowEndOfInput) throws IOException, InterruptedException {
            return this.sampleQueue.sampleData(input, length, allowEndOfInput);
        }

        public void sampleData(ParsableByteArray data, int length) {
            this.sampleQueue.sampleData(data, length);
        }

        public void sampleMetadata(long timeUs, int flags, int size, int offset, @Nullable TrackOutput.CryptoData encryptionData) {
            this.sampleQueue.sampleMetadata(timeUs, flags, size, offset, encryptionData);
            this.parseAndDiscardSamples();
        }

        public boolean maybeRefreshManifestBeforeLoadingNextChunk(long presentationPositionUs) {
            return PlayerEmsgHandler.this.maybeRefreshManifestBeforeLoadingNextChunk(presentationPositionUs);
        }

        public void onChunkLoadCompleted(Chunk chunk) {
            PlayerEmsgHandler.this.onChunkLoadCompleted(chunk);
        }

        public boolean maybeRefreshManifestOnLoadingError(Chunk chunk) {
            return PlayerEmsgHandler.this.maybeRefreshManifestOnLoadingError(chunk);
        }

        public void release() {
            this.sampleQueue.reset();
        }

        private void parseAndDiscardSamples() {
            while (this.sampleQueue.hasNextSample()) {
                MetadataInputBuffer inputBuffer = this.dequeueSample();
                if (inputBuffer == null) continue;
                long eventTimeUs = inputBuffer.timeUs;
                Metadata metadata = PlayerEmsgHandler.this.decoder.decode(inputBuffer);
                if (metadata == null) continue;
                EventMessage eventMessage = (EventMessage)metadata.get(0);
                if (!PlayerEmsgHandler.isPlayerEmsgEvent(eventMessage.schemeIdUri, eventMessage.value)) continue;
                this.parsePlayerEmsgEvent(eventTimeUs, eventMessage);
            }
            this.sampleQueue.discardToRead();
        }

        @Nullable
        private MetadataInputBuffer dequeueSample() {
            this.buffer.clear();
            int result = this.sampleQueue.read(this.formatHolder, (DecoderInputBuffer)this.buffer, false, false, 0L);
            if (result == -4) {
                this.buffer.flip();
                return this.buffer;
            }
            return null;
        }

        private void parsePlayerEmsgEvent(long eventTimeUs, EventMessage eventMessage) {
            long manifestPublishTimeMsInEmsg = PlayerEmsgHandler.getManifestPublishTimeMsInEmsg(eventMessage);
            if (manifestPublishTimeMsInEmsg == -9223372036854775807L) {
                return;
            }
            this.onManifestExpiredMessageEncountered(eventTimeUs, manifestPublishTimeMsInEmsg);
        }

        private void onManifestExpiredMessageEncountered(long eventTimeUs, long manifestPublishTimeMsInEmsg) {
            ManifestExpiryEventInfo manifestExpiryEventInfo = new ManifestExpiryEventInfo(eventTimeUs, manifestPublishTimeMsInEmsg);
            PlayerEmsgHandler.this.handler.sendMessage(PlayerEmsgHandler.this.handler.obtainMessage(1, (Object)manifestExpiryEventInfo));
        }
    }

    public static interface PlayerEmsgCallback {
        public void onDashManifestRefreshRequested();

        public void onDashManifestPublishTimeExpired(long var1);
    }
}

