/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.os.Bundle;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class CueGroup
implements Bundleable {
    public static final CueGroup EMPTY_TIME_ZERO = new CueGroup((List<Cue>)ImmutableList.of(), 0L);
    public final ImmutableList<Cue> cues;
    public final long presentationTimeUs;
    private static final String FIELD_CUES = Util.intToStringMaxRadix(0);
    private static final String FIELD_PRESENTATION_TIME_US = Util.intToStringMaxRadix(1);
    public static final Bundleable.Creator<CueGroup> CREATOR = CueGroup::fromBundle;

    public CueGroup(List<Cue> cues, long presentationTimeUs) {
        this.cues = ImmutableList.copyOf(cues);
        this.presentationTimeUs = presentationTimeUs;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(FIELD_CUES, BundleableUtil.toBundleArrayList(CueGroup.filterOutBitmapCues(this.cues)));
        bundle.putLong(FIELD_PRESENTATION_TIME_US, this.presentationTimeUs);
        return bundle;
    }

    private static final CueGroup fromBundle(Bundle bundle) {
        ArrayList cueBundles = bundle.getParcelableArrayList(FIELD_CUES);
        ImmutableList<Cue> cues = cueBundles == null ? ImmutableList.of() : BundleableUtil.fromBundleList(Cue.CREATOR, cueBundles);
        long presentationTimeUs = bundle.getLong(FIELD_PRESENTATION_TIME_US);
        return new CueGroup((List<Cue>)cues, presentationTimeUs);
    }

    private static ImmutableList<Cue> filterOutBitmapCues(List<Cue> cues) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < cues.size(); ++i) {
            if (cues.get((int)i).bitmap != null) continue;
            builder.add((Object)cues.get(i));
        }
        return builder.build();
    }
}

