/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.os.Bundle;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class CueGroup
implements Bundleable {
    public static final CueGroup EMPTY = new CueGroup((List<Cue>)ImmutableList.of());
    public final ImmutableList<Cue> cues;
    private static final int FIELD_CUES = 0;
    public static final Bundleable.Creator<CueGroup> CREATOR = CueGroup::fromBundle;

    public CueGroup(List<Cue> cues) {
        this.cues = ImmutableList.copyOf(cues);
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(CueGroup.keyForField(0), BundleableUtil.toBundleArrayList(CueGroup.filterOutBitmapCues(this.cues)));
        return bundle;
    }

    private static final CueGroup fromBundle(Bundle bundle) {
        ArrayList cueBundles = bundle.getParcelableArrayList(CueGroup.keyForField(0));
        ImmutableList<Cue> cues = cueBundles == null ? ImmutableList.of() : BundleableUtil.fromBundleList(Cue.CREATOR, cueBundles);
        return new CueGroup((List<Cue>)cues);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private static ImmutableList<Cue> filterOutBitmapCues(List<Cue> cues) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < cues.size(); ++i) {
            if (cues.get((int)i).bitmap != null) continue;
            builder.add((Object)cues.get(i));
        }
        return builder.build();
    }
}

