/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.HeartRating;
import com.google.android.exoplayer2.PercentageRating;
import com.google.android.exoplayer2.StarRating;
import com.google.android.exoplayer2.ThumbRating;

public abstract class Rating
implements Bundleable {
    static final float RATING_UNSET = -1.0f;
    static final int RATING_TYPE_UNSET = -1;
    static final int RATING_TYPE_HEART = 0;
    static final int RATING_TYPE_PERCENTAGE = 1;
    static final int RATING_TYPE_STAR = 2;
    static final int RATING_TYPE_THUMB = 3;
    static final int FIELD_RATING_TYPE = 0;
    public static final Bundleable.Creator<Rating> CREATOR = Rating::fromBundle;

    Rating() {
    }

    public abstract boolean isRated();

    private static Rating fromBundle(Bundle bundle) {
        int ratingType = bundle.getInt(Rating.keyForField(0), -1);
        switch (ratingType) {
            case 0: {
                return HeartRating.CREATOR.fromBundle(bundle);
            }
            case 1: {
                return PercentageRating.CREATOR.fromBundle(bundle);
            }
            case 2: {
                return StarRating.CREATOR.fromBundle(bundle);
            }
            case 3: {
                return ThumbRating.CREATOR.fromBundle(bundle);
            }
        }
        throw new IllegalArgumentException("Unknown RatingType: " + ratingType);
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

