/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.video.ColorInfo;
import java.nio.ByteBuffer;
import java.util.List;

public final class MediaFormatUtil {
    public static final String KEY_PIXEL_WIDTH_HEIGHT_RATIO_FLOAT = "exo-pixel-width-height-ratio-float";
    public static final String KEY_PCM_ENCODING_EXTENDED = "exo-pcm-encoding-int";
    private static final int MAX_POWER_OF_TWO_INT = 0x40000000;

    @SuppressLint(value={"InlinedApi"})
    public static MediaFormat createMediaFormatFromFormat(Format format) {
        MediaFormat result = new MediaFormat();
        MediaFormatUtil.maybeSetInteger(result, "bitrate", format.bitrate);
        MediaFormatUtil.maybeSetInteger(result, "channel-count", format.channelCount);
        MediaFormatUtil.maybeSetColorInfo(result, format.colorInfo);
        MediaFormatUtil.maybeSetString(result, "mime", format.sampleMimeType);
        MediaFormatUtil.maybeSetString(result, "codecs-string", format.codecs);
        MediaFormatUtil.maybeSetFloat(result, "frame-rate", format.frameRate);
        MediaFormatUtil.maybeSetInteger(result, "width", format.width);
        MediaFormatUtil.maybeSetInteger(result, "height", format.height);
        MediaFormatUtil.setCsdBuffers(result, format.initializationData);
        MediaFormatUtil.maybeSetPcmEncoding(result, format.pcmEncoding);
        MediaFormatUtil.maybeSetString(result, "language", format.language);
        MediaFormatUtil.maybeSetInteger(result, "max-input-size", format.maxInputSize);
        MediaFormatUtil.maybeSetInteger(result, "sample-rate", format.sampleRate);
        MediaFormatUtil.maybeSetInteger(result, "caption-service-number", format.accessibilityChannel);
        result.setInteger("rotation-degrees", format.rotationDegrees);
        int selectionFlags = format.selectionFlags;
        MediaFormatUtil.setBooleanAsInt(result, "is-autoselect", selectionFlags & 4);
        MediaFormatUtil.setBooleanAsInt(result, "is-default", selectionFlags & 1);
        MediaFormatUtil.setBooleanAsInt(result, "is-forced-subtitle", selectionFlags & 2);
        result.setInteger("encoder-delay", format.encoderDelay);
        result.setInteger("encoder-padding", format.encoderPadding);
        MediaFormatUtil.maybeSetPixelAspectRatio(result, format.pixelWidthHeightRatio);
        return result;
    }

    public static void maybeSetString(MediaFormat format, String key, @Nullable String value) {
        if (value != null) {
            format.setString(key, value);
        }
    }

    public static void setCsdBuffers(MediaFormat format, List<byte[]> csdBuffers) {
        for (int i = 0; i < csdBuffers.size(); ++i) {
            int n = i;
            format.setByteBuffer(new StringBuilder(15).append("csd-").append(n).toString(), ByteBuffer.wrap(csdBuffers.get(i)));
        }
    }

    public static void maybeSetInteger(MediaFormat format, String key, int value) {
        if (value != -1) {
            format.setInteger(key, value);
        }
    }

    public static void maybeSetFloat(MediaFormat format, String key, float value) {
        if (value != -1.0f) {
            format.setFloat(key, value);
        }
    }

    public static void maybeSetByteBuffer(MediaFormat format, String key, @Nullable byte[] value) {
        if (value != null) {
            format.setByteBuffer(key, ByteBuffer.wrap(value));
        }
    }

    public static void maybeSetColorInfo(MediaFormat format, @Nullable ColorInfo colorInfo) {
        if (colorInfo != null) {
            MediaFormatUtil.maybeSetInteger(format, "color-transfer", colorInfo.colorTransfer);
            MediaFormatUtil.maybeSetInteger(format, "color-standard", colorInfo.colorSpace);
            MediaFormatUtil.maybeSetInteger(format, "color-range", colorInfo.colorRange);
            MediaFormatUtil.maybeSetByteBuffer(format, "hdr-static-info", colorInfo.hdrStaticInfo);
        }
    }

    private static void setBooleanAsInt(MediaFormat format, String key, int value) {
        format.setInteger(key, value != 0 ? 1 : 0);
    }

    @SuppressLint(value={"InlinedApi"})
    private static void maybeSetPixelAspectRatio(MediaFormat mediaFormat, float pixelWidthHeightRatio) {
        mediaFormat.setFloat(KEY_PIXEL_WIDTH_HEIGHT_RATIO_FLOAT, pixelWidthHeightRatio);
        int pixelAspectRatioWidth = 1;
        int pixelAspectRatioHeight = 1;
        if (pixelWidthHeightRatio < 1.0f) {
            pixelAspectRatioHeight = 0x40000000;
            pixelAspectRatioWidth = (int)(pixelWidthHeightRatio * (float)pixelAspectRatioHeight);
        } else if (pixelWidthHeightRatio > 1.0f) {
            pixelAspectRatioWidth = 0x40000000;
            pixelAspectRatioHeight = (int)((float)pixelAspectRatioWidth / pixelWidthHeightRatio);
        }
        mediaFormat.setInteger("sar-width", pixelAspectRatioWidth);
        mediaFormat.setInteger("sar-height", pixelAspectRatioHeight);
    }

    @SuppressLint(value={"InlinedApi"})
    private static void maybeSetPcmEncoding(MediaFormat mediaFormat, int exoPcmEncoding) {
        int mediaFormatPcmEncoding;
        if (exoPcmEncoding == -1) {
            return;
        }
        MediaFormatUtil.maybeSetInteger(mediaFormat, KEY_PCM_ENCODING_EXTENDED, exoPcmEncoding);
        switch (exoPcmEncoding) {
            case 3: {
                mediaFormatPcmEncoding = 3;
                break;
            }
            case 2: {
                mediaFormatPcmEncoding = 2;
                break;
            }
            case 4: {
                mediaFormatPcmEncoding = 4;
                break;
            }
            case 0x20000000: {
                mediaFormatPcmEncoding = 21;
                break;
            }
            case 0x30000000: {
                mediaFormatPcmEncoding = 22;
                break;
            }
            case 0: {
                mediaFormatPcmEncoding = 0;
                break;
            }
            default: {
                return;
            }
        }
        mediaFormat.setInteger("pcm-encoding", mediaFormatPcmEncoding);
    }

    private MediaFormatUtil() {
    }
}

