/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.util.CodecSpecificDataUtil;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.ParsableNalUnitBitArray;
import java.util.Collections;
import java.util.List;

public final class HevcConfig {
    private static final int SPS_NAL_UNIT_TYPE = 33;
    @Nullable
    public final List<byte[]> initializationData;
    public final int nalUnitLengthFieldLength;
    @Nullable
    public final String codecs;

    public static HevcConfig parse(ParsableByteArray data) throws ParserException {
        try {
            data.skipBytes(21);
            int lengthSizeMinusOne = data.readUnsignedByte() & 3;
            int numberOfArrays = data.readUnsignedByte();
            int csdLength = 0;
            int csdStartPosition = data.getPosition();
            for (int i = 0; i < numberOfArrays; ++i) {
                data.skipBytes(1);
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    int nalUnitLength = data.readUnsignedShort();
                    csdLength += 4 + nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            data.setPosition(csdStartPosition);
            byte[] buffer = new byte[csdLength];
            int bufferPosition = 0;
            String codecs = null;
            for (int i = 0; i < numberOfArrays; ++i) {
                int nalUnitType = data.readUnsignedByte() & 0x7F;
                int numberOfNalUnits = data.readUnsignedShort();
                for (int j = 0; j < numberOfNalUnits; ++j) {
                    int nalUnitLength = data.readUnsignedShort();
                    System.arraycopy(NalUnitUtil.NAL_START_CODE, 0, buffer, bufferPosition, NalUnitUtil.NAL_START_CODE.length);
                    System.arraycopy(data.getData(), data.getPosition(), buffer, bufferPosition += NalUnitUtil.NAL_START_CODE.length, nalUnitLength);
                    if (nalUnitType == 33 && j == 0) {
                        ParsableNalUnitBitArray bitArray = new ParsableNalUnitBitArray(buffer, bufferPosition, bufferPosition + nalUnitLength);
                        codecs = CodecSpecificDataUtil.buildHevcCodecStringFromSps(bitArray);
                    }
                    bufferPosition += nalUnitLength;
                    data.skipBytes(nalUnitLength);
                }
            }
            List<byte[]> initializationData = csdLength == 0 ? null : Collections.singletonList(buffer);
            return new HevcConfig(initializationData, lengthSizeMinusOne + 1, codecs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ParserException.createForMalformedContainer("Error parsing HEVC config", e);
        }
    }

    private HevcConfig(@Nullable List<byte[]> initializationData, int nalUnitLengthFieldLength, @Nullable String codecs) {
        this.initializationData = initializationData;
        this.nalUnitLengthFieldLength = nalUnitLengthFieldLength;
        this.codecs = codecs;
    }
}

