/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLES20;
import android.opengl.GLU;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public final class GlUtil {
    private static final String TAG = "GlUtil";
    private static final String EXTENSION_PROTECTED_CONTENT = "EGL_EXT_protected_content";
    private static final String EXTENSION_SURFACELESS_CONTEXT = "EGL_KHR_surfaceless_context";

    private GlUtil() {
    }

    public static boolean isProtectedContentExtensionSupported(Context context) {
        if (Util.SDK_INT < 24) {
            return false;
        }
        if (Util.SDK_INT < 26 && ("samsung".equals(Util.MANUFACTURER) || "XT1650".equals(Util.MODEL))) {
            return false;
        }
        if (Util.SDK_INT < 26 && !context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance")) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_PROTECTED_CONTENT);
    }

    public static boolean isSurfacelessContextExtensionSupported() {
        if (Util.SDK_INT < 17) {
            return false;
        }
        EGLDisplay display = EGL14.eglGetDisplay((int)0);
        String eglExtensions = EGL14.eglQueryString((EGLDisplay)display, (int)12373);
        return eglExtensions != null && eglExtensions.contains(EXTENSION_SURFACELESS_CONTEXT);
    }

    public static void checkGlError() {
        int error;
        int lastError = 0;
        while ((error = GLES20.glGetError()) != 0) {
            String string = String.valueOf(GLU.gluErrorString((int)error));
            Log.e(TAG, string.length() != 0 ? "glError ".concat(string) : new String("glError "));
            lastError = error;
        }
    }

    public static int compileProgram(String[] vertexCode, String[] fragmentCode) {
        return GlUtil.compileProgram(TextUtils.join((CharSequence)"\n", (Object[])vertexCode), TextUtils.join((CharSequence)"\n", (Object[])fragmentCode));
    }

    public static int compileProgram(String vertexCode, String fragmentCode) {
        int program = GLES20.glCreateProgram();
        GlUtil.checkGlError();
        GlUtil.addShader(35633, vertexCode, program);
        GlUtil.addShader(35632, fragmentCode, program);
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[]{0};
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            String string = String.valueOf(GLES20.glGetProgramInfoLog((int)program));
            GlUtil.throwGlError(string.length() != 0 ? "Unable to link shader program: \n".concat(string) : new String("Unable to link shader program: \n"));
        }
        GlUtil.checkGlError();
        return program;
    }

    public static Attribute[] getAttributes(int program) {
        int[] attributeCount = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35721, (int[])attributeCount, (int)0);
        if (attributeCount[0] != 2) {
            throw new IllegalStateException("expected two attributes");
        }
        Attribute[] attributes = new Attribute[attributeCount[0]];
        for (int i = 0; i < attributeCount[0]; ++i) {
            attributes[i] = new Attribute(program, i);
        }
        return attributes;
    }

    public static Uniform[] getUniforms(int program) {
        int[] uniformCount = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35718, (int[])uniformCount, (int)0);
        Uniform[] uniforms = new Uniform[uniformCount[0]];
        for (int i = 0; i < uniformCount[0]; ++i) {
            uniforms[i] = new Uniform(program, i);
        }
        return uniforms;
    }

    public static FloatBuffer createBuffer(float[] data) {
        return (FloatBuffer)GlUtil.createBuffer(data.length).put(data).flip();
    }

    public static FloatBuffer createBuffer(int capacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(capacity * 4);
        return byteBuffer.order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static int createExternalTexture() {
        int[] texId = new int[1];
        GLES20.glGenTextures((int)1, (IntBuffer)IntBuffer.wrap(texId));
        GLES20.glBindTexture((int)36197, (int)texId[0]);
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError();
        return texId[0];
    }

    private static void addShader(int type, String source, int program) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] result = new int[]{0};
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])result, (int)0);
        if (result[0] != 1) {
            String string = GLES20.glGetShaderInfoLog((int)shader);
            GlUtil.throwGlError(new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(source).length()).append(string).append(", source: ").append(source).toString());
        }
        GLES20.glAttachShader((int)program, (int)shader);
        GLES20.glDeleteShader((int)shader);
        GlUtil.checkGlError();
    }

    private static void throwGlError(String errorMsg) {
        Log.e(TAG, errorMsg);
    }

    private static int strlen(byte[] strVal) {
        for (int i = 0; i < strVal.length; ++i) {
            if (strVal[i] != 0) continue;
            return i;
        }
        return strVal.length;
    }

    public static final class Uniform {
        public final String name;
        private final int location;
        private final int type;
        private final float[] value;
        private int texId;
        private int unit;

        public Uniform(int program, int index) {
            int[] len = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35719, (int[])len, (int)0);
            int[] type = new int[1];
            int[] size = new int[1];
            byte[] name = new byte[len[0]];
            int[] ignore = new int[1];
            GLES20.glGetActiveUniform((int)program, (int)index, (int)len[0], (int[])ignore, (int)0, (int[])size, (int)0, (int[])type, (int)0, (byte[])name, (int)0);
            this.name = new String(name, 0, GlUtil.strlen(name));
            this.location = GLES20.glGetUniformLocation((int)program, (String)this.name);
            this.type = type[0];
            this.value = new float[16];
        }

        public void setSamplerTexId(int texId, int unit) {
            this.texId = texId;
            this.unit = unit;
        }

        public void setFloat(float value) {
            this.value[0] = value;
        }

        public void setFloats(float[] value) {
            System.arraycopy(value, 0, this.value, 0, value.length);
        }

        public void bind() {
            if (this.type == 5126) {
                GLES20.glUniform1fv((int)this.location, (int)1, (float[])this.value, (int)0);
                GlUtil.checkGlError();
                return;
            }
            if (this.type == 35676) {
                GLES20.glUniformMatrix4fv((int)this.location, (int)1, (boolean)false, (float[])this.value, (int)0);
                GlUtil.checkGlError();
                return;
            }
            if (this.texId == 0) {
                throw new IllegalStateException("call setSamplerTexId before bind");
            }
            GLES20.glActiveTexture((int)(33984 + this.unit));
            if (this.type == 36198) {
                GLES20.glBindTexture((int)36197, (int)this.texId);
            } else if (this.type == 35678) {
                GLES20.glBindTexture((int)3553, (int)this.texId);
            } else {
                int n = this.type;
                throw new IllegalStateException(new StringBuilder(36).append("unexpected uniform type: ").append(n).toString());
            }
            GLES20.glUniform1i((int)this.location, (int)this.unit);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GlUtil.checkGlError();
        }
    }

    public static final class Attribute {
        public final String name;
        private final int index;
        private final int location;
        @Nullable
        private Buffer buffer;
        private int size;

        public Attribute(int program, int index) {
            int[] len = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35722, (int[])len, (int)0);
            int[] type = new int[1];
            int[] size = new int[1];
            byte[] nameBytes = new byte[len[0]];
            int[] ignore = new int[1];
            GLES20.glGetActiveAttrib((int)program, (int)index, (int)len[0], (int[])ignore, (int)0, (int[])size, (int)0, (int[])type, (int)0, (byte[])nameBytes, (int)0);
            this.name = new String(nameBytes, 0, GlUtil.strlen(nameBytes));
            this.location = GLES20.glGetAttribLocation((int)program, (String)this.name);
            this.index = index;
        }

        public void setBuffer(float[] buffer, int size) {
            this.buffer = GlUtil.createBuffer(buffer);
            this.size = size;
        }

        public void bind() {
            Buffer buffer = Assertions.checkNotNull(this.buffer, "call setBuffer before bind");
            GLES20.glBindBuffer((int)34962, (int)0);
            GLES20.glVertexAttribPointer((int)this.location, (int)this.size, (int)5126, (boolean)false, (int)0, (Buffer)buffer);
            GLES20.glEnableVertexAttribArray((int)this.index);
            GlUtil.checkGlError();
        }
    }
}

