/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Util;
import java.util.Collections;
import java.util.List;

public abstract class BasePlayer
implements Player {
    protected final Timeline.Window window = new Timeline.Window();

    protected BasePlayer() {
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem) {
        this.setMediaItems(Collections.singletonList(mediaItem));
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem, long startPositionMs) {
        this.setMediaItems(Collections.singletonList(mediaItem), 0, startPositionMs);
    }

    @Override
    public final void setMediaItem(MediaItem mediaItem, boolean resetPosition) {
        this.setMediaItems(Collections.singletonList(mediaItem), resetPosition);
    }

    @Override
    public final void setMediaItems(List<MediaItem> mediaItems) {
        this.setMediaItems(mediaItems, true);
    }

    @Override
    public final void addMediaItem(int index, MediaItem mediaItem) {
        this.addMediaItems(index, Collections.singletonList(mediaItem));
    }

    @Override
    public final void addMediaItem(MediaItem mediaItem) {
        this.addMediaItems(Collections.singletonList(mediaItem));
    }

    @Override
    public final void addMediaItems(List<MediaItem> mediaItems) {
        this.addMediaItems(Integer.MAX_VALUE, mediaItems);
    }

    @Override
    public final void moveMediaItem(int currentIndex, int newIndex) {
        if (currentIndex != newIndex) {
            this.moveMediaItems(currentIndex, currentIndex + 1, newIndex);
        }
    }

    @Override
    public final void removeMediaItem(int index) {
        this.removeMediaItems(index, index + 1);
    }

    @Override
    public final void clearMediaItems() {
        this.removeMediaItems(0, Integer.MAX_VALUE);
    }

    @Override
    public final boolean isCommandAvailable(int command) {
        return this.getAvailableCommands().contains(command);
    }

    @Override
    public final void play() {
        this.setPlayWhenReady(true);
    }

    @Override
    public final void pause() {
        this.setPlayWhenReady(false);
    }

    @Override
    public final boolean isPlaying() {
        return this.getPlaybackState() == 3 && this.getPlayWhenReady() && this.getPlaybackSuppressionReason() == 0;
    }

    @Override
    public final void seekToDefaultPosition() {
        this.seekToDefaultPosition(this.getCurrentWindowIndex());
    }

    @Override
    public final void seekToDefaultPosition(int windowIndex) {
        this.seekTo(windowIndex, -9223372036854775807L);
    }

    @Override
    public final void seekTo(long positionMs) {
        this.seekTo(this.getCurrentWindowIndex(), positionMs);
    }

    @Override
    public final void seekBack() {
        this.seekToOffset(-this.getSeekBackIncrement());
    }

    @Override
    public final void seekForward() {
        this.seekToOffset(this.getSeekForwardIncrement());
    }

    @Override
    @Deprecated
    public final boolean hasPrevious() {
        return this.hasPreviousWindow();
    }

    @Override
    public final boolean hasPreviousWindow() {
        return this.getPreviousWindowIndex() != -1;
    }

    @Override
    @Deprecated
    public final void previous() {
        this.seekToPreviousWindow();
    }

    @Override
    public final void seekToPreviousWindow() {
        int previousWindowIndex = this.getPreviousWindowIndex();
        if (previousWindowIndex != -1) {
            this.seekToDefaultPosition(previousWindowIndex);
        }
    }

    @Override
    public final void seekToPrevious() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty() || this.isPlayingAd()) {
            return;
        }
        boolean hasPreviousWindow = this.hasPreviousWindow();
        if (this.isCurrentWindowLive() && !this.isCurrentWindowSeekable()) {
            if (hasPreviousWindow) {
                this.seekToPreviousWindow();
            }
        } else if (hasPreviousWindow && this.getCurrentPosition() <= (long)this.getMaxSeekToPreviousPosition()) {
            this.seekToPreviousWindow();
        } else {
            this.seekTo(0L);
        }
    }

    @Override
    @Deprecated
    public final boolean hasNext() {
        return this.hasNextWindow();
    }

    @Override
    public final boolean hasNextWindow() {
        return this.getNextWindowIndex() != -1;
    }

    @Override
    @Deprecated
    public final void next() {
        this.seekToNextWindow();
    }

    @Override
    public final void seekToNextWindow() {
        int nextWindowIndex = this.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            this.seekToDefaultPosition(nextWindowIndex);
        }
    }

    @Override
    public final void seekToNext() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty() || this.isPlayingAd()) {
            return;
        }
        if (this.hasNextWindow()) {
            this.seekToNextWindow();
        } else if (this.isCurrentWindowLive() && this.isCurrentWindowDynamic()) {
            this.seekToDefaultPosition();
        }
    }

    @Override
    public final void setPlaybackSpeed(float speed) {
        this.setPlaybackParameters(this.getPlaybackParameters().withSpeed(speed));
    }

    @Override
    public final void stop() {
        this.stop(false);
    }

    @Override
    public final int getNextWindowIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getNextWindowIndex(this.getCurrentWindowIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    public final int getPreviousWindowIndex() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -1 : timeline.getPreviousWindowIndex(this.getCurrentWindowIndex(), this.getRepeatModeForNavigation(), this.getShuffleModeEnabled());
    }

    @Override
    @Nullable
    public final MediaItem getCurrentMediaItem() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? null : timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).mediaItem;
    }

    @Override
    public final int getMediaItemCount() {
        return this.getCurrentTimeline().getWindowCount();
    }

    @Override
    public final MediaItem getMediaItemAt(int index) {
        return this.getCurrentTimeline().getWindow((int)index, (Timeline.Window)this.window).mediaItem;
    }

    @Override
    @Nullable
    public final Object getCurrentManifest() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? null : timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).manifest;
    }

    @Override
    public final int getBufferedPercentage() {
        long position = this.getBufferedPosition();
        long duration = this.getDuration();
        return position == -9223372036854775807L || duration == -9223372036854775807L ? 0 : (duration == 0L ? 100 : Util.constrainValue((int)(position * 100L / duration), 0, 100));
    }

    @Override
    public final boolean isCurrentWindowDynamic() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).isDynamic;
    }

    @Override
    public final boolean isCurrentWindowLive() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow(this.getCurrentWindowIndex(), this.window).isLive();
    }

    @Override
    public final long getCurrentLiveOffset() {
        Timeline timeline = this.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return -9223372036854775807L;
        }
        long windowStartTimeMs = timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).windowStartTimeMs;
        if (windowStartTimeMs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        return this.window.getCurrentUnixTimeMs() - this.window.windowStartTimeMs - this.getContentPosition();
    }

    @Override
    public final boolean isCurrentWindowSeekable() {
        Timeline timeline = this.getCurrentTimeline();
        return !timeline.isEmpty() && timeline.getWindow((int)this.getCurrentWindowIndex(), (Timeline.Window)this.window).isSeekable;
    }

    @Override
    public final long getContentDuration() {
        Timeline timeline = this.getCurrentTimeline();
        return timeline.isEmpty() ? -9223372036854775807L : timeline.getWindow(this.getCurrentWindowIndex(), this.window).getDurationMs();
    }

    protected Player.Commands getAvailableCommands(Player.Commands permanentAvailableCommands) {
        return new Player.Commands.Builder().addAll(permanentAvailableCommands).addIf(3, !this.isPlayingAd()).addIf(4, this.isCurrentWindowSeekable() && !this.isPlayingAd()).addIf(5, this.hasPreviousWindow() && !this.isPlayingAd()).addIf(6, !this.getCurrentTimeline().isEmpty() && (this.hasPreviousWindow() || !this.isCurrentWindowLive() || this.isCurrentWindowSeekable()) && !this.isPlayingAd()).addIf(7, this.hasNextWindow() && !this.isPlayingAd()).addIf(8, !this.getCurrentTimeline().isEmpty() && (this.hasNextWindow() || this.isCurrentWindowLive() && this.isCurrentWindowDynamic()) && !this.isPlayingAd()).addIf(9, !this.isPlayingAd()).addIf(10, this.isCurrentWindowSeekable() && !this.isPlayingAd()).addIf(11, this.isCurrentWindowSeekable() && !this.isPlayingAd()).build();
    }

    private int getRepeatModeForNavigation() {
        int repeatMode = this.getRepeatMode();
        return repeatMode == 1 ? 0 : repeatMode;
    }

    private void seekToOffset(long offsetMs) {
        long positionMs = this.getCurrentPosition() + offsetMs;
        long durationMs = this.getDuration();
        if (durationMs != -9223372036854775807L) {
            positionMs = Math.min(positionMs, durationMs);
        }
        positionMs = Math.max(positionMs, 0L);
        this.seekTo(positionMs);
    }
}

