/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Looper;
import android.os.Message;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.android.exoplayer2.util.MutableFlags;
import com.google.common.base.Supplier;
import java.util.ArrayDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;

public final class ListenerSet<T, E extends MutableFlags> {
    private static final int MSG_ITERATION_FINISHED = 0;
    private static final int MSG_LAZY_RELEASE = 1;
    private final Clock clock;
    private final HandlerWrapper handler;
    private final Supplier<E> eventFlagsSupplier;
    private final IterationFinishedEvent<T, E> iterationFinishedEvent;
    private final CopyOnWriteArraySet<ListenerHolder<T, E>> listeners;
    private final ArrayDeque<Runnable> flushingEvents;
    private final ArrayDeque<Runnable> queuedEvents;
    private boolean released;

    public ListenerSet(Looper looper, Clock clock, Supplier<E> eventFlagsSupplier, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        this(new CopyOnWriteArraySet<ListenerHolder<T, E>>(), looper, clock, eventFlagsSupplier, iterationFinishedEvent);
    }

    private ListenerSet(CopyOnWriteArraySet<ListenerHolder<T, E>> listeners, Looper looper, Clock clock, Supplier<E> eventFlagsSupplier, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        HandlerWrapper handler;
        this.clock = clock;
        this.listeners = listeners;
        this.eventFlagsSupplier = eventFlagsSupplier;
        this.iterationFinishedEvent = iterationFinishedEvent;
        this.flushingEvents = new ArrayDeque();
        this.queuedEvents = new ArrayDeque();
        this.handler = handler = clock.createHandler(looper, this::handleMessage);
    }

    @CheckResult
    public ListenerSet<T, E> copy(Looper looper, IterationFinishedEvent<T, E> iterationFinishedEvent) {
        return new ListenerSet<T, E>(this.listeners, looper, this.clock, this.eventFlagsSupplier, iterationFinishedEvent);
    }

    public void add(T listener) {
        if (this.released) {
            return;
        }
        Assertions.checkNotNull(listener);
        this.listeners.add(new ListenerHolder<T, E>(listener, this.eventFlagsSupplier));
    }

    public void remove(T listener) {
        for (ListenerHolder<T, E> listenerHolder : this.listeners) {
            if (!listenerHolder.listener.equals(listener)) continue;
            listenerHolder.release(this.iterationFinishedEvent);
            this.listeners.remove(listenerHolder);
        }
    }

    public void queueEvent(int eventFlag, Event<T> event) {
        CopyOnWriteArraySet listenerSnapshot = new CopyOnWriteArraySet(this.listeners);
        this.queuedEvents.add(() -> {
            for (ListenerHolder holder : listenerSnapshot) {
                holder.invoke(eventFlag, event);
            }
        });
    }

    public void flushEvents() {
        if (this.queuedEvents.isEmpty()) {
            return;
        }
        if (!this.handler.hasMessages(0)) {
            this.handler.obtainMessage(0).sendToTarget();
        }
        boolean recursiveFlushInProgress = !this.flushingEvents.isEmpty();
        this.flushingEvents.addAll(this.queuedEvents);
        this.queuedEvents.clear();
        if (recursiveFlushInProgress) {
            return;
        }
        while (!this.flushingEvents.isEmpty()) {
            this.flushingEvents.peekFirst().run();
            this.flushingEvents.removeFirst();
        }
    }

    public void sendEvent(int eventFlag, Event<T> event) {
        this.queueEvent(eventFlag, event);
        this.flushEvents();
    }

    public void release() {
        for (ListenerHolder<T, E> listenerHolder : this.listeners) {
            listenerHolder.release(this.iterationFinishedEvent);
        }
        this.listeners.clear();
        this.released = true;
    }

    public void lazyRelease(int releaseEventFlag, Event<T> releaseEvent) {
        this.handler.obtainMessage(1, releaseEventFlag, 0, releaseEvent).sendToTarget();
    }

    private boolean handleMessage(Message message) {
        if (message.what == 0) {
            for (ListenerHolder<T, E> holder : this.listeners) {
                holder.iterationFinished(this.eventFlagsSupplier, this.iterationFinishedEvent);
                if (!this.handler.hasMessages(0)) continue;
                break;
            }
        } else if (message.what == 1) {
            int releaseEventFlag = message.arg1;
            Event releaseEvent = (Event)message.obj;
            this.sendEvent(releaseEventFlag, releaseEvent);
            this.release();
        }
        return true;
    }

    private static final class ListenerHolder<T, E extends MutableFlags> {
        @Nonnull
        public final T listener;
        private E eventsFlags;
        private boolean needsIterationFinishedEvent;
        private boolean released;

        public ListenerHolder(@Nonnull T listener, Supplier<E> eventFlagSupplier) {
            this.listener = listener;
            this.eventsFlags = (MutableFlags)eventFlagSupplier.get();
        }

        public void release(IterationFinishedEvent<T, E> event) {
            this.released = true;
            if (this.needsIterationFinishedEvent) {
                event.invoke(this.listener, this.eventsFlags);
            }
        }

        public void invoke(int eventFlag, Event<T> event) {
            if (!this.released) {
                if (eventFlag != -1) {
                    ((MutableFlags)this.eventsFlags).add(eventFlag);
                }
                this.needsIterationFinishedEvent = true;
                event.invoke(this.listener);
            }
        }

        public void iterationFinished(Supplier<E> eventFlagSupplier, IterationFinishedEvent<T, E> event) {
            if (!this.released && this.needsIterationFinishedEvent) {
                E flagToNotify = this.eventsFlags;
                this.eventsFlags = (MutableFlags)eventFlagSupplier.get();
                this.needsIterationFinishedEvent = false;
                event.invoke(this.listener, flagToNotify);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.listener.equals(((ListenerHolder)other).listener);
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    public static interface IterationFinishedEvent<T, E extends MutableFlags> {
        public void invoke(T var1, E var2);
    }

    public static interface Event<T> {
        public void invoke(T var1);
    }
}

