/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import android.graphics.Bitmap;
import android.text.Layout;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Cue {
    public static final Cue EMPTY = new Builder().setText("").build();
    public static final float DIMEN_UNSET = -3.4028235E38f;
    public static final int TYPE_UNSET = Integer.MIN_VALUE;
    public static final int ANCHOR_TYPE_START = 0;
    public static final int ANCHOR_TYPE_MIDDLE = 1;
    public static final int ANCHOR_TYPE_END = 2;
    public static final int LINE_TYPE_FRACTION = 0;
    public static final int LINE_TYPE_NUMBER = 1;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL = 0;
    public static final int TEXT_SIZE_TYPE_FRACTIONAL_IGNORE_PADDING = 1;
    public static final int TEXT_SIZE_TYPE_ABSOLUTE = 2;
    public static final int VERTICAL_TYPE_RL = 1;
    public static final int VERTICAL_TYPE_LR = 2;
    @Nullable
    public final CharSequence text;
    @Nullable
    public final Layout.Alignment textAlignment;
    @Nullable
    public final Bitmap bitmap;
    public final float line;
    public final int lineType;
    public final int lineAnchor;
    public final float position;
    public final int positionAnchor;
    public final float size;
    public final float bitmapHeight;
    public final boolean windowColorSet;
    public final int windowColor;
    public final int textSizeType;
    public final float textSize;
    public final int verticalType;
    public final float shearDegrees;

    @Deprecated
    public Cue(CharSequence text) {
        this(text, null, -3.4028235E38f, Integer.MIN_VALUE, Integer.MIN_VALUE, -3.4028235E38f, Integer.MIN_VALUE, -3.4028235E38f);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size) {
        this(text, textAlignment, line, lineType, lineAnchor, position, positionAnchor, size, false, -16777216);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, int textSizeType, float textSize) {
        this(text, textAlignment, null, line, lineType, lineAnchor, position, positionAnchor, textSizeType, textSize, size, -3.4028235E38f, false, -16777216, Integer.MIN_VALUE, 0.0f);
    }

    @Deprecated
    public Cue(CharSequence text, @Nullable Layout.Alignment textAlignment, float line, int lineType, int lineAnchor, float position, int positionAnchor, float size, boolean windowColorSet, int windowColor) {
        this(text, textAlignment, null, line, lineType, lineAnchor, position, positionAnchor, Integer.MIN_VALUE, -3.4028235E38f, size, -3.4028235E38f, windowColorSet, windowColor, Integer.MIN_VALUE, 0.0f);
    }

    private Cue(@Nullable CharSequence text, @Nullable Layout.Alignment textAlignment, @Nullable Bitmap bitmap, float line, int lineType, int lineAnchor, float position, int positionAnchor, int textSizeType, float textSize, float size, float bitmapHeight, boolean windowColorSet, int windowColor, int verticalType, float shearDegrees) {
        if (text == null) {
            Assertions.checkNotNull(bitmap);
        } else {
            Assertions.checkArgument(bitmap == null);
        }
        this.text = text;
        this.textAlignment = textAlignment;
        this.bitmap = bitmap;
        this.line = line;
        this.lineType = lineType;
        this.lineAnchor = lineAnchor;
        this.position = position;
        this.positionAnchor = positionAnchor;
        this.size = size;
        this.bitmapHeight = bitmapHeight;
        this.windowColorSet = windowColorSet;
        this.windowColor = windowColor;
        this.textSizeType = textSizeType;
        this.textSize = textSize;
        this.verticalType = verticalType;
        this.shearDegrees = shearDegrees;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        @Nullable
        private CharSequence text;
        @Nullable
        private Bitmap bitmap;
        @Nullable
        private Layout.Alignment textAlignment;
        private float line;
        private int lineType;
        private int lineAnchor;
        private float position;
        private int positionAnchor;
        private int textSizeType;
        private float textSize;
        private float size;
        private float bitmapHeight;
        private boolean windowColorSet;
        @ColorInt
        private int windowColor;
        private int verticalType;
        private float shearDegrees;

        public Builder() {
            this.text = null;
            this.bitmap = null;
            this.textAlignment = null;
            this.line = -3.4028235E38f;
            this.lineType = Integer.MIN_VALUE;
            this.lineAnchor = Integer.MIN_VALUE;
            this.position = -3.4028235E38f;
            this.positionAnchor = Integer.MIN_VALUE;
            this.textSizeType = Integer.MIN_VALUE;
            this.textSize = -3.4028235E38f;
            this.size = -3.4028235E38f;
            this.bitmapHeight = -3.4028235E38f;
            this.windowColorSet = false;
            this.windowColor = -16777216;
            this.verticalType = Integer.MIN_VALUE;
        }

        private Builder(Cue cue) {
            this.text = cue.text;
            this.bitmap = cue.bitmap;
            this.textAlignment = cue.textAlignment;
            this.line = cue.line;
            this.lineType = cue.lineType;
            this.lineAnchor = cue.lineAnchor;
            this.position = cue.position;
            this.positionAnchor = cue.positionAnchor;
            this.textSizeType = cue.textSizeType;
            this.textSize = cue.textSize;
            this.size = cue.size;
            this.bitmapHeight = cue.bitmapHeight;
            this.windowColorSet = cue.windowColorSet;
            this.windowColor = cue.windowColor;
            this.verticalType = cue.verticalType;
            this.shearDegrees = cue.shearDegrees;
        }

        public Builder setText(CharSequence text) {
            this.text = text;
            return this;
        }

        @Nullable
        public CharSequence getText() {
            return this.text;
        }

        public Builder setBitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return this;
        }

        @Nullable
        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public Builder setTextAlignment(@Nullable Layout.Alignment textAlignment) {
            this.textAlignment = textAlignment;
            return this;
        }

        @Nullable
        public Layout.Alignment getTextAlignment() {
            return this.textAlignment;
        }

        public Builder setLine(float line, int lineType) {
            this.line = line;
            this.lineType = lineType;
            return this;
        }

        public float getLine() {
            return this.line;
        }

        public int getLineType() {
            return this.lineType;
        }

        public Builder setLineAnchor(int lineAnchor) {
            this.lineAnchor = lineAnchor;
            return this;
        }

        public int getLineAnchor() {
            return this.lineAnchor;
        }

        public Builder setPosition(float position) {
            this.position = position;
            return this;
        }

        public float getPosition() {
            return this.position;
        }

        public Builder setPositionAnchor(int positionAnchor) {
            this.positionAnchor = positionAnchor;
            return this;
        }

        public int getPositionAnchor() {
            return this.positionAnchor;
        }

        public Builder setTextSize(float textSize, int textSizeType) {
            this.textSize = textSize;
            this.textSizeType = textSizeType;
            return this;
        }

        public int getTextSizeType() {
            return this.textSizeType;
        }

        public float getTextSize() {
            return this.textSize;
        }

        public Builder setSize(float size) {
            this.size = size;
            return this;
        }

        public float getSize() {
            return this.size;
        }

        public Builder setBitmapHeight(float bitmapHeight) {
            this.bitmapHeight = bitmapHeight;
            return this;
        }

        public float getBitmapHeight() {
            return this.bitmapHeight;
        }

        public Builder setWindowColor(@ColorInt int windowColor) {
            this.windowColor = windowColor;
            this.windowColorSet = true;
            return this;
        }

        public Builder clearWindowColor() {
            this.windowColorSet = false;
            return this;
        }

        public boolean isWindowColorSet() {
            return this.windowColorSet;
        }

        @ColorInt
        public int getWindowColor() {
            return this.windowColor;
        }

        public Builder setVerticalType(int verticalType) {
            this.verticalType = verticalType;
            return this;
        }

        public Builder setShearDegrees(float shearDegrees) {
            this.shearDegrees = shearDegrees;
            return this;
        }

        public int getVerticalType() {
            return this.verticalType;
        }

        public Cue build() {
            return new Cue(this.text, this.textAlignment, this.bitmap, this.line, this.lineType, this.lineAnchor, this.position, this.positionAnchor, this.textSizeType, this.textSize, this.size, this.bitmapHeight, this.windowColorSet, this.windowColor, this.verticalType, this.shearDegrees);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerticalType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextSizeType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LineType {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnchorType {
    }
}

