/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.mp4;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class SlowMotionData
implements Metadata.Entry {
    public final List<Segment> segments;
    public static final Parcelable.Creator<SlowMotionData> CREATOR = new Parcelable.Creator<SlowMotionData>(){

        public SlowMotionData createFromParcel(Parcel in) {
            ArrayList<Segment> slowMotionSegments = new ArrayList<Segment>();
            in.readList(slowMotionSegments, Segment.class.getClassLoader());
            return new SlowMotionData(slowMotionSegments);
        }

        public SlowMotionData[] newArray(int size) {
            return new SlowMotionData[size];
        }
    };

    public SlowMotionData(List<Segment> segments) {
        this.segments = segments;
        Assertions.checkArgument(!SlowMotionData.doSegmentsOverlap(segments));
    }

    public String toString() {
        return "SlowMotion: segments=" + this.segments;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlowMotionData that = (SlowMotionData)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeList(this.segments);
    }

    private static boolean doSegmentsOverlap(List<Segment> segments) {
        if (segments.isEmpty()) {
            return false;
        }
        long previousEndTimeMs = segments.get((int)0).endTimeMs;
        for (int i = 1; i < segments.size(); ++i) {
            if (segments.get((int)i).startTimeMs < previousEndTimeMs) {
                return true;
            }
            previousEndTimeMs = segments.get((int)i).endTimeMs;
        }
        return false;
    }

    public static final class Segment
    implements Parcelable {
        public static final Comparator<Segment> BY_START_THEN_END_THEN_DIVISOR = (s1, s2) -> ComparisonChain.start().compare(s1.startTimeMs, s2.startTimeMs).compare(s1.endTimeMs, s2.endTimeMs).compare(s1.speedDivisor, s2.speedDivisor).result();
        public final long startTimeMs;
        public final long endTimeMs;
        public final int speedDivisor;
        public static final Parcelable.Creator<Segment> CREATOR = new Parcelable.Creator<Segment>(){

            public Segment createFromParcel(Parcel in) {
                long startTimeMs = in.readLong();
                long endTimeMs = in.readLong();
                int speedDivisor = in.readInt();
                return new Segment(startTimeMs, endTimeMs, speedDivisor);
            }

            public Segment[] newArray(int size) {
                return new Segment[size];
            }
        };

        public Segment(long startTimeMs, long endTimeMs, int speedDivisor) {
            Assertions.checkArgument(startTimeMs < endTimeMs);
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.speedDivisor = speedDivisor;
        }

        public String toString() {
            return Util.formatInvariant("Segment: startTimeMs=%d, endTimeMs=%d, speedDivisor=%d", this.startTimeMs, this.endTimeMs, this.speedDivisor);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.startTimeMs == segment.startTimeMs && this.endTimeMs == segment.endTimeMs && this.speedDivisor == segment.speedDivisor;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.startTimeMs, this.endTimeMs, this.speedDivisor});
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.startTimeMs);
            dest.writeLong(this.endTimeMs);
            dest.writeInt(this.speedDivisor);
        }
    }
}

