/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ExoPlaybackException
extends Exception {
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_UNEXPECTED = 2;
    public static final int TYPE_REMOTE = 3;
    public final int type;
    @Nullable
    public final String rendererName;
    public final int rendererIndex;
    @Nullable
    public final Format rendererFormat;
    public final int rendererFormatSupport;
    public final long timestampMs;
    @Nullable
    public final MediaPeriodId mediaPeriodId;
    final boolean isRecoverable;
    @Nullable
    private final Throwable cause;

    public static ExoPlaybackException createForSource(IOException cause) {
        return new ExoPlaybackException(0, (Throwable)cause);
    }

    public static ExoPlaybackException createForRenderer(Exception cause) {
        return new ExoPlaybackException(1, cause, null, null, -1, null, 4, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        return ExoPlaybackException.createForRenderer(cause, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, false);
    }

    public static ExoPlaybackException createForRenderer(Throwable cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable) {
        return new ExoPlaybackException(1, cause, null, rendererName, rendererIndex, rendererFormat, rendererFormat == null ? 4 : rendererFormatSupport, isRecoverable);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException cause) {
        return new ExoPlaybackException(2, (Throwable)cause);
    }

    public static ExoPlaybackException createForRemote(String message) {
        return new ExoPlaybackException(3, message);
    }

    private ExoPlaybackException(int type, Throwable cause) {
        this(type, cause, null, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, String message) {
        this(type, null, message, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, @Nullable Throwable cause, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable) {
        this(ExoPlaybackException.deriveMessage(type, customMessage, rendererName, rendererIndex, rendererFormat, rendererFormatSupport), cause, type, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, null, SystemClock.elapsedRealtime(), isRecoverable);
    }

    private ExoPlaybackException(@Nullable String message, @Nullable Throwable cause, int type, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, @Nullable MediaPeriodId mediaPeriodId, long timestampMs, boolean isRecoverable) {
        super(message, cause);
        this.type = type;
        this.cause = cause;
        this.rendererName = rendererName;
        this.rendererIndex = rendererIndex;
        this.rendererFormat = rendererFormat;
        this.rendererFormatSupport = rendererFormatSupport;
        this.mediaPeriodId = mediaPeriodId;
        this.timestampMs = timestampMs;
        this.isRecoverable = isRecoverable;
    }

    public IOException getSourceException() {
        Assertions.checkState(this.type == 0);
        return (IOException)Assertions.checkNotNull(this.cause);
    }

    public Exception getRendererException() {
        Assertions.checkState(this.type == 1);
        return (Exception)Assertions.checkNotNull(this.cause);
    }

    public RuntimeException getUnexpectedException() {
        Assertions.checkState(this.type == 2);
        return (RuntimeException)Assertions.checkNotNull(this.cause);
    }

    @CheckResult
    ExoPlaybackException copyWithMediaPeriodId(@Nullable MediaPeriodId mediaPeriodId) {
        return new ExoPlaybackException(this.getMessage(), this.cause, this.type, this.rendererName, this.rendererIndex, this.rendererFormat, this.rendererFormatSupport, mediaPeriodId, this.timestampMs, this.isRecoverable);
    }

    @Nullable
    private static String deriveMessage(int type, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        String string;
        String message;
        switch (type) {
            case 0: {
                message = "Source error";
                break;
            }
            case 1: {
                string = String.valueOf(rendererFormat);
                String string2 = C.getFormatSupportString(rendererFormatSupport);
                message = new StringBuilder(53 + String.valueOf(rendererName).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(rendererName).append(" error, index=").append(rendererIndex).append(", format=").append(string).append(", format_supported=").append(string2).toString();
                break;
            }
            case 3: {
                message = "Remote error";
                break;
            }
            default: {
                message = "Unexpected runtime error";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)customMessage)) {
            string = String.valueOf(message);
            message = new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(customMessage).length()).append(string).append(": ").append(customMessage).toString();
        }
        return message;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

