/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.dashclock.api.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.apps.dashclock.api.internal.IExtensionHost;

public interface IExtension
extends IInterface {
    public void onInitialize(IExtensionHost var1, boolean var2) throws RemoteException;

    public void onUpdate(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IExtension {
        private static final String DESCRIPTOR = "com.google.android.apps.dashclock.api.internal.IExtension";
        static final int TRANSACTION_onInitialize = 1;
        static final int TRANSACTION_onUpdate = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IExtension asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IExtension) {
                return (IExtension)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    IExtensionHost _arg0 = IExtensionHost.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = 0 != data.readInt();
                    this.onInitialize(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.onUpdate(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IExtension {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInitialize(IExtensionHost host, boolean isReconnect) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(host != null ? host.asBinder() : null);
                    _data.writeInt(isReconnect ? 1 : 0);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUpdate(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

