/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.database;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import com.google.android.agera.Preconditions;
import java.util.Arrays;

public final class SqlUpdateRequest {
    @NonNull
    final ContentValues contentValues;
    @NonNull
    final String[] arguments;
    @NonNull
    final String table;
    @NonNull
    final String where;
    final int conflictAlgorithm;

    SqlUpdateRequest(@NonNull ContentValues contentValues, @NonNull String[] arguments, @NonNull String table, @NonNull String where, int conflictAlgorithm) {
        this.conflictAlgorithm = conflictAlgorithm;
        this.table = (String)Preconditions.checkNotNull((Object)table);
        this.where = (String)Preconditions.checkNotNull((Object)where);
        this.contentValues = (ContentValues)Preconditions.checkNotNull((Object)contentValues);
        this.arguments = (String[])Preconditions.checkNotNull((Object)arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlUpdateRequest)) {
            return false;
        }
        SqlUpdateRequest that = (SqlUpdateRequest)o;
        return this.conflictAlgorithm == that.conflictAlgorithm && this.contentValues.equals((Object)that.contentValues) && Arrays.equals(this.arguments, that.arguments) && this.table.equals(that.table) && this.where.equals(that.where);
    }

    public int hashCode() {
        int result = this.contentValues.hashCode();
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + this.table.hashCode();
        result = 31 * result + this.where.hashCode();
        result = 31 * result + this.conflictAlgorithm;
        return result;
    }

    public String toString() {
        return "SqlUpdateRequest{contentValues=" + this.contentValues + ", arguments=" + Arrays.toString(this.arguments) + ", table='" + this.table + '\'' + ", where='" + this.where + '\'' + ", conflictAlgorithm=" + this.conflictAlgorithm + '}';
    }
}

