/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.database;

import android.content.ContentValues;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.agera.Preconditions;
import com.google.android.agera.database.SqlDeleteRequest;
import com.google.android.agera.database.SqlInsertRequest;
import com.google.android.agera.database.SqlRequest;
import com.google.android.agera.database.SqlRequestCompilerStates;
import com.google.android.agera.database.SqlUpdateRequest;

final class SqlRequestCompiler
implements SqlRequestCompilerStates.DBTable,
SqlRequestCompilerStates.DBSql,
SqlRequestCompilerStates.DBArgumentCompile,
SqlRequestCompilerStates.DBColumnConflictCompile,
SqlRequestCompilerStates.DBWhereCompile,
SqlRequestCompilerStates.DBColumnWhereConflictCompile,
SqlRequestCompilerStates.DBArgumentConflictCompile {
    static final int SQL_REQUEST = 0;
    static final int SQL_DELETE_REQUEST = 1;
    static final int SQL_UPDATE_REQUEST = 2;
    static final int SQL_INSERT_REQUEST = 3;
    @NonNull
    private static final String[] NO_ARGUMENTS = new String[0];
    @NonNull
    private static final String ERROR_MESSAGE = "Sql compiler cannot be reused";
    private final int type;
    @NonNull
    private final ContentValues contentValues;
    @NonNull
    private String[] arguments;
    @NonNull
    private String table;
    @NonNull
    private String query;
    @NonNull
    private String where;
    private boolean compiled;
    private int conflictAlgorithm;

    SqlRequestCompiler(int type) {
        this.type = type;
        this.where = "";
        this.contentValues = new ContentValues();
        this.arguments = NO_ARGUMENTS;
        this.compiled = false;
        this.table = "";
        this.query = "";
        this.conflictAlgorithm = 0;
    }

    @NonNull
    public Object table(@NonNull String table) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.table = table;
        return this;
    }

    @NonNull
    public SqlRequestCompiler sql(@NonNull String query) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.query = query;
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable String value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Byte value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Short value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Integer value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Long value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Float value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Double value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable Boolean value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object column(@NonNull String column, @Nullable byte[] value) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.put((String)Preconditions.checkNotNull((Object)column), value);
        return this;
    }

    @Override
    @NonNull
    public Object emptyColumn(@NonNull String column) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.contentValues.putNull((String)Preconditions.checkNotNull((Object)column));
        return this;
    }

    @Override
    @NonNull
    public Object where(@NonNull String where) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.where = where;
        return this;
    }

    @Override
    @NonNull
    public Object arguments(String ... arguments) {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.arguments = (String[])arguments.clone();
        return this;
    }

    @Override
    @NonNull
    public Object failOnConflict() {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.conflictAlgorithm = 3;
        return this;
    }

    @Override
    @NonNull
    public Object ignoreOnConflict() {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.conflictAlgorithm = 4;
        return this;
    }

    @Override
    @NonNull
    public Object replaceOnConflict() {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.conflictAlgorithm = 5;
        return this;
    }

    @Override
    @NonNull
    public Object compile() {
        Preconditions.checkState((!this.compiled ? 1 : 0) != 0, (String)ERROR_MESSAGE);
        this.compiled = true;
        switch (this.type) {
            case 1: {
                return new SqlDeleteRequest(this.arguments, this.table, this.where);
            }
            case 3: {
                return new SqlInsertRequest(this.contentValues, this.table, this.conflictAlgorithm);
            }
            case 2: {
                return new SqlUpdateRequest(this.contentValues, this.arguments, this.table, this.where, this.conflictAlgorithm);
            }
        }
        return new SqlRequest(this.arguments, this.query);
    }
}

