/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.marketingplatform.admin.v1alpha;

import com.google.ads.marketingplatform.admin.v1alpha.AnalyticsAccountLink;
import com.google.ads.marketingplatform.admin.v1alpha.AnalyticsAccountLinkName;
import com.google.ads.marketingplatform.admin.v1alpha.CreateAnalyticsAccountLinkRequest;
import com.google.ads.marketingplatform.admin.v1alpha.DeleteAnalyticsAccountLinkRequest;
import com.google.ads.marketingplatform.admin.v1alpha.FindSalesPartnerManagedClientsRequest;
import com.google.ads.marketingplatform.admin.v1alpha.FindSalesPartnerManagedClientsResponse;
import com.google.ads.marketingplatform.admin.v1alpha.GetOrganizationRequest;
import com.google.ads.marketingplatform.admin.v1alpha.ListAnalyticsAccountLinksRequest;
import com.google.ads.marketingplatform.admin.v1alpha.ListAnalyticsAccountLinksResponse;
import com.google.ads.marketingplatform.admin.v1alpha.ListOrganizationsRequest;
import com.google.ads.marketingplatform.admin.v1alpha.ListOrganizationsResponse;
import com.google.ads.marketingplatform.admin.v1alpha.MarketingplatformAdminServiceSettings;
import com.google.ads.marketingplatform.admin.v1alpha.Organization;
import com.google.ads.marketingplatform.admin.v1alpha.OrganizationName;
import com.google.ads.marketingplatform.admin.v1alpha.ReportPropertyUsageRequest;
import com.google.ads.marketingplatform.admin.v1alpha.ReportPropertyUsageResponse;
import com.google.ads.marketingplatform.admin.v1alpha.SetPropertyServiceLevelRequest;
import com.google.ads.marketingplatform.admin.v1alpha.SetPropertyServiceLevelResponse;
import com.google.ads.marketingplatform.admin.v1alpha.stub.MarketingplatformAdminServiceStub;
import com.google.ads.marketingplatform.admin.v1alpha.stub.MarketingplatformAdminServiceStubSettings;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MarketingplatformAdminServiceClient
implements BackgroundResource {
    private final MarketingplatformAdminServiceSettings settings;
    private final MarketingplatformAdminServiceStub stub;

    public static final MarketingplatformAdminServiceClient create() throws IOException {
        return MarketingplatformAdminServiceClient.create(MarketingplatformAdminServiceSettings.newBuilder().build());
    }

    public static final MarketingplatformAdminServiceClient create(MarketingplatformAdminServiceSettings settings) throws IOException {
        return new MarketingplatformAdminServiceClient(settings);
    }

    public static final MarketingplatformAdminServiceClient create(MarketingplatformAdminServiceStub stub) {
        return new MarketingplatformAdminServiceClient(stub);
    }

    protected MarketingplatformAdminServiceClient(MarketingplatformAdminServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MarketingplatformAdminServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MarketingplatformAdminServiceClient(MarketingplatformAdminServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MarketingplatformAdminServiceSettings getSettings() {
        return this.settings;
    }

    public MarketingplatformAdminServiceStub getStub() {
        return this.stub;
    }

    public final Organization getOrganization(OrganizationName name) {
        GetOrganizationRequest request = GetOrganizationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganization(request);
    }

    public final Organization getOrganization(String name) {
        GetOrganizationRequest request = GetOrganizationRequest.newBuilder().setName(name).build();
        return this.getOrganization(request);
    }

    public final Organization getOrganization(GetOrganizationRequest request) {
        return (Organization)this.getOrganizationCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationRequest, Organization> getOrganizationCallable() {
        return this.stub.getOrganizationCallable();
    }

    public final ListOrganizationsPagedResponse listOrganizations(ListOrganizationsRequest request) {
        return (ListOrganizationsPagedResponse)((Object)this.listOrganizationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrganizationsRequest, ListOrganizationsPagedResponse> listOrganizationsPagedCallable() {
        return this.stub.listOrganizationsPagedCallable();
    }

    public final UnaryCallable<ListOrganizationsRequest, ListOrganizationsResponse> listOrganizationsCallable() {
        return this.stub.listOrganizationsCallable();
    }

    public final FindSalesPartnerManagedClientsResponse findSalesPartnerManagedClients(FindSalesPartnerManagedClientsRequest request) {
        return (FindSalesPartnerManagedClientsResponse)this.findSalesPartnerManagedClientsCallable().call((Object)request);
    }

    public final UnaryCallable<FindSalesPartnerManagedClientsRequest, FindSalesPartnerManagedClientsResponse> findSalesPartnerManagedClientsCallable() {
        return this.stub.findSalesPartnerManagedClientsCallable();
    }

    public final ListAnalyticsAccountLinksPagedResponse listAnalyticsAccountLinks(OrganizationName parent) {
        ListAnalyticsAccountLinksRequest request = ListAnalyticsAccountLinksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnalyticsAccountLinks(request);
    }

    public final ListAnalyticsAccountLinksPagedResponse listAnalyticsAccountLinks(String parent) {
        ListAnalyticsAccountLinksRequest request = ListAnalyticsAccountLinksRequest.newBuilder().setParent(parent).build();
        return this.listAnalyticsAccountLinks(request);
    }

    public final ListAnalyticsAccountLinksPagedResponse listAnalyticsAccountLinks(ListAnalyticsAccountLinksRequest request) {
        return (ListAnalyticsAccountLinksPagedResponse)((Object)this.listAnalyticsAccountLinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksPagedResponse> listAnalyticsAccountLinksPagedCallable() {
        return this.stub.listAnalyticsAccountLinksPagedCallable();
    }

    public final UnaryCallable<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse> listAnalyticsAccountLinksCallable() {
        return this.stub.listAnalyticsAccountLinksCallable();
    }

    public final AnalyticsAccountLink createAnalyticsAccountLink(OrganizationName parent, AnalyticsAccountLink analyticsAccountLink) {
        CreateAnalyticsAccountLinkRequest request = CreateAnalyticsAccountLinkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAnalyticsAccountLink(analyticsAccountLink).build();
        return this.createAnalyticsAccountLink(request);
    }

    public final AnalyticsAccountLink createAnalyticsAccountLink(String parent, AnalyticsAccountLink analyticsAccountLink) {
        CreateAnalyticsAccountLinkRequest request = CreateAnalyticsAccountLinkRequest.newBuilder().setParent(parent).setAnalyticsAccountLink(analyticsAccountLink).build();
        return this.createAnalyticsAccountLink(request);
    }

    public final AnalyticsAccountLink createAnalyticsAccountLink(CreateAnalyticsAccountLinkRequest request) {
        return (AnalyticsAccountLink)this.createAnalyticsAccountLinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAnalyticsAccountLinkRequest, AnalyticsAccountLink> createAnalyticsAccountLinkCallable() {
        return this.stub.createAnalyticsAccountLinkCallable();
    }

    public final void deleteAnalyticsAccountLink(AnalyticsAccountLinkName name) {
        DeleteAnalyticsAccountLinkRequest request = DeleteAnalyticsAccountLinkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAnalyticsAccountLink(request);
    }

    public final void deleteAnalyticsAccountLink(String name) {
        DeleteAnalyticsAccountLinkRequest request = DeleteAnalyticsAccountLinkRequest.newBuilder().setName(name).build();
        this.deleteAnalyticsAccountLink(request);
    }

    public final void deleteAnalyticsAccountLink(DeleteAnalyticsAccountLinkRequest request) {
        this.deleteAnalyticsAccountLinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAnalyticsAccountLinkRequest, Empty> deleteAnalyticsAccountLinkCallable() {
        return this.stub.deleteAnalyticsAccountLinkCallable();
    }

    public final SetPropertyServiceLevelResponse setPropertyServiceLevel(String analyticsAccountLink) {
        SetPropertyServiceLevelRequest request = SetPropertyServiceLevelRequest.newBuilder().setAnalyticsAccountLink(analyticsAccountLink).build();
        return this.setPropertyServiceLevel(request);
    }

    public final SetPropertyServiceLevelResponse setPropertyServiceLevel(SetPropertyServiceLevelRequest request) {
        return (SetPropertyServiceLevelResponse)this.setPropertyServiceLevelCallable().call((Object)request);
    }

    public final UnaryCallable<SetPropertyServiceLevelRequest, SetPropertyServiceLevelResponse> setPropertyServiceLevelCallable() {
        return this.stub.setPropertyServiceLevelCallable();
    }

    public final ReportPropertyUsageResponse reportPropertyUsage(String organization) {
        ReportPropertyUsageRequest request = ReportPropertyUsageRequest.newBuilder().setOrganization(organization).build();
        return this.reportPropertyUsage(request);
    }

    public final ReportPropertyUsageResponse reportPropertyUsage(ReportPropertyUsageRequest request) {
        return (ReportPropertyUsageResponse)this.reportPropertyUsageCallable().call((Object)request);
    }

    public final UnaryCallable<ReportPropertyUsageRequest, ReportPropertyUsageResponse> reportPropertyUsageCallable() {
        return this.stub.reportPropertyUsageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAnalyticsAccountLinksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink, ListAnalyticsAccountLinksPage, ListAnalyticsAccountLinksFixedSizeCollection> {
        private ListAnalyticsAccountLinksFixedSizeCollection(List<ListAnalyticsAccountLinksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnalyticsAccountLinksFixedSizeCollection createEmptyCollection() {
            return new ListAnalyticsAccountLinksFixedSizeCollection(null, 0);
        }

        protected ListAnalyticsAccountLinksFixedSizeCollection createCollection(List<ListAnalyticsAccountLinksPage> pages, int collectionSize) {
            return new ListAnalyticsAccountLinksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnalyticsAccountLinksPage
    extends AbstractPage<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink, ListAnalyticsAccountLinksPage> {
        private ListAnalyticsAccountLinksPage(PageContext<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink> context, ListAnalyticsAccountLinksResponse response) {
            super(context, (Object)response);
        }

        private static ListAnalyticsAccountLinksPage createEmptyPage() {
            return new ListAnalyticsAccountLinksPage(null, null);
        }

        protected ListAnalyticsAccountLinksPage createPage(PageContext<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink> context, ListAnalyticsAccountLinksResponse response) {
            return new ListAnalyticsAccountLinksPage(context, response);
        }

        public ApiFuture<ListAnalyticsAccountLinksPage> createPageAsync(PageContext<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink> context, ApiFuture<ListAnalyticsAccountLinksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnalyticsAccountLinksPagedResponse
    extends AbstractPagedListResponse<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink, ListAnalyticsAccountLinksPage, ListAnalyticsAccountLinksFixedSizeCollection> {
        public static ApiFuture<ListAnalyticsAccountLinksPagedResponse> createAsync(PageContext<ListAnalyticsAccountLinksRequest, ListAnalyticsAccountLinksResponse, AnalyticsAccountLink> context, ApiFuture<ListAnalyticsAccountLinksResponse> futureResponse) {
            ApiFuture<ListAnalyticsAccountLinksPage> futurePage = ListAnalyticsAccountLinksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnalyticsAccountLinksPagedResponse((ListAnalyticsAccountLinksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnalyticsAccountLinksPagedResponse(ListAnalyticsAccountLinksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnalyticsAccountLinksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrganizationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrganizationsRequest, ListOrganizationsResponse, Organization, ListOrganizationsPage, ListOrganizationsFixedSizeCollection> {
        private ListOrganizationsFixedSizeCollection(List<ListOrganizationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrganizationsFixedSizeCollection createEmptyCollection() {
            return new ListOrganizationsFixedSizeCollection(null, 0);
        }

        protected ListOrganizationsFixedSizeCollection createCollection(List<ListOrganizationsPage> pages, int collectionSize) {
            return new ListOrganizationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrganizationsPage
    extends AbstractPage<ListOrganizationsRequest, ListOrganizationsResponse, Organization, ListOrganizationsPage> {
        private ListOrganizationsPage(PageContext<ListOrganizationsRequest, ListOrganizationsResponse, Organization> context, ListOrganizationsResponse response) {
            super(context, (Object)response);
        }

        private static ListOrganizationsPage createEmptyPage() {
            return new ListOrganizationsPage(null, null);
        }

        protected ListOrganizationsPage createPage(PageContext<ListOrganizationsRequest, ListOrganizationsResponse, Organization> context, ListOrganizationsResponse response) {
            return new ListOrganizationsPage(context, response);
        }

        public ApiFuture<ListOrganizationsPage> createPageAsync(PageContext<ListOrganizationsRequest, ListOrganizationsResponse, Organization> context, ApiFuture<ListOrganizationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrganizationsPagedResponse
    extends AbstractPagedListResponse<ListOrganizationsRequest, ListOrganizationsResponse, Organization, ListOrganizationsPage, ListOrganizationsFixedSizeCollection> {
        public static ApiFuture<ListOrganizationsPagedResponse> createAsync(PageContext<ListOrganizationsRequest, ListOrganizationsResponse, Organization> context, ApiFuture<ListOrganizationsResponse> futureResponse) {
            ApiFuture<ListOrganizationsPage> futurePage = ListOrganizationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrganizationsPagedResponse((ListOrganizationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrganizationsPagedResponse(ListOrganizationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrganizationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

