/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Tool;
import com.google.genai.types.ToolCodeExecution;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;

public final class BuiltInCodeExecutionTool
extends BaseTool {
    public BuiltInCodeExecutionTool() {
        super("code_execution", "code_execution");
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        String model = llmRequestBuilder.build().model().get();
        if (model.isEmpty() || !model.startsWith("gemini-2")) {
            return Completable.error((Throwable)new IllegalArgumentException("Code execution tool is not supported for model " + model));
        }
        GenerateContentConfig.Builder configBuilder = llmRequestBuilder.build().config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder());
        List existingTools = (List)configBuilder.build().tools().orElse(ImmutableList.of());
        ImmutableList.Builder updatedToolsBuilder = ImmutableList.builder();
        updatedToolsBuilder.addAll((Iterable)existingTools).add((Object)Tool.builder().codeExecution(ToolCodeExecution.builder().build()).build());
        configBuilder.tools((List)updatedToolsBuilder.build());
        llmRequestBuilder.config(configBuilder.build());
        return Completable.complete();
    }
}

