/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.codeexecutors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.codeexecutors.CodeExecutionUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CodeExecutorContext {
    private static final String CONTEXT_KEY = "_code_execution_context";
    private static final String SESSION_ID_KEY = "execution_session_id";
    private static final String PROCESSED_FILE_NAMES_KEY = "processed_input_files";
    private static final String INPUT_FILE_KEY = "_code_executor_input_files";
    private static final String ERROR_COUNT_KEY = "_code_executor_error_counts";
    private static final String CODE_EXECUTION_RESULTS_KEY = "_code_execution_results";
    private final Map<String, Object> sessionState;
    private final Map<String, Object> context;
    private static final ObjectMapper objectMapper = JsonBaseModel.getMapper();

    public CodeExecutorContext(Map<String, Object> sessionState) {
        this.sessionState = sessionState;
        this.context = this.getCodeExecutorContext(sessionState);
    }

    public Map<String, Object> getStateDelta() {
        HashMap<String, Object> contextToUpdate = new HashMap<String, Object>(this.context);
        return ImmutableMap.of((Object)CONTEXT_KEY, contextToUpdate);
    }

    public Optional<String> getExecutionId() {
        return Optional.ofNullable((String)this.context.get(SESSION_ID_KEY));
    }

    public void setExecutionId(String sessionId) {
        this.context.put(SESSION_ID_KEY, sessionId);
    }

    public List<String> getProcessedFileNames() {
        return this.context.getOrDefault(PROCESSED_FILE_NAMES_KEY, new ArrayList());
    }

    public void addProcessedFileNames(List<String> fileNames) {
        List processedFileNames = (List)this.context.computeIfAbsent(PROCESSED_FILE_NAMES_KEY, k -> new ArrayList());
        processedFileNames.addAll(fileNames);
    }

    public List<CodeExecutionUtils.File> getInputFiles() {
        List fileMaps = this.sessionState.getOrDefault(INPUT_FILE_KEY, new ArrayList());
        return (List)fileMaps.stream().map(fileMap -> (CodeExecutionUtils.File)objectMapper.convertValue(fileMap, CodeExecutionUtils.File.class)).collect(ImmutableList.toImmutableList());
    }

    public void addInputFiles(List<CodeExecutionUtils.File> inputFiles) {
        List fileMaps = (List)this.sessionState.computeIfAbsent(INPUT_FILE_KEY, k -> new ArrayList());
        for (CodeExecutionUtils.File inputFile : inputFiles) {
            fileMaps.add((Map)objectMapper.convertValue((Object)inputFile, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
    }

    public void clearInputFiles() {
        if (this.sessionState.containsKey(INPUT_FILE_KEY)) {
            this.sessionState.put(INPUT_FILE_KEY, new ArrayList());
        }
        if (this.context.containsKey(PROCESSED_FILE_NAMES_KEY)) {
            this.context.put(PROCESSED_FILE_NAMES_KEY, new ArrayList());
        }
    }

    public int getErrorCount(String invocationId) {
        Map errorCounts = (Map)this.sessionState.get(ERROR_COUNT_KEY);
        if (errorCounts == null) {
            return 0;
        }
        return errorCounts.getOrDefault(invocationId, 0);
    }

    public void incrementErrorCount(String invocationId) {
        Map errorCounts = (Map)this.sessionState.computeIfAbsent(ERROR_COUNT_KEY, k -> new HashMap());
        errorCounts.put(invocationId, this.getErrorCount(invocationId) + 1);
    }

    public void resetErrorCount(String invocationId) {
        if (!this.sessionState.containsKey(ERROR_COUNT_KEY)) {
            return;
        }
        Map errorCounts = (Map)this.sessionState.get(ERROR_COUNT_KEY);
        if (errorCounts != null) {
            errorCounts.remove(invocationId);
        }
    }

    public void updateCodeExecutionResult(String invocationId, String code, String resultStdout, String resultStderr) {
        Map codeExecutionResults = (Map)this.sessionState.computeIfAbsent(CODE_EXECUTION_RESULTS_KEY, k -> new HashMap());
        List resultsForInvocation = codeExecutionResults.computeIfAbsent(invocationId, k -> new ArrayList());
        HashMap<String, Object> newResult = new HashMap<String, Object>();
        newResult.put("code", code);
        newResult.put("result_stdout", resultStdout);
        newResult.put("result_stderr", resultStderr);
        newResult.put("timestamp", InstantSource.system().instant().getEpochSecond());
        resultsForInvocation.add(newResult);
    }

    private Map<String, Object> getCodeExecutorContext(Map<String, Object> sessionState) {
        return (Map)sessionState.computeIfAbsent(CONTEXT_KEY, k -> new HashMap());
    }
}

