/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.adk.JsonBaseModel;
import com.google.adk.agents.AutoValue_LiveRequest;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.genai.types.Blob;
import com.google.genai.types.Content;
import java.util.Optional;
import javax.annotation.Nullable;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LiveRequest
extends JsonBaseModel {
    LiveRequest() {
    }

    @JsonProperty(value="content")
    public abstract Optional<Content> content();

    @JsonProperty(value="blob")
    public abstract Optional<Blob> blob();

    @JsonProperty(value="close")
    public abstract Optional<Boolean> close();

    public boolean shouldClose() {
        return this.close().orElse(false);
    }

    public static Builder builder() {
        return new AutoValue_LiveRequest.Builder().close(false);
    }

    public abstract Builder toBuilder();

    public static LiveRequest fromJsonString(String json) {
        return JsonBaseModel.fromJsonString(json, LiveRequest.class);
    }

    @JsonCreator
    static Builder jacksonBuilder() {
        return LiveRequest.builder();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="content")
        public abstract Builder content(@Nullable Content var1);

        public abstract Builder content(Optional<Content> var1);

        @JsonProperty(value="blob")
        public abstract Builder blob(@Nullable Blob var1);

        public abstract Builder blob(Optional<Blob> var1);

        @JsonProperty(value="close")
        public abstract Builder close(@Nullable Boolean var1);

        public abstract Builder close(Optional<Boolean> var1);

        abstract LiveRequest autoBuild();

        public final LiveRequest build() {
            LiveRequest request = this.autoBuild();
            Preconditions.checkState((request.content().isPresent() || request.blob().isPresent() || request.close().isPresent() ? 1 : 0) != 0, (Object)"One of content, blob, or close must be set");
            return request;
        }
    }
}

