/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web;

import com.google.adk.agents.BaseAgent;
import com.google.adk.web.AgentLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nonnull;

class AgentStaticLoader
implements AgentLoader {
    private final ImmutableMap<String, BaseAgent> agents;

    public AgentStaticLoader(BaseAgent ... agents) {
        this.agents = (ImmutableMap)Arrays.stream(agents).collect(ImmutableMap.toImmutableMap(BaseAgent::name, Function.identity()));
    }

    @Override
    @Nonnull
    public ImmutableList<String> listAgents() {
        return (ImmutableList)this.agents.keySet().stream().collect(ImmutableList.toImmutableList());
    }

    @Override
    public BaseAgent loadAgent(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent name cannot be null or empty");
        }
        BaseAgent agent = (BaseAgent)this.agents.get((Object)name);
        if (agent == null) {
            throw new NoSuchElementException("Agent not found: " + name);
        }
        return agent;
    }
}

