/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.permissions.lint.util;

import com.google.accompanist.permissions.lint.util.Name;
import com.google.accompanist.permissions.lint.util.PackageName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\f\u001a\u00020\r\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u00020\u0001*\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000f"}, d2={"isInPackageName", "", "Lcom/intellij/psi/PsiMethod;", "packageName", "Lcom/google/accompanist/permissions/lint/util/PackageName;", "returnsUnit", "getReturnsUnit", "(Lcom/intellij/psi/PsiMethod;)Z", "isVoidOrUnit", "Lcom/intellij/psi/PsiType;", "(Lcom/intellij/psi/PsiType;)Z", "inheritsFrom", "name", "Lcom/google/accompanist/permissions/lint/util/Name;", "Lcom/intellij/psi/PsiClass;", "permissions-lint"})
public final class PsiUtilsKt {
    public static final boolean isInPackageName(@NotNull PsiMethod $this$isInPackageName, @NotNull PackageName packageName) {
        Intrinsics.checkNotNullParameter($this$isInPackageName, "<this>");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        PsiFile psiFile = $this$isInPackageName.getContainingFile();
        PsiClassOwner psiClassOwner = psiFile instanceof PsiClassOwner ? (PsiClassOwner)psiFile : null;
        String actual = psiClassOwner != null ? psiClassOwner.getPackageName() : null;
        return Intrinsics.areEqual(packageName.getJavaPackageName(), actual);
    }

    public static final boolean getReturnsUnit(@NotNull PsiMethod $this$returnsUnit) {
        Intrinsics.checkNotNullParameter($this$returnsUnit, "<this>");
        return PsiUtilsKt.isVoidOrUnit($this$returnsUnit.getReturnType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isVoidOrUnit(@Nullable PsiType $this$isVoidOrUnit) {
        if (Intrinsics.areEqual($this$isVoidOrUnit, PsiType.VOID)) return true;
        PsiType psiType = $this$isVoidOrUnit;
        if (!Intrinsics.areEqual(psiType != null ? psiType.getCanonicalText() : null, "kotlin.Unit")) return false;
        return true;
    }

    public static final boolean inheritsFrom(@NotNull PsiType $this$inheritsFrom, @NotNull Name name) {
        Intrinsics.checkNotNullParameter($this$inheritsFrom, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return InheritanceUtil.isInheritor((PsiType)$this$inheritsFrom, (String)name.getJavaFqn());
    }

    public static final boolean inheritsFrom(@NotNull PsiClass $this$inheritsFrom, @NotNull Name name) {
        Intrinsics.checkNotNullParameter($this$inheritsFrom, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        return InheritanceUtil.isInheritor((PsiClass)$this$inheritsFrom, (String)name.getJavaFqn());
    }
}

