/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.permissions.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.accompanist.permissions.lint.PermissionsLaunchDetectorKt;
import com.google.accompanist.permissions.lint.util.ComposableUtilsKt;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/google/accompanist/permissions/lint/PermissionsLaunchDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "permissions-lint"})
public final class PermissionsLaunchDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue PermissionLaunchedDuringComposition = Issue.Companion.create("PermissionLaunchedDuringComposition", "Calls to `launchPermissionRequest` or `launchMultiplePermissionRequest` should happen inside a regular lambda or a side-effect but never in the Composition.", "Calls to `launchPermissionRequest` or `launchMultiplePermissionRequest` in the Composition throw a runtime exception. Please call them inside a regular lambda or in a side-effect.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(PermissionsLaunchDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        String[] stringArray = new String[]{PermissionsLaunchDetectorKt.access$getLaunchPermissionRequest$p().getShortName(), PermissionsLaunchDetectorKt.access$getLaunchMultiplePermissionsRequest$p().getShortName()};
        return CollectionsKt.listOf(stringArray);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(method, "method");
        if (!PermissionsLaunchDetectorKt.access$isInPackageName(method, PermissionsLaunchDetectorKt.access$getPermissionsPackageName$p())) {
            return;
        }
        if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
            JavaContext.report$default((JavaContext)context, (Issue)PermissionLaunchedDuringComposition, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)("Calls to " + method.getName() + " should happen inside a regular lambda or  a side-effect, but never in the Composition."), null, (int)16, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/google/accompanist/permissions/lint/PermissionsLaunchDetector$Companion;", "", "<init>", "()V", "PermissionLaunchedDuringComposition", "Lcom/android/tools/lint/detector/api/Issue;", "getPermissionLaunchedDuringComposition", "()Lcom/android/tools/lint/detector/api/Issue;", "permissions-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getPermissionLaunchedDuringComposition() {
            return PermissionLaunchedDuringComposition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

