/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.permissions;

import android.app.Activity;
import android.content.Context;
import androidx.activity.result.ActivityResultLauncher;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import com.google.accompanist.permissions.ExperimentalPermissionsApi;
import com.google.accompanist.permissions.PermissionState;
import com.google.accompanist.permissions.PermissionsUtilKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010&\u001a\u00020'H\u0016J\r\u0010(\u001a\u00020'H\u0000\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020'H\u0002R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n8V@PX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR+\u0010\u001e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0011\u001a\u0004\b\u001f\u0010\r\"\u0004\b \u0010\u000fR+\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@RX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0011\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000f\u00a8\u0006+"}, d2={"Lcom/google/accompanist/permissions/MutablePermissionState;", "Lcom/google/accompanist/permissions/PermissionState;", "permission", "", "context", "Landroid/content/Context;", "activity", "Landroid/app/Activity;", "(Ljava/lang/String;Landroid/content/Context;Landroid/app/Activity;)V", "<set-?>", "", "_hasPermission", "get_hasPermission", "()Z", "set_hasPermission", "(Z)V", "_hasPermission$delegate", "Landroidx/compose/runtime/MutableState;", "value", "hasPermission", "getHasPermission", "setHasPermission$permissions_release", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "getLauncher$permissions_release", "()Landroidx/activity/result/ActivityResultLauncher;", "setLauncher$permissions_release", "(Landroidx/activity/result/ActivityResultLauncher;)V", "getPermission", "()Ljava/lang/String;", "permissionRequested", "getPermissionRequested", "setPermissionRequested", "permissionRequested$delegate", "shouldShowRationale", "getShouldShowRationale", "setShouldShowRationale", "shouldShowRationale$delegate", "launchPermissionRequest", "", "refreshHasPermission", "refreshHasPermission$permissions_release", "refreshShouldShowRationale", "permissions_release"})
@ExperimentalPermissionsApi
@Stable
public final class MutablePermissionState
implements PermissionState {
    @NotNull
    private final String permission;
    @NotNull
    private final Context context;
    @NotNull
    private final Activity activity;
    @NotNull
    private final MutableState _hasPermission$delegate;
    @NotNull
    private final MutableState shouldShowRationale$delegate;
    @NotNull
    private final MutableState permissionRequested$delegate;
    @Nullable
    private ActivityResultLauncher<String> launcher;

    public MutablePermissionState(@NotNull String permission, @NotNull Context context, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.permission = permission;
        this.context = context;
        this.activity = activity;
        this._hasPermission$delegate = SnapshotStateKt.mutableStateOf$default((Object)PermissionsUtilKt.checkPermission(this.context, this.getPermission()), null, (int)2, null);
        this.shouldShowRationale$delegate = SnapshotStateKt.mutableStateOf$default((Object)PermissionsUtilKt.shouldShowRationale(this.activity, this.getPermission()), null, (int)2, null);
        this.permissionRequested$delegate = SnapshotStateKt.mutableStateOf$default((Object)false, null, (int)2, null);
    }

    @Override
    @NotNull
    public String getPermission() {
        return this.permission;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean get_hasPermission() {
        void $this$getValue$iv;
        State state = (State)this._hasPermission$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_hasPermission(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this._hasPermission$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    @Override
    public boolean getHasPermission() {
        return this.get_hasPermission();
    }

    public void setHasPermission$permissions_release(boolean value) {
        this.set_hasPermission(value);
        this.refreshShouldShowRationale();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getShouldShowRationale() {
        void $this$getValue$iv;
        State state = (State)this.shouldShowRationale$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private void setShouldShowRationale(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.shouldShowRationale$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getPermissionRequested() {
        void $this$getValue$iv;
        State state = (State)this.permissionRequested$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void setPermissionRequested(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.permissionRequested$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    @Override
    public void launchPermissionRequest() {
        Unit unit;
        Unit unit2;
        ActivityResultLauncher<String> activityResultLauncher = this.launcher;
        if (activityResultLauncher == null) {
            unit2 = null;
        } else {
            activityResultLauncher.launch((Object)this.getPermission());
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new IllegalStateException("ActivityResultLauncher cannot be null");
        }
    }

    @Nullable
    public final ActivityResultLauncher<String> getLauncher$permissions_release() {
        return this.launcher;
    }

    public final void setLauncher$permissions_release(@Nullable ActivityResultLauncher<String> activityResultLauncher) {
        this.launcher = activityResultLauncher;
    }

    public final void refreshHasPermission$permissions_release() {
        this.setHasPermission$permissions_release(PermissionsUtilKt.checkPermission(this.context, this.getPermission()));
    }

    private final void refreshShouldShowRationale() {
        this.setShouldShowRationale(PermissionsUtilKt.shouldShowRationale(this.activity, this.getPermission()));
    }
}

