/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.pager;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.compose.animation.core.AnimationScope;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationState;
import androidx.compose.animation.core.AnimationStateKt;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.MutatePriority;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.gestures.ScrollableStateKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.ListSaverKt;
import androidx.compose.runtime.saveable.Saver;
import com.google.accompanist.pager.ExperimentalPagerApi;
import com.google.accompanist.pager.PageLayoutInfo;
import com.google.accompanist.pager.PagerState;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 }2\u00020\u0001:\u0001}B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJI\u0010I\u001a\u00020J2\b\b\u0001\u0010K\u001a\u00020\u00032\b\b\u0003\u0010L\u001a\u00020\u00062\u000e\b\u0002\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060N2\b\b\u0002\u0010O\u001a\u00020\u00062\b\b\u0002\u0010P\u001a\u00020\tH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ7\u0010R\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060N2\u0006\u0010O\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010SJ7\u0010T\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00032\u0006\u0010L\u001a\u00020\u00062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00060N2\u0006\u0010O\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010SJ\u001a\u0010U\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u00062\b\b\u0002\u0010W\u001a\u00020\u0006H\u0002J\u0010\u0010X\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u0006H\u0016JO\u0010Z\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u00062\u000e\b\u0002\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00060\\2\u000e\b\u0002\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00060N2\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060_H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b`\u0010aJ\u0015\u0010b\u001a\u00020\u00032\u0006\u0010c\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\bdJ\u0018\u0010e\u001a\u00020J2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010f\u001a\u00020gH\u0002J\u0018\u0010h\u001a\u00020J2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010f\u001a\u00020gH\u0002JB\u0010i\u001a\u00020J2\u0006\u0010j\u001a\u00020k2'\u0010l\u001a#\b\u0001\u0012\u0004\u0012\u00020n\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0o\u0012\u0006\u0012\u0004\u0018\u00010p0m\u00a2\u0006\u0002\bqH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010rJ\u0010\u0010s\u001a\u00020\u00062\u0006\u0010t\u001a\u00020\u0006H\u0002J%\u0010u\u001a\u00020J2\b\b\u0001\u0010K\u001a\u00020\u00032\b\b\u0003\u0010L\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010vJ\b\u0010w\u001a\u00020JH\u0002J\u001a\u0010x\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00032\b\b\u0002\u0010W\u001a\u00020\u0006H\u0002J\b\u0010y\u001a\u00020gH\u0016J\u0010\u0010z\u001a\u00020J2\u0006\u0010{\u001a\u00020\u0006H\u0002J\u0010\u0010|\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0003H\u0002R/\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R+\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u0012\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR\u0015\u0010#\u001a\u00020\u00068\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R\u0015\u0010%\u001a\u00020\u00038\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001bR\u000e\u0010'\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010(\u001a\u00020)8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R$\u0010-\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00068@@BX\u0080\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0015\"\u0004\b/\u0010\u0017R\u0015\u00100\u001a\u00020\u00038\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001bR$\u0010\u0004\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00038G@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0015R\u0015\u00105\u001a\u00020\u00038\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0015\u00109\u001a\u00020\u00038\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001bR\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020)0<X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010?\u001a\u0004\b=\u0010>R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010,\u001a\u00020\u00038G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010\u001b\"\u0004\bA\u0010\u001dR\u000e\u0010B\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010C\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u000eR\u001a\u0010E\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u00108\"\u0004\bG\u0010H\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006~"}, d2={"Lcom/google/accompanist/pager/PagerState;", "Landroidx/compose/foundation/gestures/ScrollableState;", "pageCount", "", "currentPage", "currentPageOffset", "", "offscreenLimit", "infiniteLoop", "", "(IIFIZ)V", "<set-?>", "_animationTargetPage", "get_animationTargetPage", "()Ljava/lang/Integer;", "set_animationTargetPage", "(Ljava/lang/Integer;)V", "_animationTargetPage$delegate", "Landroidx/compose/runtime/MutableState;", "_currentLayoutPageOffset", "get_currentLayoutPageOffset", "()F", "set_currentLayoutPageOffset", "(F)V", "_currentLayoutPageOffset$delegate", "_currentPage", "get_currentPage", "()I", "set_currentPage", "(I)V", "_currentPage$delegate", "_pageCount", "get_pageCount", "set_pageCount", "_pageCount$delegate", "absolutePosition", "getAbsolutePosition", "currentLayoutPage", "getCurrentLayoutPage$pager_release", "currentLayoutPageIndex", "currentLayoutPageInfo", "Lcom/google/accompanist/pager/PageLayoutInfo;", "getCurrentLayoutPageInfo$pager_release", "()Lcom/google/accompanist/pager/PageLayoutInfo;", "value", "currentLayoutPageOffset", "getCurrentLayoutPageOffset$pager_release", "setCurrentLayoutPageOffset", "currentLayoutPageSize", "getCurrentLayoutPageSize", "getCurrentPage", "setCurrentPage", "getCurrentPageOffset", "firstPageIndex", "getFirstPageIndex$pager_release", "isScrollInProgress", "()Z", "lastPageIndex", "getLastPageIndex$pager_release", "layoutPages", "", "getLayoutPages$pager_release", "()[Lcom/google/accompanist/pager/PageLayoutInfo;", "[Lcom/google/accompanist/pager/PageLayoutInfo;", "getPageCount", "setPageCount", "scrollableState", "targetPage", "getTargetPage", "testing", "getTesting$pager_release", "setTesting$pager_release", "(Z)V", "animateScrollToPage", "", "page", "pageOffset", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "initialVelocity", "skipPages", "(IFLandroidx/compose/animation/core/AnimationSpec;FZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToPageLinear", "(IFLandroidx/compose/animation/core/AnimationSpec;FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "animateToPageSkip", "determineSpringBackOffset", "velocity", "offset", "dispatchRawDelta", "delta", "fling", "decayAnimationSpec", "Landroidx/compose/animation/core/DecayAnimationSpec;", "snapAnimationSpec", "scrollBy", "Lkotlin/Function1;", "fling$pager_release", "(FLandroidx/compose/animation/core/DecayAnimationSpec;Landroidx/compose/animation/core/AnimationSpec;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pageOf", "rawPage", "pageOf$pager_release", "requireCurrentPage", "name", "", "requireCurrentPageOffset", "scroll", "scrollPriority", "Landroidx/compose/foundation/MutatePriority;", "block", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/MutatePriority;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scrollByOffset", "deltaOffset", "scrollToPage", "(IFLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapToNearestPage", "snapToPage", "toString", "updateLayoutForScrollPosition", "position", "updateLayoutPages", "Companion", "pager_release"})
@ExperimentalPagerApi
@Stable
public final class PagerState
implements ScrollableState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offscreenLimit;
    private final boolean infiniteLoop;
    @NotNull
    private final MutableState _pageCount$delegate;
    @NotNull
    private final MutableState _currentPage$delegate;
    @NotNull
    private final MutableState _currentLayoutPageOffset$delegate;
    private boolean testing;
    @NotNull
    private final PageLayoutInfo[] layoutPages;
    private final int currentLayoutPageIndex;
    @NotNull
    private final ScrollableState scrollableState;
    @NotNull
    private final MutableState _animationTargetPage$delegate;
    @NotNull
    private static final Saver<PagerState, ?> Saver = ListSaverKt.listSaver((Function2)Companion.Saver.1.INSTANCE, (Function1)Companion.Saver.2.INSTANCE);

    public PagerState(@IntRange(from=0L) int pageCount, @IntRange(from=0L) int currentPage, @FloatRange(from=0.0, to=1.0) float currentPageOffset, int offscreenLimit, boolean infiniteLoop) {
        this.offscreenLimit = offscreenLimit;
        this.infiniteLoop = infiniteLoop;
        this._pageCount$delegate = SnapshotStateKt.mutableStateOf$default((Object)pageCount, null, (int)2, null);
        this._currentPage$delegate = SnapshotStateKt.mutableStateOf$default((Object)currentPage, null, (int)2, null);
        this._currentLayoutPageOffset$delegate = SnapshotStateKt.mutableStateOf$default((Object)Float.valueOf(currentPageOffset), null, (int)2, null);
        int n = 0;
        int n2 = this.offscreenLimit * 2 + 1;
        PageLayoutInfo[] pageLayoutInfoArray = new PageLayoutInfo[n2];
        PagerState pagerState = this;
        while (n < n2) {
            int n3 = n++;
            pageLayoutInfoArray[n3] = new PageLayoutInfo();
        }
        pagerState.layoutPages = pageLayoutInfoArray;
        this.currentLayoutPageIndex = (this.layoutPages.length - 1) / 2;
        this.scrollableState = ScrollableStateKt.ScrollableState((Function1)((Function1)new Function1<Float, Float>(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final float invoke(float deltaPixels) {
                PagerState this_$iv = this.this$0;
                boolean $i$f$getCurrentLayoutPageSize = false;
                PagerState this_$iv$iv = this_$iv;
                boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
                int size = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize();
                boolean bl = size > 0;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Layout size for current item is 0";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                return -PagerState.access$scrollByOffset(this.this$0, -deltaPixels / (float)size) * (float)size;
            }
        }));
        n = this.offscreenLimit >= 1 ? 1 : 0;
        n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "offscreenLimit is required to be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = pageCount >= 0 ? 1 : 0;
        n2 = 0;
        bl = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "pageCount must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.requireCurrentPage(currentPage, "currentPage");
        this.requireCurrentPageOffset(currentPageOffset, "currentPageOffset");
        this.updateLayoutPages(currentPage);
        this._animationTargetPage$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
    }

    public /* synthetic */ PagerState(int n, int n2, float f, int n3, boolean bl, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            f = 0.0f;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, f, n3, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final int get_pageCount() {
        void $this$getValue$iv;
        State state = (State)this._pageCount$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_pageCount(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this._pageCount$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final int get_currentPage() {
        void $this$getValue$iv;
        State state = (State)this._currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_currentPage(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this._currentPage$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final float get_currentLayoutPageOffset() {
        void $this$getValue$iv;
        State state = (State)this._currentLayoutPageOffset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_currentLayoutPageOffset(float f) {
        void $this$setValue$iv;
        MutableState mutableState = this._currentLayoutPageOffset$delegate;
        Object var3_3 = null;
        Float value$iv = Float.valueOf(f);
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final boolean getTesting$pager_release() {
        return this.testing;
    }

    public final void setTesting$pager_release(boolean bl) {
        this.testing = bl;
    }

    @NotNull
    public final PageLayoutInfo[] getLayoutPages$pager_release() {
        return this.layoutPages;
    }

    public final float getCurrentLayoutPageOffset$pager_release() {
        return this.get_currentLayoutPageOffset();
    }

    private final void setCurrentLayoutPageOffset(float value) {
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv$iv.getLayoutPages$pager_release()[this_$iv$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        this_$iv = this;
        boolean $i$f$getLastPageIndex$pager_release = false;
        this.set_currentLayoutPageOffset(RangesKt.coerceIn((float)value, (float)0.0f, (float)(n == (this_$iv.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0)) ? 0.0f : 1.0f)));
    }

    private final int getCurrentLayoutPageSize() {
        boolean $i$f$getCurrentLayoutPageSize = false;
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        return this_$iv.getLayoutPages$pager_release()[this_$iv.currentLayoutPageIndex].getLayoutSize();
    }

    public final int getCurrentLayoutPage$pager_release() {
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv.getLayoutPages$pager_release()[this_$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    @NotNull
    public final PageLayoutInfo getCurrentLayoutPageInfo$pager_release() {
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        return this.getLayoutPages$pager_release()[this.currentLayoutPageIndex];
    }

    private final float getAbsolutePosition() {
        boolean $i$f$getAbsolutePosition = false;
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv$iv.getLayoutPages$pager_release()[this_$iv$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        return (float)n.intValue() + this.getCurrentLayoutPageOffset$pager_release();
    }

    public final int getFirstPageIndex$pager_release() {
        boolean $i$f$getFirstPageIndex$pager_release = false;
        return this.infiniteLoop ? Integer.MIN_VALUE : 0;
    }

    public final int getLastPageIndex$pager_release() {
        boolean $i$f$getLastPageIndex$pager_release = false;
        return this.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this.getPageCount() - 1), (int)0);
    }

    @IntRange(from=0L)
    public final int getPageCount() {
        return this.get_pageCount();
    }

    public final void setPageCount(@IntRange(from=0L) int value) {
        boolean bl = value >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "pageCount must be >= 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.set_pageCount(value);
        PagerState this_$iv = this;
        boolean $i$f$getFirstPageIndex$pager_release = false;
        int n = this_$iv.infiniteLoop ? Integer.MIN_VALUE : 0;
        this_$iv = this;
        boolean $i$f$getLastPageIndex$pager_release = false;
        this.setCurrentPage(RangesKt.coerceIn((int)this.getCurrentPage(), (int)n, (int)(this_$iv.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0))));
        this.updateLayoutPages(this.getCurrentPage());
    }

    @IntRange(from=0L)
    public final int getCurrentPage() {
        return this.get_currentPage();
    }

    private final void setCurrentPage(int value) {
        this.set_currentPage(PagerState.Companion.floorMod(value, this.getPageCount()));
        this.updateLayoutPages(this.get_currentPage());
    }

    public final float getCurrentPageOffset() {
        PagerState this_$iv = this;
        boolean $i$f$getAbsolutePosition = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv$iv$iv.getLayoutPages$pager_release()[this_$iv$iv$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        return (float)n.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release() - (float)this.getCurrentPage();
    }

    /*
     * WARNING - void declaration
     */
    private final Integer get_animationTargetPage() {
        void $this$getValue$iv;
        State state = (State)this._animationTargetPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Integer)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_animationTargetPage(Integer n) {
        void $this$setValue$iv;
        MutableState mutableState = this._animationTargetPage$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)n);
    }

    @Nullable
    public final Integer getTargetPage() {
        Integer n;
        Integer n2 = this.get_animationTargetPage();
        if (n2 == null) {
            if (!this.isScrollInProgress()) {
                n = null;
            } else if (this.getCurrentPageOffset() < 0.0f) {
                n = RangesKt.coerceAtLeast((int)(this.getCurrentPage() - 1), (int)0);
            } else {
                PagerState this_$iv = this;
                boolean $i$f$getLastPageIndex$pager_release = false;
                n = RangesKt.coerceAtMost((int)(this.getCurrentPage() + 1), (int)(this_$iv.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0)));
            }
        } else {
            n = n2;
        }
        return n;
    }

    @Nullable
    public final Object animateScrollToPage(@IntRange(from=0L) int page, @FloatRange(from=0.0, to=1.0) float pageOffset, @NotNull AnimationSpec<Float> animationSpec, float initialVelocity, boolean skipPages, @NotNull Continuation<? super Unit> $completion) {
        this.requireCurrentPage(page, "page");
        this.requireCurrentPageOffset(pageOffset, "pageOffset");
        if (page == this.getCurrentPage() && pageOffset == this.getCurrentLayoutPageOffset$pager_release()) {
            return Unit.INSTANCE;
        }
        Object object = ScrollableState.DefaultImpls.scroll$default((ScrollableState)this, null, (Function2)((Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>(this, page, skipPages, pageOffset, animationSpec, initialVelocity, null){
            int label;
            final /* synthetic */ PagerState this$0;
            final /* synthetic */ int $page;
            final /* synthetic */ boolean $skipPages;
            final /* synthetic */ float $pageOffset;
            final /* synthetic */ AnimationSpec<Float> $animationSpec;
            final /* synthetic */ float $initialVelocity;
            {
                this.this$0 = $receiver;
                this.$page = $page;
                this.$skipPages = $skipPages;
                this.$pageOffset = $pageOffset;
                this.$animationSpec = $animationSpec;
                this.$initialVelocity = $initialVelocity;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void var3_4;
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PagerState this_$iv = this.this$0;
                        boolean $i$f$getCurrentLayoutPage$pager_release = false;
                        PagerState this_$iv$iv = this_$iv;
                        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
                        Integer n = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getPage();
                        Intrinsics.checkNotNull((Object)n);
                        int currentIndex = n;
                        int target = PagerState.access$getInfiniteLoop$p(this.this$0) ? this.$page : com.google.accompanist.pager.PagerState$Companion.access$floorMod(PagerState.Companion, this.$page, this.this$0.getPageCount());
                        int n2 = target - currentIndex;
                        boolean bl = false;
                        int distance = Math.abs(n2);
                        if (!this.$skipPages || distance <= 4) break;
                        this.label = 1;
                        Object object3 = PagerState.access$animateToPageSkip(this.this$0, target, this.$pageOffset, this.$animationSpec, this.$initialVelocity, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                this.label = 2;
                Object object4 = PagerState.access$animateToPageLinear(this.this$0, (int)var3_4, this.$pageOffset, this.$animationSpec, this.$initialVelocity, (Continuation)this);
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull ScrollScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object animateScrollToPage$default(PagerState pagerState, int n, float f, AnimationSpec animationSpec, float f2, boolean bl, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        if ((n2 & 4) != 0) {
            animationSpec = (AnimationSpec)AnimationSpecKt.spring$default((float)0.0f, (float)0.0f, null, (int)7, null);
        }
        if ((n2 & 8) != 0) {
            f2 = 0.0f;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        return pagerState.animateScrollToPage(n, f, (AnimationSpec<Float>)animationSpec, f2, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object scrollToPage(@IntRange(from=0L) int page, @FloatRange(from=0.0, to=1.0) float pageOffset, @NotNull Continuation<? super Unit> $completion) {
        this.requireCurrentPage(page, "page");
        this.requireCurrentPageOffset(pageOffset, "pageOffset");
        if (page == this.getCurrentPage() && pageOffset == this.getCurrentLayoutPageOffset$pager_release()) {
            return Unit.INSTANCE;
        }
        Object object = ScrollableState.DefaultImpls.scroll$default((ScrollableState)this, null, (Function2)((Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>(this, page, pageOffset, null){
            int label;
            final /* synthetic */ PagerState this$0;
            final /* synthetic */ int $page;
            final /* synthetic */ float $pageOffset;
            {
                this.this$0 = $receiver;
                this.$page = $page;
                this.$pageOffset = $pageOffset;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PagerState.access$snapToPage(this.this$0, this.$page, this.$pageOffset);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull ScrollScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion, (int)1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object scrollToPage$default(PagerState pagerState, int n, float f, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return pagerState.scrollToPage(n, f, (Continuation<? super Unit>)continuation);
    }

    private final void snapToPage(int page, float offset) {
        this.updateLayoutPages(page);
        this.setCurrentLayoutPageOffset(offset);
        this.setCurrentPage(page);
        this.set_animationTargetPage(null);
    }

    static /* synthetic */ void snapToPage$default(PagerState pagerState, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        pagerState.snapToPage(n, f);
    }

    private final void snapToNearestPage() {
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv$iv.getLayoutPages$pager_release()[this_$iv$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        PagerState.snapToPage$default(this, n + MathKt.roundToInt((float)this.getCurrentLayoutPageOffset$pager_release()), 0.0f, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object animateToPageLinear(int var1_1, float var2_2, AnimationSpec<Float> var3_3, float var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof animateToPageLinear.1)) ** GOTO lbl-1000
        var14_6 = var5_5;
        if ((var14_6.label & -2147483648) != 0) {
            var14_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                int I$0;
                float F$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PagerState.access$animateToPageLinear(this.this$0, 0, 0.0f, null, 0.0f, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.set_animationTargetPage(Boxing.boxInt((int)page));
                this_$iv = this;
                $i$f$getAbsolutePosition = false;
                this_$iv$iv = this_$iv;
                $i$f$getCurrentLayoutPage$pager_release = false;
                this_$iv$iv$iv = this_$iv$iv;
                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                var12_15 = this_$iv$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv$iv)].getPage();
                Intrinsics.checkNotNull((Object)var12_15);
                $continuation.L$0 = this;
                $continuation.I$0 = page;
                $continuation.F$0 = pageOffset;
                $continuation.label = 1;
                v0 = SuspendAnimationKt.animate((float)((float)var12_15.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release()), (float)((float)page + pageOffset), (float)initialVelocity, (AnimationSpec)animationSpec, (Function2)((Function2)new Function2<Float, Float, Unit>(this){
                    final /* synthetic */ PagerState this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(float value, float $noName_1) {
                        PagerState.access$updateLayoutForScrollPosition(this.this$0, value);
                    }
                }), (Continuation)$continuation);
                if (v0 == var15_8) {
                    return var15_8;
                }
                ** GOTO lbl35
            }
            case 1: {
                var2_2 = $continuation.F$0;
                var1_1 = $continuation.I$0;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                this.snapToPage(var1_1, var2_2);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object animateToPageSkip(int var1_1, float var2_2, AnimationSpec<Float> var3_3, float var4_4, Continuation<? super Unit> var5_5) {
        if (!(var5_5 instanceof animateToPageSkip.1)) ** GOTO lbl-1000
        var13_6 = var5_5;
        if ((var13_6.label & -2147483648) != 0) {
            var13_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                int I$0;
                float F$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PagerState.access$animateToPageSkip(this.this$0, 0, 0.0f, null, 0.0f, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.set_animationTargetPage(Boxing.boxInt((int)page));
                this_$iv = this;
                $i$f$getCurrentLayoutPage$pager_release = false;
                this_$iv$iv = this_$iv;
                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                var11_15 = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getPage();
                Intrinsics.checkNotNull((Object)var11_15);
                initialIndex = var11_15;
                direction = page > initialIndex ? 1 : -1;
                if (page > initialIndex) {
                    var9_13 = new int[]{initialIndex, initialIndex + 1, page - true, page};
                    v0 = var9_13;
                } else {
                    var9_13 = new int[]{initialIndex, initialIndex - 1, page + true, page};
                    v0 = var9_13;
                }
                pages = v0;
                $continuation.L$0 = this;
                $continuation.I$0 = page;
                $continuation.F$0 = pageOffset;
                $continuation.label = 1;
                v1 = SuspendAnimationKt.animate((float)this.getCurrentPageOffset(), (float)((float)((pages.length - 1) * direction) + pageOffset), (float)(initialVelocity * (float)direction), (AnimationSpec)animationSpec, (Function2)((Function2)new Function2<Float, Float, Unit>(this, pages, direction){
                    final /* synthetic */ PagerState this$0;
                    final /* synthetic */ int[] $pages;
                    final /* synthetic */ int $direction;
                    {
                        this.this$0 = $receiver;
                        this.$pages = $pages;
                        this.$direction = $direction;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(float value, float $noName_1) {
                        void $this$forEachIndexed$iv;
                        boolean bl = false;
                        int flooredIndex = (int)Math.floor(value);
                        PageLayoutInfo[] pageLayoutInfoArray = this.this$0.getLayoutPages$pager_release();
                        int[] nArray = this.$pages;
                        int n = this.$direction;
                        PagerState pagerState = this.this$0;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (void item$iv : $this$forEachIndexed$iv) {
                            void layoutInfo;
                            int n2 = index$iv++;
                            void var14_15 = item$iv;
                            int index = n2;
                            boolean bl2 = false;
                            layoutInfo.setPage(ArraysKt.getOrNull((int[])nArray, (int)(flooredIndex * n + (index - PagerState.access$getCurrentLayoutPageIndex$p(pagerState)))));
                        }
                        PagerState.access$setCurrentLayoutPageOffset(this.this$0, value - (float)flooredIndex);
                    }
                }), (Continuation)$continuation);
                if (v1 == var14_8) {
                    return var14_8;
                }
                ** GOTO lbl43
            }
            case 1: {
                var2_2 = $continuation.F$0;
                var1_1 = $continuation.I$0;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                this.snapToPage(var1_1, var2_2);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int determineSpringBackOffset(float velocity, float offset) {
        int n;
        PagerState this_$iv = this;
        boolean $i$f$getCurrentLayoutPageSize = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        if (velocity >= (float)this_$iv$iv.getLayoutPages$pager_release()[this_$iv$iv.currentLayoutPageIndex].getLayoutSize()) {
            n = 1;
        } else {
            this_$iv = this;
            $i$f$getCurrentLayoutPageSize = false;
            this_$iv$iv = this_$iv;
            $i$f$getCurrentLayoutPageInfo$pager_release = false;
            n = velocity <= (float)(-this_$iv$iv.getLayoutPages$pager_release()[this_$iv$iv.currentLayoutPageIndex].getLayoutSize()) ? 0 : (offset < 0.5f ? 0 : 1);
        }
        return n;
    }

    static /* synthetic */ int determineSpringBackOffset$default(PagerState pagerState, float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = pagerState.getCurrentLayoutPageOffset$pager_release();
        }
        return pagerState.determineSpringBackOffset(f, f2);
    }

    private final void updateLayoutForScrollPosition(float position) {
        boolean bl = false;
        PagerState this_$iv = this;
        boolean $i$f$getFirstPageIndex$pager_release = false;
        int n = this_$iv.infiniteLoop ? Integer.MIN_VALUE : 0;
        this_$iv = this;
        boolean $i$f$getLastPageIndex$pager_release = false;
        int newIndex = RangesKt.coerceIn((int)((int)Math.floor(position)), (int)n, (int)(this_$iv.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0)));
        this.updateLayoutPages(newIndex);
        this.setCurrentLayoutPageOffset(RangesKt.coerceIn((float)(position - (float)newIndex), (float)0.0f, (float)1.0f));
    }

    /*
     * Unable to fully structure code
     */
    private final void updateLayoutPages(int page) {
        this.requireCurrentPage(page, "page");
        $this$forEachIndexed$iv = this.layoutPages;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (PageLayoutInfo item$iv : $this$forEachIndexed$iv) {
            v0 = index$iv++;
            var9_9 = item$iv;
            index = v0;
            $i$a$-forEachIndexed-PagerState$updateLayoutPages$1 = false;
            pg = page + index - this.offscreenLimit;
            this_$iv = this;
            $i$f$getFirstPageIndex$pager_release = false;
            if (pg < (PagerState.access$getInfiniteLoop$p(this_$iv) != false ? -2147483648 : 0)) ** GOTO lbl-1000
            this_$iv = this;
            $i$f$getLastPageIndex$pager_release = false;
            if (pg > (PagerState.access$getInfiniteLoop$p(this_$iv) != false ? 0x7FFFFFFF : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0))) lbl-1000:
            // 2 sources

            {
                v1 = null;
            } else {
                v1 = pg;
            }
            layoutPage.setPage(v1);
        }
    }

    private final float scrollByOffset(float deltaOffset) {
        PagerState this_$iv = this;
        boolean $i$f$getAbsolutePosition = false;
        PagerState this_$iv$iv = this_$iv;
        boolean $i$f$getCurrentLayoutPage$pager_release = false;
        PagerState this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
        Integer n = this_$iv$iv$iv.getLayoutPages$pager_release()[this_$iv$iv$iv.currentLayoutPageIndex].getPage();
        Intrinsics.checkNotNull((Object)n);
        float current = (float)n.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release();
        PagerState this_$iv2 = this;
        boolean $i$f$getFirstPageIndex$pager_release = false;
        float f = this_$iv2.infiniteLoop ? Integer.MIN_VALUE : 0;
        this_$iv2 = this;
        boolean $i$f$getLastPageIndex$pager_release = false;
        float target = RangesKt.coerceIn((float)(current + deltaOffset), (float)f, (float)(this_$iv2.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv2.getPageCount() - 1), (int)0)));
        this.updateLayoutForScrollPosition(target);
        return target - current;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fling$pager_release(float var1_1, @NotNull DecayAnimationSpec<Float> var2_2, @NotNull AnimationSpec<Float> var3_3, @NotNull Function1<? super Float, Float> var4_4, @NotNull Continuation<? super Float> var5_5) {
        if (!(var5_5 instanceof fling.1)) ** GOTO lbl-1000
        var17_6 = var5_5;
        if ((var17_6.label & -2147483648) != 0) {
            var17_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fling$pager_release(0.0f, null, null, null, (Continuation<? super Float>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this_$iv = this;
                $i$f$getCurrentLayoutPageSize = false;
                this_$iv$iv = this_$iv;
                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                v0 = DecayAnimationSpecKt.calculateTargetValue((DecayAnimationSpec)decayAnimationSpec, (float)(this.getCurrentLayoutPageOffset$pager_release() * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize()), (float)initialVelocity);
                this_$iv = this;
                $i$f$getCurrentLayoutPageSize = false;
                this_$iv$iv = this_$iv;
                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                targetOffset = v0 / (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize();
                lastVelocity = new Ref.FloatRef();
                lastVelocity.element = initialVelocity;
                $i$f$getCurrentLayoutPageSize = targetOffset;
                this_$iv$iv = false;
                if (!(Math.abs($i$f$getCurrentLayoutPageSize) >= 1.0f)) break;
                if (targetOffset > 0.0f) {
                    this_$iv = this;
                    $i$f$getCurrentLayoutPage$pager_release = false;
                    this_$iv$iv = this_$iv;
                    $i$f$getCurrentLayoutPageInfo$pager_release = false;
                    var13_24 = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getPage();
                    Intrinsics.checkNotNull((Object)var13_24);
                    this_$iv = this;
                    $i$f$getLastPageIndex$pager_release = false;
                    v1 = RangesKt.coerceAtMost((int)(var13_24 + 1), (int)(PagerState.access$getInfiniteLoop$p(this_$iv) != false ? 0x7FFFFFFF : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0)));
                } else {
                    this_$iv = this;
                    $i$f$getCurrentLayoutPage$pager_release = false;
                    this_$iv$iv = this_$iv;
                    $i$f$getCurrentLayoutPageInfo$pager_release = false;
                    var13_24 = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getPage();
                    Intrinsics.checkNotNull((Object)var13_24);
                    v1 = var13_24;
                }
                target = v1;
                this.set_animationTargetPage(Boxing.boxInt((int)target));
                this_$iv = this;
                $i$f$getCurrentLayoutPageSize = false;
                this_$iv$iv = this_$iv;
                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                $continuation.L$0 = this;
                $continuation.L$1 = lastVelocity;
                $continuation.I$0 = target;
                $continuation.label = 1;
                v2 = SuspendAnimationKt.animateDecay$default((AnimationState)AnimationStateKt.AnimationState$default((float)(this.getCurrentLayoutPageOffset$pager_release() * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize()), (float)initialVelocity, (long)0L, (long)0L, (boolean)false, (int)28, null), (DecayAnimationSpec)decayAnimationSpec, (boolean)false, (Function1)((Function1)new Function1<AnimationScope<Float, AnimationVector1D>, Unit>(this, lastVelocity, (Function1<? super Float, Float>)scrollBy, (float)initialVelocity, target){
                    final /* synthetic */ PagerState this$0;
                    final /* synthetic */ Ref.FloatRef $lastVelocity;
                    final /* synthetic */ Function1<Float, Float> $scrollBy;
                    final /* synthetic */ float $initialVelocity;
                    final /* synthetic */ int $target;
                    {
                        this.this$0 = $receiver;
                        this.$lastVelocity = $lastVelocity;
                        this.$scrollBy = $scrollBy;
                        this.$initialVelocity = $initialVelocity;
                        this.$target = $target;
                        super(1);
                    }

                    public final void invoke(@NotNull AnimationScope<Float, AnimationVector1D> $this$animateDecay) {
                        block4: {
                            block3: {
                                Integer n;
                                boolean $i$f$getCurrentLayoutPageInfo$pager_release;
                                PagerState this_$iv$iv$iv;
                                boolean $i$f$getCurrentLayoutPage$pager_release;
                                boolean $i$f$getAbsolutePosition;
                                PagerState this_$iv$iv;
                                PagerState this_$iv;
                                block2: {
                                    Intrinsics.checkNotNullParameter($this$animateDecay, (String)"$this$animateDecay");
                                    this.$lastVelocity.element = ((Number)$this$animateDecay.getVelocity()).floatValue();
                                    this_$iv = this.this$0;
                                    boolean $i$f$getCurrentLayoutPageSize = false;
                                    this_$iv$iv = this_$iv;
                                    boolean $i$f$getCurrentLayoutPageInfo$pager_release2 = false;
                                    float coerced = RangesKt.coerceIn((float)((Number)$this$animateDecay.getValue()).floatValue(), (float)0.0f, (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize());
                                    this_$iv = this.this$0;
                                    $i$f$getCurrentLayoutPageSize = false;
                                    this_$iv$iv = this_$iv;
                                    $i$f$getCurrentLayoutPageInfo$pager_release2 = false;
                                    this.$scrollBy.invoke((Object)Float.valueOf(coerced - this.this$0.getCurrentLayoutPageOffset$pager_release() * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize()));
                                    if (!(this.$initialVelocity < 0.0f)) break block2;
                                    this_$iv = this.this$0;
                                    $i$f$getAbsolutePosition = false;
                                    this_$iv$iv = this_$iv;
                                    $i$f$getCurrentLayoutPage$pager_release = false;
                                    this_$iv$iv$iv = this_$iv$iv;
                                    $i$f$getCurrentLayoutPageInfo$pager_release = false;
                                    n = this_$iv$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv$iv)].getPage();
                                    Intrinsics.checkNotNull((Object)n);
                                    if ((float)n.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release() <= (float)this.$target) break block3;
                                }
                                if (!(this.$initialVelocity > 0.0f)) break block4;
                                this_$iv = this.this$0;
                                $i$f$getAbsolutePosition = false;
                                this_$iv$iv = this_$iv;
                                $i$f$getCurrentLayoutPage$pager_release = false;
                                this_$iv$iv$iv = this_$iv$iv;
                                $i$f$getCurrentLayoutPageInfo$pager_release = false;
                                n = this_$iv$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv$iv)].getPage();
                                Intrinsics.checkNotNull((Object)n);
                                if (!((float)n.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release() >= (float)this.$target)) break block4;
                            }
                            $this$animateDecay.cancelAnimation();
                        }
                    }
                }), (Continuation)$continuation, (int)2, null);
                if (v2 == var18_8) {
                    return var18_8;
                }
                ** GOTO lbl67
            }
            case 1: {
                target = $continuation.I$0;
                var7_9 = (Ref.FloatRef)$continuation.L$1;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl67:
                // 2 sources

                PagerState.snapToPage$default(this, target, 0.0f, 2, null);
                ** GOTO lbl108
            }
        }
        this_$iv = this;
        $i$f$getCurrentLayoutPage$pager_release = false;
        this_$iv$iv = this_$iv;
        $i$f$getCurrentLayoutPageInfo$pager_release = false;
        var13_25 = this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getPage();
        Intrinsics.checkNotNull((Object)var13_25);
        target = var13_25 + this.determineSpringBackOffset(var1_1, (float)var6_19);
        this.set_animationTargetPage(Boxing.boxInt((int)target));
        this_$iv = this;
        $i$f$getAbsolutePosition = false;
        this_$iv$iv = this_$iv;
        $i$f$getCurrentLayoutPage$pager_release = false;
        this_$iv$iv$iv = this_$iv$iv;
        $i$f$getCurrentLayoutPageInfo$pager_release = false;
        var15_27 = this_$iv$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv$iv)].getPage();
        Intrinsics.checkNotNull((Object)var15_27);
        v3 = (float)var15_27.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release();
        this_$iv = this;
        $i$f$getCurrentLayoutPageSize = false;
        this_$iv$iv = this_$iv;
        $i$f$getCurrentLayoutPageInfo$pager_release = false;
        v4 = v3 * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize();
        this_$iv = this;
        $i$f$getCurrentLayoutPageSize = false;
        this_$iv$iv = this_$iv;
        $i$f$getCurrentLayoutPageInfo$pager_release = false;
        $continuation.L$0 = this;
        $continuation.L$1 = var7_9;
        $continuation.label = 2;
        v5 = SuspendAnimationKt.animate((float)v4, (float)((float)target * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize()), (float)var1_1, var3_3, (Function2)((Function2)new Function2<Float, Float, Unit>(var4_4, this, var7_9){
            final /* synthetic */ Function1<Float, Float> $scrollBy;
            final /* synthetic */ PagerState this$0;
            final /* synthetic */ Ref.FloatRef $lastVelocity;
            {
                this.$scrollBy = $scrollBy;
                this.this$0 = $receiver;
                this.$lastVelocity = $lastVelocity;
                super(2);
            }

            public final void invoke(float value, float velocity) {
                PagerState this_$iv = this.this$0;
                boolean $i$f$getAbsolutePosition = false;
                PagerState this_$iv$iv = this_$iv;
                boolean $i$f$getCurrentLayoutPage$pager_release = false;
                PagerState this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$getCurrentLayoutPageInfo$pager_release = false;
                Integer n = this_$iv$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv$iv)].getPage();
                Intrinsics.checkNotNull((Object)n);
                float f = (float)n.intValue() + this_$iv.getCurrentLayoutPageOffset$pager_release();
                this_$iv = this.this$0;
                boolean $i$f$getCurrentLayoutPageSize = false;
                this_$iv$iv = this_$iv;
                boolean $i$f$getCurrentLayoutPageInfo$pager_release2 = false;
                this.$scrollBy.invoke((Object)Float.valueOf(value - f * (float)this_$iv$iv.getLayoutPages$pager_release()[PagerState.access$getCurrentLayoutPageIndex$p(this_$iv$iv)].getLayoutSize()));
                this.$lastVelocity.element = velocity;
            }
        }), (Continuation)$continuation);
        if (v5 == var18_8) {
            return var18_8;
        }
        ** GOTO lbl107
        {
            case 2: {
                var7_9 = (Ref.FloatRef)$continuation.L$1;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl107:
                // 2 sources

                this.snapToNearestPage();
lbl108:
                // 2 sources

                return Boxing.boxFloat((float)var7_9.element);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object fling$pager_release$default(PagerState pagerState, float f, DecayAnimationSpec decayAnimationSpec, AnimationSpec animationSpec, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            decayAnimationSpec = DecayAnimationSpecKt.exponentialDecay$default((float)0.0f, (float)0.0f, (int)3, null);
        }
        if ((n & 4) != 0) {
            animationSpec = (AnimationSpec)AnimationSpecKt.spring$default((float)0.0f, (float)0.0f, null, (int)7, null);
        }
        return pagerState.fling$pager_release(f, (DecayAnimationSpec<Float>)decayAnimationSpec, (AnimationSpec<Float>)animationSpec, (Function1<? super Float, Float>)function1, (Continuation<? super Float>)continuation);
    }

    public boolean isScrollInProgress() {
        return this.scrollableState.isScrollInProgress();
    }

    public float dispatchRawDelta(float delta) {
        return this.scrollableState.dispatchRawDelta(delta);
    }

    @Nullable
    public Object scroll(@NotNull MutatePriority scrollPriority, @NotNull Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> block, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.scrollableState.scroll(scrollPriority, block, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "PagerState(pageCount=" + this.getPageCount() + ", currentPage=" + this.getCurrentPage() + ", currentPageOffset=" + this.getCurrentPageOffset() + ')';
    }

    private final void requireCurrentPage(int value, String name) {
        if (this.getPageCount() == 0) {
            boolean bl = value == 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)name, (Object)" must be 0 when pageCount is 0");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        } else {
            PagerState this_$iv = this;
            boolean $i$f$getFirstPageIndex$pager_release = false;
            int n = this_$iv.infiniteLoop ? Integer.MIN_VALUE : 0;
            this_$iv = this;
            boolean $i$f$getLastPageIndex$pager_release = false;
            n = value <= (this_$iv.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv.getPageCount() - 1), (int)0)) ? (n <= value ? 1 : 0) : 0;
            boolean bl = false;
            boolean bl5 = false;
            if (n == 0) {
                boolean bl6 = false;
                PagerState this_$iv2 = this;
                boolean $i$f$getFirstPageIndex$pager_release2 = false;
                StringBuilder stringBuilder = new StringBuilder().append(name).append('[').append(value).append("] must be >= firstPageIndex[").append(this_$iv2.infiniteLoop ? Integer.MIN_VALUE : 0).append("] and <= lastPageIndex[");
                this_$iv2 = this;
                boolean $i$f$getLastPageIndex$pager_release2 = false;
                String string = stringBuilder.append(this_$iv2.infiniteLoop ? Integer.MAX_VALUE : RangesKt.coerceAtLeast((int)(this_$iv2.getPageCount() - 1), (int)0)).append(']').toString();
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    private final void requireCurrentPageOffset(float value, String name) {
        if (this.getPageCount() == 0) {
            boolean bl = value == 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)name, (Object)" must be 0f when pageCount is 0");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        } else {
            boolean bl = 0.0f <= value ? value <= 1.0f : false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = Intrinsics.stringPlus((String)name, (Object)" must be >= 0 and <= 1");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public final int pageOf$pager_release(int rawPage) {
        if (this.testing) {
            return rawPage;
        }
        return PagerState.Companion.floorMod(rawPage, this.getPageCount());
    }

    public static final /* synthetic */ Object access$animateToPageSkip(PagerState $this, int page, float pageOffset, AnimationSpec animationSpec, float initialVelocity, Continuation $completion) {
        return $this.animateToPageSkip(page, pageOffset, (AnimationSpec<Float>)animationSpec, initialVelocity, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$animateToPageLinear(PagerState $this, int page, float pageOffset, AnimationSpec animationSpec, float initialVelocity, Continuation $completion) {
        return $this.animateToPageLinear(page, pageOffset, (AnimationSpec<Float>)animationSpec, initialVelocity, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$snapToPage(PagerState $this, int page, float offset) {
        $this.snapToPage(page, offset);
    }

    public static final /* synthetic */ void access$updateLayoutForScrollPosition(PagerState $this, float position) {
        $this.updateLayoutForScrollPosition(position);
    }

    public static final /* synthetic */ void access$setCurrentLayoutPageOffset(PagerState $this, float value) {
        $this.setCurrentLayoutPageOffset(value);
    }

    public static final /* synthetic */ float access$scrollByOffset(PagerState $this, float deltaOffset) {
        return $this.scrollByOffset(deltaOffset);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002R\u001b\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/google/accompanist/pager/PagerState$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Lcom/google/accompanist/pager/PagerState;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "floorMod", "", "other", "pager_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<PagerState, ?> getSaver() {
            return Saver;
        }

        private final int floorMod(int $this$floorMod, int other) {
            int n;
            int n2 = other;
            if (n2 == 0) {
                n = $this$floorMod;
            } else {
                int n3 = $this$floorMod;
                boolean bl = false;
                int n4 = n3 / other;
                if ((n3 ^ other) < 0 && n4 * other != n3) {
                    --n4;
                }
                n = $this$floorMod - n4 * other;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

