/*
 * Decompiled with CFR 0.152.
 */
package com.google.accompanist.insets;

import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.accompanist.insets.ExperimentalAnimatedInsets;
import com.google.accompanist.insets.InnerWindowInsetsAnimationCallback;
import com.google.accompanist.insets.InsetsKt;
import com.google.accompanist.insets.MutableInsets;
import com.google.accompanist.insets.MutableWindowInsetsType;
import com.google.accompanist.insets.RootWindowInsets;
import com.google.accompanist.insets.ViewWindowInsetObserver;
import com.google.accompanist.insets.WindowInsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0012\u001a\u00020\tJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\tH\u0007J\u0006\u0010\u0017\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/accompanist/insets/ViewWindowInsetObserver;", "", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "attachListener", "com/google/accompanist/insets/ViewWindowInsetObserver$attachListener$1", "Lcom/google/accompanist/insets/ViewWindowInsetObserver$attachListener$1;", "<set-?>", "", "isObserving", "isObserving$annotations", "()V", "()Z", "observeInto", "", "windowInsets", "Lcom/google/accompanist/insets/RootWindowInsets;", "consumeWindowInsets", "windowInsetsAnimationsEnabled", "observeInto$insets_release", "start", "Lcom/google/accompanist/insets/WindowInsets;", "stop", "insets_release"})
@StabilityInferred(parameters=0)
public final class ViewWindowInsetObserver {
    @NotNull
    private final View view;
    @NotNull
    private final attachListener.1 attachListener;
    private boolean isObserving;
    public static final int $stable = 8;

    public ViewWindowInsetObserver(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.attachListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                v.requestApplyInsets();
            }

            public void onViewDetachedFromWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            }
        };
    }

    public final boolean isObserving() {
        return this.isObserving;
    }

    public static /* synthetic */ void isObserving$annotations() {
    }

    @NotNull
    public final WindowInsets start(boolean consumeWindowInsets) {
        RootWindowInsets rootWindowInsets = new RootWindowInsets();
        boolean bl = false;
        boolean bl2 = false;
        RootWindowInsets it = rootWindowInsets;
        boolean bl3 = false;
        this.observeInto$insets_release(it, consumeWindowInsets, false);
        return rootWindowInsets;
    }

    public static /* synthetic */ WindowInsets start$default(ViewWindowInsetObserver viewWindowInsetObserver, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return viewWindowInsetObserver.start(bl);
    }

    @ExperimentalAnimatedInsets
    @NotNull
    public final WindowInsets start(boolean windowInsetsAnimationsEnabled, boolean consumeWindowInsets) {
        RootWindowInsets rootWindowInsets = new RootWindowInsets();
        boolean bl = false;
        boolean bl2 = false;
        RootWindowInsets it = rootWindowInsets;
        boolean bl3 = false;
        this.observeInto$insets_release(it, consumeWindowInsets, windowInsetsAnimationsEnabled);
        return rootWindowInsets;
    }

    public static /* synthetic */ WindowInsets start$default(ViewWindowInsetObserver viewWindowInsetObserver, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return viewWindowInsetObserver.start(bl, bl2);
    }

    public final void observeInto$insets_release(@NotNull RootWindowInsets windowInsets, boolean consumeWindowInsets, boolean windowInsetsAnimationsEnabled) {
        Intrinsics.checkNotNullParameter((Object)windowInsets, (String)"windowInsets");
        boolean bl = !this.isObserving;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "start() called, but this ViewWindowInsetObserver is already observing";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)this.view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(windowInsets, consumeWindowInsets){
            final /* synthetic */ RootWindowInsets $windowInsets;
            final /* synthetic */ boolean $consumeWindowInsets;
            {
                this.$windowInsets = $windowInsets;
                this.$consumeWindowInsets = $consumeWindowInsets;
            }

            public final WindowInsetsCompat onApplyWindowInsets(View $noName_0, WindowInsetsCompat wic) {
                MutableWindowInsetsType mutableWindowInsetsType = this.$windowInsets.getStatusBars();
                boolean bl = false;
                boolean bl2 = false;
                MutableWindowInsetsType $this$onApplyWindowInsets_u24lambda_u2d0 = mutableWindowInsetsType;
                boolean bl3 = false;
                MutableInsets mutableInsets = $this$onApplyWindowInsets_u24lambda_u2d0.getMutableLayoutInsets();
                Insets insets = wic.getInsets(WindowInsetsCompat.Type.statusBars());
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"wic.getInsets(WindowInsetsCompat.Type.statusBars())");
                InsetsKt.updateFrom(mutableInsets, insets);
                $this$onApplyWindowInsets_u24lambda_u2d0.setVisible(wic.isVisible(WindowInsetsCompat.Type.statusBars()));
                mutableWindowInsetsType = this.$windowInsets.getNavigationBars();
                bl = false;
                bl2 = false;
                MutableWindowInsetsType $this$onApplyWindowInsets_u24lambda_u2d1 = mutableWindowInsetsType;
                boolean bl4 = false;
                MutableInsets mutableInsets2 = $this$onApplyWindowInsets_u24lambda_u2d1.getMutableLayoutInsets();
                insets = wic.getInsets(WindowInsetsCompat.Type.navigationBars());
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"wic.getInsets(WindowInsetsCompat.Type.navigationBars())");
                InsetsKt.updateFrom(mutableInsets2, insets);
                $this$onApplyWindowInsets_u24lambda_u2d1.setVisible(wic.isVisible(WindowInsetsCompat.Type.navigationBars()));
                mutableWindowInsetsType = this.$windowInsets.getSystemGestures();
                bl = false;
                bl2 = false;
                MutableWindowInsetsType $this$onApplyWindowInsets_u24lambda_u2d2 = mutableWindowInsetsType;
                boolean bl5 = false;
                MutableInsets mutableInsets3 = $this$onApplyWindowInsets_u24lambda_u2d2.getMutableLayoutInsets();
                insets = wic.getInsets(WindowInsetsCompat.Type.systemGestures());
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"wic.getInsets(WindowInsetsCompat.Type.systemGestures())");
                InsetsKt.updateFrom(mutableInsets3, insets);
                $this$onApplyWindowInsets_u24lambda_u2d2.setVisible(wic.isVisible(WindowInsetsCompat.Type.systemGestures()));
                mutableWindowInsetsType = this.$windowInsets.getIme();
                bl = false;
                bl2 = false;
                MutableWindowInsetsType $this$onApplyWindowInsets_u24lambda_u2d3 = mutableWindowInsetsType;
                boolean bl6 = false;
                MutableInsets mutableInsets4 = $this$onApplyWindowInsets_u24lambda_u2d3.getMutableLayoutInsets();
                insets = wic.getInsets(WindowInsetsCompat.Type.ime());
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"wic.getInsets(WindowInsetsCompat.Type.ime())");
                InsetsKt.updateFrom(mutableInsets4, insets);
                $this$onApplyWindowInsets_u24lambda_u2d3.setVisible(wic.isVisible(WindowInsetsCompat.Type.ime()));
                return this.$consumeWindowInsets ? WindowInsetsCompat.CONSUMED : wic;
            }
        });
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.attachListener);
        if (windowInsetsAnimationsEnabled) {
            ViewCompat.setWindowInsetsAnimationCallback((View)this.view, (WindowInsetsAnimationCompat.Callback)new InnerWindowInsetsAnimationCallback(windowInsets));
        } else {
            ViewCompat.setWindowInsetsAnimationCallback((View)this.view, null);
        }
        if (this.view.isAttachedToWindow()) {
            this.view.requestApplyInsets();
        }
        this.isObserving = true;
    }

    public final void stop() {
        boolean bl = this.isObserving;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "stop() called, but this ViewWindowInsetObserver is not currently observing";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this.attachListener);
        ViewCompat.setOnApplyWindowInsetsListener((View)this.view, null);
        this.isObserving = false;
    }
}

