/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.util;

import com.gluonhq.attach.util.impl.Debug;
import java.util.Locale;
import java.util.logging.Logger;

public enum Platform {
    DESKTOP("Desktop"),
    ANDROID("Android"),
    IOS("IOS");

    private final String javafxPlatformName;
    private static Platform current;
    private static final Logger LOGGER;

    private Platform(String javafxPlatformName) {
        this.javafxPlatformName = javafxPlatformName;
    }

    public static Platform getCurrent() {
        return current;
    }

    public static boolean isDesktop() {
        return DESKTOP == Platform.getCurrent();
    }

    public static boolean isAndroid() {
        return ANDROID == Platform.getCurrent();
    }

    public static boolean isIOS() {
        return IOS == Platform.getCurrent();
    }

    public final String getName() {
        return this.javafxPlatformName;
    }

    static {
        LOGGER = Logger.getLogger(Platform.class.getName());
        String platform = System.getProperty("javafx.platform", null);
        if (platform == null) {
            LOGGER.info("javafx.platform is not defined. Desktop will be assumed by default.");
            platform = DESKTOP.getName();
        }
        String name = platform.toUpperCase(Locale.ROOT);
        current = Platform.valueOf(name);
        LOGGER.fine("Current platform: " + current);
        if (Platform.isAndroid() || Platform.isIOS()) {
            System.loadLibrary(Platform.isAndroid() ? "util" : "Util");
            Debug.init();
        }
    }
}

