/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.ui.camerascreen;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.tbruyelle.rxpermissions3.Permission;
import com.tbruyelle.rxpermissions3.RxPermissions;
import com.zynksoftware.documentscanner.R;
import com.zynksoftware.documentscanner.common.extensions.ViewExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.FileUriUtils;
import com.zynksoftware.documentscanner.model.DocumentScannerErrorModel;
import com.zynksoftware.documentscanner.ui.base.BaseFragment;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceListener;
import com.zynksoftware.documentscanner.ui.components.scansurface.ScanSurfaceView;
import com.zynksoftware.documentscanner.ui.scan.InternalScanActivity;
import io.reactivex.rxjava3.functions.Consumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u001a\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0005H\u0016J\b\u0010(\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0005H\u0002\u00a8\u0006."}, d2={"Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment;", "Lcom/zynksoftware/documentscanner/ui/base/BaseFragment;", "Lcom/zynksoftware/documentscanner/ui/components/scansurface/ScanSurfaceListener;", "()V", "checkForCameraPermissions", "", "checkForStoragePermissions", "finishActivity", "getScanActivity", "Lcom/zynksoftware/documentscanner/ui/scan/InternalScanActivity;", "hideFlash", "initListeners", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onError", "error", "Lcom/zynksoftware/documentscanner/model/DocumentScannerErrorModel;", "onResume", "onViewCreated", "view", "scanSurfaceHideProgress", "scanSurfacePictureTaken", "scanSurfaceShowProgress", "selectImageFromGallery", "showFlash", "showFlashModeOff", "showFlashModeOn", "startCamera", "startCroppingProcess", "switchFlashState", "takePhoto", "toggleAutoManualButton", "Companion", "DocumentScanner_release"})
public final class CameraScreenFragment
extends BaseFragment
implements ScanSurfaceListener {
    private static final int GALLERY_REQUEST_CODE = 878;
    private static final String TAG;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.fragment_camera_screen, container, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setLifecycleOwner((LifecycleOwner)this);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setListener(this);
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setOriginalImageFile(this.getScanActivity().getOriginalImageFile$DocumentScanner_release());
        this.checkForCameraPermissions();
        this.initListeners();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getScanActivity().getShouldCallOnClose$DocumentScanner_release()) {
            this.getScanActivity().onClose();
        }
    }

    public void onResume() {
        super.onResume();
        this.getScanActivity().reInitOriginalImageFile$DocumentScanner_release();
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setOriginalImageFile(this.getScanActivity().getOriginalImageFile$DocumentScanner_release());
    }

    private final void initListeners() {
        this._$_findCachedViewById(R.id.cameraCaptureButton).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void onClick(View it) {
                CameraScreenFragment.access$takePhoto(this.this$0);
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
        ((TextView)this._$_findCachedViewById(R.id.cancelButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void onClick(View it) {
                CameraScreenFragment.access$finishActivity(this.this$0);
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void onClick(View it) {
                CameraScreenFragment.access$switchFlashState(this.this$0);
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
        ((ImageView)this._$_findCachedViewById(R.id.galleryButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void onClick(View it) {
                CameraScreenFragment.access$checkForStoragePermissions(this.this$0);
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
        ((TextView)this._$_findCachedViewById(R.id.autoButton)).setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void onClick(View it) {
                CameraScreenFragment.access$toggleAutoManualButton(this.this$0);
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
    }

    private final void toggleAutoManualButton() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).setAutoCaptureOn(!((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).isAutoCaptureOn());
        if (((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).isAutoCaptureOn()) {
            TextView textView = (TextView)this._$_findCachedViewById(R.id.autoButton);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"autoButton");
            textView.setText((CharSequence)this.getString(R.string.zdc_auto));
        } else {
            TextView textView = (TextView)this._$_findCachedViewById(R.id.autoButton);
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"autoButton");
            textView.setText((CharSequence)this.getString(R.string.zdc_manual));
        }
    }

    private final void checkForCameraPermissions() {
        new RxPermissions((Fragment)this).requestEach(new String[]{"android.permission.CAMERA"}).subscribe((Consumer)new Consumer<Permission>(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void accept(Permission permission) {
                if (permission.granted) {
                    CameraScreenFragment.access$startCamera(this.this$0);
                } else if (permission.shouldShowRequestPermissionRationale) {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_PERMISSION_REFUSED_WITHOUT_NEVER_ASK_AGAIN, null, 2, null));
                } else {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.CAMERA_PERMISSION_REFUSED_GO_TO_SETTINGS, null, 2, null));
                }
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
    }

    private final void checkForStoragePermissions() {
        new RxPermissions((Fragment)this).requestEach(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}).subscribe((Consumer)new Consumer<Permission>(this){
            final /* synthetic */ CameraScreenFragment this$0;

            public final void accept(Permission permission) {
                if (permission.granted) {
                    CameraScreenFragment.access$selectImageFromGallery(this.this$0);
                } else if (permission.shouldShowRequestPermissionRationale) {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.STORAGE_PERMISSION_REFUSED_WITHOUT_NEVER_ASK_AGAIN, null, 2, null));
                } else {
                    this.this$0.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.STORAGE_PERMISSION_REFUSED_GO_TO_SETTINGS, null, 2, null));
                }
            }
            {
                this.this$0 = cameraScreenFragment;
            }
        });
    }

    private final void startCamera() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).start();
    }

    private final void takePhoto() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).takePicture();
    }

    private final InternalScanActivity getScanActivity() {
        FragmentActivity fragmentActivity = this.requireActivity();
        if (fragmentActivity == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.zynksoftware.documentscanner.ui.scan.InternalScanActivity");
        }
        return (InternalScanActivity)fragmentActivity;
    }

    private final void finishActivity() {
        this.getScanActivity().finish();
    }

    private final void switchFlashState() {
        ((ScanSurfaceView)this._$_findCachedViewById(R.id.scanSurfaceView)).switchFlashState();
    }

    @Override
    public void showFlash() {
        block0: {
            ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.flashButton);
            if (imageView == null) break block0;
            ViewExtensionsKt.show((View)imageView);
        }
    }

    @Override
    public void hideFlash() {
        block0: {
            ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.flashButton);
            if (imageView == null) break block0;
            ViewExtensionsKt.hide((View)imageView);
        }
    }

    private final void selectImageFromGallery() {
        Intent photoPickerIntent = new Intent("android.intent.action.OPEN_DOCUMENT");
        photoPickerIntent.addCategory("android.intent.category.OPENABLE");
        photoPickerIntent.setType("image/*");
        this.startActivityForResult(photoPickerIntent, 878);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 878) {
            try {
                Uri imageUri;
                Intent intent = data;
                Object object = imageUri = intent != null ? intent.getData() : null;
                if (imageUri != null) {
                    String realPath = FileUriUtils.INSTANCE.getRealPath((Context)this.getScanActivity(), imageUri);
                    if (realPath != null) {
                        this.getScanActivity().reInitOriginalImageFile$DocumentScanner_release();
                        this.getScanActivity().setOriginalImageFile$DocumentScanner_release(new File(realPath));
                        this.startCroppingProcess();
                    } else {
                        Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR.getError());
                        this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, null));
                    }
                } else {
                    Log.e((String)TAG, (String)DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR.getError());
                    this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, null));
                }
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)"FileNotFoundException", (Throwable)e);
                this.onError(new DocumentScannerErrorModel(DocumentScannerErrorModel.ErrorMessage.TAKE_IMAGE_FROM_GALLERY_ERROR, e));
            }
        }
    }

    @Override
    public void scanSurfacePictureTaken() {
        this.startCroppingProcess();
    }

    private final void startCroppingProcess() {
        if (this.isAdded()) {
            this.getScanActivity().showImageCropFragment$DocumentScanner_release();
        }
    }

    @Override
    public void scanSurfaceShowProgress() {
        this.showProgressBar();
    }

    @Override
    public void scanSurfaceHideProgress() {
        this.hideProgressBar();
    }

    @Override
    public void onError(@NotNull DocumentScannerErrorModel error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.isAdded()) {
            this.getScanActivity().onError(error);
        }
    }

    @Override
    public void showFlashModeOn() {
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setImageResource(R.drawable.zdc_flash_on);
    }

    @Override
    public void showFlashModeOff() {
        ((ImageView)this._$_findCachedViewById(R.id.flashButton)).setImageResource(R.drawable.zdc_flash_off);
    }

    static {
        Companion = new Companion(null);
        TAG = Reflection.getOrCreateKotlinClass(CameraScreenFragment.class).getSimpleName();
    }

    public static final /* synthetic */ void access$takePhoto(CameraScreenFragment $this) {
        $this.takePhoto();
    }

    public static final /* synthetic */ void access$finishActivity(CameraScreenFragment $this) {
        $this.finishActivity();
    }

    public static final /* synthetic */ void access$switchFlashState(CameraScreenFragment $this) {
        $this.switchFlashState();
    }

    public static final /* synthetic */ void access$checkForStoragePermissions(CameraScreenFragment $this) {
        $this.checkForStoragePermissions();
    }

    public static final /* synthetic */ void access$toggleAutoManualButton(CameraScreenFragment $this) {
        $this.toggleAutoManualButton();
    }

    public static final /* synthetic */ void access$startCamera(CameraScreenFragment $this) {
        $this.startCamera();
    }

    public static final /* synthetic */ void access$selectImageFromGallery(CameraScreenFragment $this) {
        $this.selectImageFromGallery();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            View view2 = this.getView();
            if (view2 == null) {
                return null;
            }
            view = view2.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment$Companion;", "", "()V", "GALLERY_REQUEST_CODE", "", "TAG", "", "newInstance", "Lcom/zynksoftware/documentscanner/ui/camerascreen/CameraScreenFragment;", "DocumentScanner_release"})
    public static final class Companion {
        @NotNull
        public final CameraScreenFragment newInstance() {
            return new CameraScreenFragment();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

