/*
 * Decompiled with CFR 0.152.
 */
package com.zynksoftware.documentscanner.common.utils;

import android.graphics.Bitmap;
import android.graphics.PointF;
import com.zynksoftware.documentscanner.common.extensions.BitmapExtensionsKt;
import com.zynksoftware.documentscanner.common.extensions.OpenCvExtensionsKt;
import com.zynksoftware.documentscanner.common.utils.OpenCvNativeBridge;
import com.zynksoftware.documentscanner.common.utils.PerspectiveTransformation;
import com.zynksoftware.documentscanner.ui.components.Quadrilateral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u0018JN\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dJ\u0018\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0011H\u0002J!\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002\u00a2\u0006\u0002\u0010+\u00a8\u0006-"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge;", "", "()V", "contourArea", "", "approx", "Lorg/opencv/core/MatOfPoint2f;", "detectLargestQuadrilateral", "Lcom/zynksoftware/documentscanner/ui/components/Quadrilateral;", "src", "Lorg/opencv/core/Mat;", "distance", "p1", "Lorg/opencv/core/Point;", "p2", "findLargestContours", "", "Lorg/opencv/core/MatOfPoint;", "inputMat", "findQuadrilateral", "mContourList", "getContourEdgePoints", "Landroid/graphics/PointF;", "tempBitmap", "Landroid/graphics/Bitmap;", "getPoint", "bitmap", "getScannedBitmap", "x1", "", "y1", "x2", "y2", "x3", "y3", "x4", "y4", "hull2Points", "hull", "Lorg/opencv/core/MatOfInt;", "contour", "sortPoints", "", "([Lorg/opencv/core/Point;)[Lorg/opencv/core/Point;", "Companion", "DocumentScanner_release"})
public final class OpenCvNativeBridge {
    private static final int ANGLES_NUMBER = 4;
    private static final double EPSILON_CONSTANT = 0.02;
    private static final double CLOSE_KERNEL_SIZE = 10.0;
    private static final double CANNY_THRESHOLD_LOW = 75.0;
    private static final double CANNY_THRESHOLD_HIGH = 200.0;
    private static final double CUTOFF_THRESHOLD = 155.0;
    private static final double TRUNCATE_THRESHOLD = 150.0;
    private static final double NORMALIZATION_MIN_VALUE = 0.0;
    private static final double NORMALIZATION_MAX_VALUE = 255.0;
    private static final double BLURRING_KERNEL_SIZE = 5.0;
    private static final double DOWNSCALE_IMAGE_SIZE = 600.0;
    private static final int FIRST_MAX_CONTOURS = 10;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bitmap getScannedBitmap(@NotNull Bitmap bitmap, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        MatOfPoint2f rectangle = new MatOfPoint2f();
        rectangle.fromArray(new Point[]{new Point((double)x1, (double)y1), new Point((double)x2, (double)y2), new Point((double)x3, (double)y3), new Point((double)x4, (double)y4)});
        Mat dstMat = PerspectiveTransformation.INSTANCE.transform(BitmapExtensionsKt.toMat(bitmap), rectangle);
        return OpenCvExtensionsKt.toBitmap(dstMat);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PointF> getContourEdgePoints(@NotNull Bitmap tempBitmap) {
        Intrinsics.checkNotNullParameter((Object)tempBitmap, (String)"tempBitmap");
        MatOfPoint2f point2f = this.getPoint(tempBitmap);
        if (point2f == null) {
            point2f = new MatOfPoint2f();
        }
        Object[] objectArray = point2f.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"point2f.toArray()");
        List points = ArraysKt.toList((Object[])objectArray);
        List result = new ArrayList();
        int n = 0;
        int n2 = ((Collection)points).size();
        while (n < n2) {
            void i;
            result.add(new PointF((float)((Point)points.get((int)i)).x, (float)((Point)points.get((int)i)).y));
            ++i;
        }
        return result;
    }

    @Nullable
    public final MatOfPoint2f getPoint(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Mat src = BitmapExtensionsKt.toMat(bitmap);
        int n = src.width();
        int n2 = src.height();
        boolean bl = false;
        double ratio = 600.0 / (double)Math.max(n, n2);
        Size downscaledSize = new Size((double)src.width() * ratio, (double)src.height() * ratio);
        Mat downscaled = new Mat(downscaledSize, src.type());
        Imgproc.resize((Mat)src, (Mat)downscaled, (Size)downscaledSize);
        Quadrilateral largestRectangle = this.detectLargestQuadrilateral(downscaled);
        Quadrilateral quadrilateral = largestRectangle;
        return quadrilateral != null && (quadrilateral = quadrilateral.getContour()) != null ? OpenCvExtensionsKt.scaleRectangle((MatOfPoint2f)quadrilateral, (double)1.0f / ratio) : null;
    }

    @Nullable
    public final Quadrilateral detectLargestQuadrilateral(@NotNull Mat src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Mat destination = new Mat();
        Imgproc.blur((Mat)src, (Mat)src, (Size)new Size(5.0, 5.0));
        Core.normalize((Mat)src, (Mat)src, (double)0.0, (double)255.0, (int)32);
        Imgproc.threshold((Mat)src, (Mat)src, (double)150.0, (double)255.0, (int)2);
        Core.normalize((Mat)src, (Mat)src, (double)0.0, (double)255.0, (int)32);
        Imgproc.Canny((Mat)src, (Mat)destination, (double)200.0, (double)75.0);
        Imgproc.threshold((Mat)destination, (Mat)destination, (double)155.0, (double)255.0, (int)3);
        Imgproc.morphologyEx((Mat)destination, (Mat)destination, (int)3, (Mat)new Mat(new Size(10.0, 10.0), CvType.CV_8UC1, new Scalar(255.0)), (Point)new Point(-1.0, -1.0), (int)1);
        List<MatOfPoint> largestContour = this.findLargestContours(destination);
        if (largestContour != null) {
            return this.findQuadrilateral(largestContour);
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Quadrilateral findQuadrilateral(List<? extends MatOfPoint> mContourList) {
        for (MatOfPoint c : mContourList) {
            block9: {
                block11: {
                    block10: {
                        block8: {
                            v0 = c.toArray();
                            c2f = new MatOfPoint2f(Arrays.copyOf(v0, v0.length));
                            peri = Imgproc.arcLength((MatOfPoint2f)c2f, (boolean)true);
                            approx = new MatOfPoint2f();
                            Imgproc.approxPolyDP((MatOfPoint2f)c2f, (MatOfPoint2f)approx, (double)(0.02 * peri), (boolean)true);
                            points = approx.toArray();
                            if (approx.rows() == 4) {
                                Intrinsics.checkNotNullExpressionValue((Object)points, (String)"points");
                                foundPoints = this.sortPoints((Point[])points);
                                return new Quadrilateral(approx, foundPoints);
                            }
                            if (approx.rows() != 5) continue;
                            shortestDistance = 0x7FFFFFFF;
                            shortestPoint1 /* !! */  = null;
                            shortestPoint2 /* !! */  = null;
                            diagonal = (double)false;
                            diagonalPoint1 /* !! */  = null;
                            diagonalPoint2 /* !! */  = null;
                            var17_15 = 0;
                            var18_17 = 4;
                            while (var17_15 < var18_17) {
                                var19_19 = i + true;
                                var20_26 = 5;
                                while (var19_19 < var20_26) {
                                    v1 = points[i];
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"points[i]");
                                    v2 = points[j];
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"points[j]");
                                    d = this.distance((Point)v1, (Point)v2);
                                    if (d < shortestDistance) {
                                        shortestDistance = d;
                                        shortestPoint1 /* !! */  = points[i];
                                        shortestPoint2 /* !! */  = points[j];
                                    }
                                    if (d > diagonal) {
                                        diagonal = d;
                                        diagonalPoint1 /* !! */  = points[i];
                                        diagonalPoint2 /* !! */  = points[j];
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)points, (String)"points");
                            v3 = trianglePointWithHypotenuse = (Point)CollectionsKt.minus((Iterable)ArraysKt.toList((Object[])points), (Iterable)CollectionsKt.arrayListOf((Object[])new Point[]{shortestPoint1 /* !! */ , shortestPoint2 /* !! */ , diagonalPoint1 /* !! */ , diagonalPoint2 /* !! */ })).get(0);
                            Intrinsics.checkNotNull((Object)v3);
                            v4 = v3.x;
                            v5 /* !! */  = shortestPoint1 /* !! */ ;
                            Intrinsics.checkNotNull((Object)v5 /* !! */ );
                            if (!(v4 > v5 /* !! */ .x)) break block8;
                            v6 = trianglePointWithHypotenuse.x;
                            v7 /* !! */  = shortestPoint2 /* !! */ ;
                            Intrinsics.checkNotNull((Object)v7 /* !! */ );
                            if (!(v6 > v7 /* !! */ .x) || !(trianglePointWithHypotenuse.y > shortestPoint1 /* !! */ .y) || !(trianglePointWithHypotenuse.y > shortestPoint2 /* !! */ .y)) break block8;
                            j = shortestPoint1 /* !! */ .x;
                            var21_28 = shortestPoint2 /* !! */ .x;
                            var23_29 = false;
                            v8 = Math.min(j, var21_28);
                            j = shortestPoint1 /* !! */ .y;
                            var21_28 = shortestPoint2 /* !! */ .y;
                            var23_29 = false;
                            v9 = new Point(v8, Math.min(j, var21_28));
                            v10 = v9;
                            break block9;
                        }
                        if (!(trianglePointWithHypotenuse.x < shortestPoint1 /* !! */ .x)) break block10;
                        v11 = trianglePointWithHypotenuse.x;
                        v12 /* !! */  = shortestPoint2 /* !! */ ;
                        Intrinsics.checkNotNull((Object)v12 /* !! */ );
                        if (!(v11 < v12 /* !! */ .x) || !(trianglePointWithHypotenuse.y > shortestPoint1 /* !! */ .y) || !(trianglePointWithHypotenuse.y > shortestPoint2 /* !! */ .y)) break block10;
                        j = shortestPoint1 /* !! */ .x;
                        var21_28 = shortestPoint2 /* !! */ .x;
                        var23_29 = false;
                        v13 = Math.max(j, var21_28);
                        j = shortestPoint1 /* !! */ .y;
                        var21_28 = shortestPoint2 /* !! */ .y;
                        var23_29 = false;
                        v14 = new Point(v13, Math.min(j, var21_28));
                        v10 = v14;
                        break block9;
                    }
                    if (!(trianglePointWithHypotenuse.x < shortestPoint1 /* !! */ .x)) break block11;
                    v15 = trianglePointWithHypotenuse.x;
                    v16 /* !! */  = shortestPoint2 /* !! */ ;
                    Intrinsics.checkNotNull((Object)v16 /* !! */ );
                    if (!(v15 < v16 /* !! */ .x) || !(trianglePointWithHypotenuse.y < shortestPoint1 /* !! */ .y) || !(trianglePointWithHypotenuse.y < shortestPoint2 /* !! */ .y)) break block11;
                    j = shortestPoint1 /* !! */ .x;
                    var21_28 = shortestPoint2 /* !! */ .x;
                    var23_29 = false;
                    v17 = Math.max(j, var21_28);
                    j = shortestPoint1 /* !! */ .y;
                    var21_28 = shortestPoint2 /* !! */ .y;
                    var23_29 = false;
                    v18 = new Point(v17, Math.max(j, var21_28));
                    v10 = v18;
                    break block9;
                }
                if (!(trianglePointWithHypotenuse.x > shortestPoint1 /* !! */ .x)) ** GOTO lbl-1000
                v19 = trianglePointWithHypotenuse.x;
                v20 /* !! */  = shortestPoint2 /* !! */ ;
                Intrinsics.checkNotNull((Object)v20 /* !! */ );
                if (v19 > v20 /* !! */ .x && trianglePointWithHypotenuse.y < shortestPoint1 /* !! */ .y && trianglePointWithHypotenuse.y < shortestPoint2 /* !! */ .y) {
                    j = shortestPoint1 /* !! */ .x;
                    var21_28 = shortestPoint2 /* !! */ .x;
                    var23_29 = false;
                    v21 = Math.min(j, var21_28);
                    j = shortestPoint1 /* !! */ .y;
                    var21_28 = shortestPoint2 /* !! */ .y;
                    var23_29 = false;
                    v22 = new Point(v21, Math.max(j, var21_28));
                    v10 = v22;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = new Point(0.0, 0.0);
                }
            }
            newPoint = v10;
            v23 = new Point[4];
            v23[0] = trianglePointWithHypotenuse;
            v24 /* !! */  = diagonalPoint1 /* !! */ ;
            Intrinsics.checkNotNull((Object)v24 /* !! */ );
            v23[1] = v24 /* !! */ ;
            v25 /* !! */  = diagonalPoint2 /* !! */ ;
            Intrinsics.checkNotNull((Object)v25 /* !! */ );
            v23[2] = v25 /* !! */ ;
            v23[3] = newPoint;
            sortedPoints = this.sortPoints(v23);
            newApprox = new MatOfPoint2f();
            newApprox.fromArray(Arrays.copyOf(sortedPoints, sortedPoints.length));
            return new Quadrilateral(newApprox, sortedPoints);
        }
        return null;
    }

    private final double distance(Point p1, Point p2) {
        double d = p1.x - p2.x;
        double d2 = 2.0;
        boolean bl = false;
        double d3 = Math.pow(d, d2);
        d = p1.y - p2.y;
        d2 = 2.0;
        bl = false;
        d = d3 + Math.pow(d, d2);
        boolean bl2 = false;
        return Math.sqrt(d);
    }

    /*
     * WARNING - void declaration
     */
    private final Point[] sortPoints(Point[] src) {
        void $this$mapTo$iv$iv;
        ArrayList srcPoints = new ArrayList(ArraysKt.toList((Object[])src));
        Point[] result = new Point[]{null, null, null, null};
        Comparator sumComparator2 = sortPoints.sumComparator.1.INSTANCE;
        Comparator diffComparator2 = sortPoints.diffComparator.1.INSTANCE;
        result[0] = (Point)Collections.min(srcPoints, sumComparator2);
        result[2] = (Point)Collections.max(srcPoints, sumComparator2);
        result[1] = (Point)Collections.min(srcPoints, diffComparator2);
        result[3] = (Point)Collections.max(srcPoints, diffComparator2);
        Point[] $this$map$iv = result;
        boolean $i$f$map = false;
        Point[] pointArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var11_11 = $this$mapTo$iv$iv;
        int n = ((void)var11_11).length;
        for (int i = 0; i < n; ++i) {
            void var18_18;
            void it;
            void item$iv$iv;
            void var15_15 = item$iv$iv = var11_11[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(var18_18);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Point[] pointArray2 = thisCollection$iv.toArray(new Point[0]);
        if (pointArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return pointArray2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MatOfPoint> findLargestContours(Mat inputMat) {
        Mat mHierarchy = new Mat();
        List mContourList = new ArrayList();
        Imgproc.findContours((Mat)inputMat, (List)mContourList, (Mat)mHierarchy, (int)1, (int)2);
        List mHullList = new ArrayList();
        MatOfInt tempHullIndices = new MatOfInt();
        int n = 0;
        int n2 = ((Collection)mContourList).size();
        while (n < n2) {
            void i;
            Imgproc.convexHull((MatOfPoint)((MatOfPoint)mContourList.get((int)i)), (MatOfInt)tempHullIndices);
            mHullList.add(this.hull2Points(tempHullIndices, (MatOfPoint)mContourList.get((int)i)));
            ++i;
        }
        for (MatOfPoint c : mContourList) {
            c.release();
        }
        tempHullIndices.release();
        mHierarchy.release();
        if (mHullList.size() != 0) {
            CollectionsKt.sortWith((List)mHullList, (Comparator)findLargestContours.1.INSTANCE);
            n = mHullList.size();
            int n3 = 10;
            boolean bl = false;
            return mHullList.subList(0, Math.min(n, n3));
        }
        return null;
    }

    private final MatOfPoint hull2Points(MatOfInt hull, MatOfPoint contour) {
        List indexes = hull.toList();
        List points = new ArrayList();
        List ctrList = contour.toList();
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            Integer index;
            Integer n = index = (Integer)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"index");
            Object e = ctrList.get(n);
            Intrinsics.checkNotNullExpressionValue(e, (String)"ctrList[index]");
            points.add(e);
        }
        MatOfPoint point = new MatOfPoint();
        point.fromList(points);
        return point;
    }

    public final double contourArea(@NotNull MatOfPoint2f approx) {
        Intrinsics.checkNotNullParameter((Object)approx, (String)"approx");
        return Imgproc.contourArea((Mat)((Mat)approx));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/zynksoftware/documentscanner/common/utils/OpenCvNativeBridge$Companion;", "", "()V", "ANGLES_NUMBER", "", "BLURRING_KERNEL_SIZE", "", "CANNY_THRESHOLD_HIGH", "CANNY_THRESHOLD_LOW", "CLOSE_KERNEL_SIZE", "CUTOFF_THRESHOLD", "DOWNSCALE_IMAGE_SIZE", "EPSILON_CONSTANT", "FIRST_MAX_CONTOURS", "NORMALIZATION_MAX_VALUE", "NORMALIZATION_MIN_VALUE", "TRUNCATE_THRESHOLD", "DocumentScanner_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

