/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.integration.webp.decoder;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class Utils {
    private static final String TAG = "Utils";

    Utils() {
    }

    static int getSampleSize(int srcWidth, int srcHeight, int targetWidth, int targetHeight) {
        int exactSampleSize = Math.min(srcHeight / targetHeight, srcWidth / targetWidth);
        int powerOfTwoSampleSize = exactSampleSize == 0 ? 0 : Integer.highestOneBit(exactSampleSize);
        int sampleSize = Math.max(1, powerOfTwoSampleSize);
        if (Log.isLoggable((String)TAG, (int)2) && sampleSize > 1) {
            Log.v((String)TAG, (String)("Downsampling WEBP, sampleSize: " + sampleSize + ", target dimens: [" + targetWidth + "x" + targetHeight + "], actual dimens: [" + srcWidth + "x" + srcHeight + "]"));
        }
        return sampleSize;
    }

    static byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
            return null;
        }
        return buffer.toByteArray();
    }
}

