/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.data.jpa.specification;

import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.muyie.framework.data.jpa.specification.AbstractSpecification;
import org.springframework.util.CollectionUtils;

public class EqualSpecification<T>
extends AbstractSpecification<T> {
    private static final long serialVersionUID = 1L;
    private final String property;
    private final List<Object> values;

    public EqualSpecification(String property, List<Object> values) {
        this(property, values, JoinType.INNER);
    }

    public EqualSpecification(String property, List<Object> values, JoinType joinType) {
        super(joinType);
        this.property = property;
        this.values = values;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        From<?, ?> from = this.getRoot(this.property, root);
        String field = this.getProperty(this.property);
        if (CollectionUtils.isEmpty(this.values)) {
            return criteriaBuilder.isNull((Expression)from.get(field));
        }
        if (this.values.size() == 1) {
            return this.getPredicate(from, criteriaBuilder, field, this.values.get(0));
        }
        Predicate[] predicates = new Predicate[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            predicates[i] = this.getPredicate(from, criteriaBuilder, field, this.values.get(i));
        }
        return criteriaBuilder.or(predicates);
    }

    private Predicate getPredicate(From<?, ?> from, CriteriaBuilder criteriaBuilder, String field, Object value) {
        return Objects.isNull(value) ? criteriaBuilder.isNull((Expression)from.get(field)) : criteriaBuilder.equal((Expression)from.get(field), value);
    }
}

