/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.config;

import org.apache.commons.lang3.StringUtils;
import org.muyie.framework.config.MuyieProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={MuyieProperties.class, JacksonProperties.class})
@Order(value=0x7FFFFFFF)
public class DateTimeFormatConfiguration
implements WebMvcConfigurer,
InitializingBean {
    private final JacksonProperties jacksonProperties;

    public DateTimeFormatConfiguration(JacksonProperties jacksonProperties) {
        this.jacksonProperties = jacksonProperties;
    }

    public void addFormatters(FormatterRegistry registry) {
        DateTimeFormatterRegistrar registrar = new DateTimeFormatterRegistrar();
        registrar.setUseIsoFormat(true);
        registrar.registerFormatters(registry);
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.jacksonProperties.getDateFormat())) {
            this.jacksonProperties.setDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    }
}

