/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.async;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.muyie.framework.config.MuyieProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class MuyieSchedulingConfigurer
implements SchedulingConfigurer {
    private final MuyieProperties.Async properties;

    public MuyieSchedulingConfigurer(MuyieProperties muyieProperties) {
        this.properties = muyieProperties.getAsync();
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.scheduledTaskExecutor());
    }

    @Bean
    @Qualifier(value="scheduledTaskExecutor")
    public ScheduledExecutorService scheduledTaskExecutor() {
        int corePoolSize = this.properties.getCorePoolSize();
        return Executors.newScheduledThreadPool(corePoolSize);
    }
}

