/*
 * Decompiled with CFR 0.152.
 */
package org.muyie.framework.async;

import org.muyie.framework.async.MuyieAsyncConfigurer;
import org.muyie.framework.async.MuyieAsyncTaskExecutor;
import org.muyie.framework.async.MuyieSchedulingConfigurer;
import org.muyie.framework.async.MuyieTaskExecutor;
import org.muyie.framework.config.MuyieProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={MuyieProperties.class})
@EnableAsync
@EnableScheduling
public class MuyieAsyncConfiguration
implements WebMvcConfigurer {
    private final MuyieProperties muyieProperties;

    public MuyieAsyncConfiguration(MuyieProperties muyieProperties) {
        this.muyieProperties = muyieProperties;
    }

    @Bean(value={"muyieAsyncConfigurer"})
    @ConditionalOnMissingBean
    public MuyieAsyncConfigurer muyieAsyncConfigurer() {
        return new MuyieAsyncConfigurer(this.muyieProperties);
    }

    @Bean(value={"muyieAsyncTaskExecutor"})
    @ConditionalOnMissingBean
    public MuyieAsyncTaskExecutor muyieAsyncTaskExecutor() {
        return new MuyieAsyncTaskExecutor(this.muyieAsyncConfigurer().create());
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.setTaskExecutor((AsyncTaskExecutor)this.muyieAsyncTaskExecutor());
    }

    @Bean(value={"muyieSchedulingConfigurer"})
    @ConditionalOnMissingBean
    public MuyieSchedulingConfigurer muyieSchedulingConfigurer() {
        return new MuyieSchedulingConfigurer(this.muyieProperties);
    }

    @Bean(value={"muyieTaskExecutor"})
    @ConditionalOnMissingBean
    public MuyieTaskExecutor muyieTaskExecutor() {
        return new MuyieTaskExecutor(this.muyieAsyncTaskExecutor(), this.muyieSchedulingConfigurer().scheduledTaskExecutor());
    }
}

