/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.indicator.drawer;

import android.animation.ArgbEvaluator;
import android.graphics.Paint;
import android.graphics.RectF;
import com.zhpan.indicator.drawer.IDrawer;
import com.zhpan.indicator.option.IndicatorOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u00015B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0002J0\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020)H\u0016J\u001c\u00102\u001a\u00060\u0012R\u00020\u00002\u0006\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020)H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0004R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$\u00a8\u00066"}, d2={"Lcom/zhpan/indicator/drawer/BaseDrawer;", "Lcom/zhpan/indicator/drawer/IDrawer;", "mIndicatorOptions", "Lcom/zhpan/indicator/option/IndicatorOptions;", "(Lcom/zhpan/indicator/option/IndicatorOptions;)V", "argbEvaluator", "Landroid/animation/ArgbEvaluator;", "getArgbEvaluator$indicator_release", "()Landroid/animation/ArgbEvaluator;", "setArgbEvaluator$indicator_release", "(Landroid/animation/ArgbEvaluator;)V", "isWidthEquals", "", "()Z", "getMIndicatorOptions$indicator_release", "()Lcom/zhpan/indicator/option/IndicatorOptions;", "setMIndicatorOptions$indicator_release", "mMeasureResult", "Lcom/zhpan/indicator/drawer/BaseDrawer$MeasureResult;", "mPaint", "Landroid/graphics/Paint;", "getMPaint$indicator_release", "()Landroid/graphics/Paint;", "setMPaint$indicator_release", "(Landroid/graphics/Paint;)V", "mRectF", "Landroid/graphics/RectF;", "getMRectF$indicator_release", "()Landroid/graphics/RectF;", "setMRectF$indicator_release", "(Landroid/graphics/RectF;)V", "maxWidth", "", "getMaxWidth$indicator_release", "()F", "setMaxWidth$indicator_release", "(F)V", "minWidth", "getMinWidth$indicator_release", "setMinWidth$indicator_release", "measureHeight", "", "measureWidth", "onLayout", "", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "MeasureResult", "indicator_release"})
public abstract class BaseDrawer
implements IDrawer {
    private final MeasureResult mMeasureResult;
    private float maxWidth;
    private float minWidth;
    @NotNull
    private Paint mPaint;
    @NotNull
    private RectF mRectF;
    @Nullable
    private ArgbEvaluator argbEvaluator;
    @NotNull
    private IndicatorOptions mIndicatorOptions;

    public final float getMaxWidth$indicator_release() {
        return this.maxWidth;
    }

    public final void setMaxWidth$indicator_release(float f) {
        this.maxWidth = f;
    }

    public final float getMinWidth$indicator_release() {
        return this.minWidth;
    }

    public final void setMinWidth$indicator_release(float f) {
        this.minWidth = f;
    }

    @NotNull
    public final Paint getMPaint$indicator_release() {
        return this.mPaint;
    }

    public final void setMPaint$indicator_release(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"<set-?>");
        this.mPaint = paint;
    }

    @NotNull
    public final RectF getMRectF$indicator_release() {
        return this.mRectF;
    }

    public final void setMRectF$indicator_release(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.mRectF = rectF;
    }

    @Nullable
    public final ArgbEvaluator getArgbEvaluator$indicator_release() {
        return this.argbEvaluator;
    }

    public final void setArgbEvaluator$indicator_release(@Nullable ArgbEvaluator argbEvaluator) {
        this.argbEvaluator = argbEvaluator;
    }

    protected final boolean isWidthEquals() {
        return this.mIndicatorOptions.getNormalSliderWidth() == this.mIndicatorOptions.getCheckedSliderWidth();
    }

    @Override
    @NotNull
    public MeasureResult onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.maxWidth = RangesKt.coerceAtLeast((float)this.mIndicatorOptions.getNormalSliderWidth(), (float)this.mIndicatorOptions.getCheckedSliderWidth());
        this.minWidth = RangesKt.coerceAtMost((float)this.mIndicatorOptions.getNormalSliderWidth(), (float)this.mIndicatorOptions.getCheckedSliderWidth());
        this.mMeasureResult.setMeasureResult$indicator_release(this.measureWidth(), this.measureHeight());
        return this.mMeasureResult;
    }

    protected int measureHeight() {
        return (int)this.mIndicatorOptions.getSliderHeight();
    }

    private final int measureWidth() {
        int pageSize = this.mIndicatorOptions.getPageSize();
        float indicatorGap = this.mIndicatorOptions.getSliderGap();
        return (int)((float)(pageSize - 1) * indicatorGap + this.maxWidth + (float)(pageSize - 1) * this.minWidth);
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    @NotNull
    public final IndicatorOptions getMIndicatorOptions$indicator_release() {
        return this.mIndicatorOptions;
    }

    public final void setMIndicatorOptions$indicator_release(@NotNull IndicatorOptions indicatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)indicatorOptions, (String)"<set-?>");
        this.mIndicatorOptions = indicatorOptions;
    }

    public BaseDrawer(@NotNull IndicatorOptions mIndicatorOptions) {
        Intrinsics.checkParameterIsNotNull((Object)mIndicatorOptions, (String)"mIndicatorOptions");
        this.mIndicatorOptions = mIndicatorOptions;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mMeasureResult = new MeasureResult();
        this.mRectF = new RectF();
        if (this.mIndicatorOptions.getSlideMode() == 4 || this.mIndicatorOptions.getSlideMode() == 5) {
            this.argbEvaluator = new ArgbEvaluator();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000fR$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/zhpan/indicator/drawer/BaseDrawer$MeasureResult;", "", "(Lcom/zhpan/indicator/drawer/BaseDrawer;)V", "<set-?>", "", "measureHeight", "getMeasureHeight", "()I", "setMeasureHeight$indicator_release", "(I)V", "measureWidth", "getMeasureWidth", "setMeasureWidth$indicator_release", "setMeasureResult", "", "setMeasureResult$indicator_release", "indicator_release"})
    public final class MeasureResult {
        private int measureWidth;
        private int measureHeight;

        public final int getMeasureWidth() {
            return this.measureWidth;
        }

        public final void setMeasureWidth$indicator_release(int n) {
            this.measureWidth = n;
        }

        public final int getMeasureHeight() {
            return this.measureHeight;
        }

        public final void setMeasureHeight$indicator_release(int n) {
            this.measureHeight = n;
        }

        public final void setMeasureResult$indicator_release(int measureWidth, int measureHeight) {
            this.measureWidth = measureWidth;
            this.measureHeight = measureHeight;
        }
    }
}

