/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.zhpan.bannerview.indicator.BaseIndicatorView;

public class DashIndicatorView
extends BaseIndicatorView {
    private Paint mPaint = new Paint();
    private float sliderHeight;

    public DashIndicatorView(Context context) {
        this(context, null);
    }

    public DashIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DashIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setColor(this.normalColor);
        this.mPaint.setAntiAlias(true);
        this.sliderHeight = this.normalIndicatorWidth / 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension((int)((float)(this.mPageSize - 1) * this.mIndicatorGap + this.normalIndicatorWidth * (float)this.mPageSize), (int)this.sliderHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.normalColor);
        for (int i = 0; i < this.mPageSize; ++i) {
            this.mPaint.setColor(this.normalColor);
            canvas.drawRect((float)i * this.normalIndicatorWidth + (float)i * this.mIndicatorGap, 0.0f, (float)i * this.normalIndicatorWidth + (float)i * this.mIndicatorGap + this.normalIndicatorWidth, this.sliderHeight, this.mPaint);
        }
        this.drawSliderStyle(canvas);
    }

    @Override
    public void onPageSelected(int position) {
        super.onPageSelected(position);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        super.onPageScrolled(position, positionOffset, positionOffsetPixels);
    }

    @Override
    public void onPageScrollStateChanged(int state) {
        super.onPageScrollStateChanged(state);
    }

    private void drawSliderStyle(Canvas canvas) {
        this.mPaint.setColor(this.checkedColor);
        float left = (float)this.currentPosition * this.checkedIndicatorWidth + (float)this.currentPosition * this.mIndicatorGap + (this.checkedIndicatorWidth + this.mIndicatorGap) * this.slideProgress;
        canvas.drawRect(left, 0.0f, left + this.checkedIndicatorWidth, this.sliderHeight, this.mPaint);
    }

    public DashIndicatorView setSliderHeight(int sliderHeight) {
        this.sliderHeight = sliderHeight;
        return this;
    }
}

