/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.zhpan.bannerview.enums.IndicatorSlideMode;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.utils.DpUtils;

public class CircleIndicatorView
extends View
implements IIndicator {
    private static final String tag = "IndicatorView";
    private int normalColor;
    private int checkedColor;
    private Paint mPaint;
    private int mPageSize;
    private float mNormalRadius;
    private float mCheckedRadius;
    private float maxRadius;
    private int height;
    private int currentPosition;
    private float mMargin;
    private IndicatorSlideMode mSlideStyle = IndicatorSlideMode.SMOOTH;
    private float slideProgress;

    public CircleIndicatorView(Context context) {
        this(context, null);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.normalColor = Color.parseColor((String)"#8C18171C");
        this.checkedColor = Color.parseColor((String)"#8C6C6D72");
        this.mPaint = new Paint();
        this.mPaint.setColor(this.normalColor);
        this.mPaint.setAntiAlias(true);
        this.mCheckedRadius = this.mNormalRadius = (float)DpUtils.dp2px(context, 4.0f);
        this.mMargin = this.mNormalRadius * 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.maxRadius = Math.max(this.mCheckedRadius, this.mNormalRadius);
        this.setMeasuredDimension((int)((float)(this.mPageSize - 1) * this.mMargin + 2.0f * this.maxRadius * (float)this.mPageSize), (int)(2.0f * this.maxRadius));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.mPageSize; ++i) {
            this.mPaint.setColor(this.normalColor);
            canvas.drawCircle(this.maxRadius + (2.0f * this.mNormalRadius + this.mMargin) * (float)i, (float)this.height / 2.0f, this.mNormalRadius, this.mPaint);
        }
        this.drawSlideStyle(canvas);
    }

    @Override
    public void onPageSelected(int position) {
        if (this.mSlideStyle == IndicatorSlideMode.NORMAL) {
            this.currentPosition = position;
            this.invalidate();
        }
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mSlideStyle == IndicatorSlideMode.SMOOTH) {
            this.slideProgress = positionOffset;
            this.currentPosition = position;
            this.invalidate();
        }
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    private void drawSlideStyle(Canvas canvas) {
        switch (this.mSlideStyle) {
            case NORMAL: {
                this.slideProgress = 0.0f;
            }
            case SMOOTH: {
                this.slideProgress = this.currentPosition == this.mPageSize - 1 ? 0.0f : this.slideProgress;
            }
        }
        this.mPaint.setColor(this.checkedColor);
        canvas.drawCircle(this.maxRadius + (2.0f * this.mNormalRadius + this.mMargin) * (float)this.currentPosition + (2.0f * this.mNormalRadius + this.mMargin) * this.slideProgress, (float)this.height / 2.0f, this.mCheckedRadius, this.mPaint);
    }

    public CircleIndicatorView setNormalColor(int normalColor) {
        this.normalColor = normalColor;
        return this;
    }

    public CircleIndicatorView setCheckedColor(int checkedColor) {
        this.checkedColor = checkedColor;
        return this;
    }

    public CircleIndicatorView setPageSize(int pageSize) {
        this.mPageSize = pageSize;
        this.requestLayout();
        return this;
    }

    public CircleIndicatorView setIndicatorRadius(float radiusDp, float checkedRadius) {
        this.mNormalRadius = radiusDp;
        this.mCheckedRadius = checkedRadius;
        return this;
    }

    public CircleIndicatorView setIndicatorMargin(float margin) {
        if (margin > 0.0f) {
            this.mMargin = margin;
        }
        return this;
    }

    public CircleIndicatorView setSlideStyle(IndicatorSlideMode slideStyle) {
        this.mSlideStyle = slideStyle;
        return this;
    }
}

