/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.zhpan.bannerview.Utils.DpUtils;

public class IndicatorView
extends View {
    private int normalColor = Color.parseColor((String)"#000000");
    private int checkedColor = Color.parseColor((String)"#ffffff");
    private Paint mPaint = new Paint();
    private int mPageSize;
    private float mRadius;
    private int height;
    private int selectPage;
    private float mMargin;

    public IndicatorView(Context context) {
        this(context, null);
    }

    public IndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setColor(this.normalColor);
        this.mPaint.setAntiAlias(true);
        this.mRadius = DpUtils.dp2px(context, 4.0f);
        this.mMargin = this.mRadius * 2.0f;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.height = this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension((int)((float)(this.mPageSize - 1) * this.mMargin + 2.0f * this.mRadius * (float)this.mPageSize + this.mRadius * 3.0f), (int)(2.0f * this.mRadius));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.mPageSize; ++i) {
            this.mPaint.setColor(this.selectPage == i ? this.checkedColor : this.normalColor);
            canvas.drawCircle(this.mRadius + (2.0f * this.mRadius + this.mMargin) * (float)i, (float)this.height / 2.0f, this.mRadius, this.mPaint);
        }
    }

    public void pageSelect(int selectPage) {
        this.selectPage = selectPage;
        this.invalidate();
    }

    public IndicatorView setNormalColor(int normalColor) {
        this.normalColor = normalColor;
        return this;
    }

    public IndicatorView setCheckedColor(int checkedColor) {
        this.checkedColor = checkedColor;
        return this;
    }

    public IndicatorView setPageSize(int pageSize) {
        this.mPageSize = pageSize;
        this.requestLayout();
        return this;
    }

    public IndicatorView setIndicatorRadius(float radiusDp) {
        this.mRadius = radiusDp;
        return this;
    }

    public IndicatorView setIndicatorMargin(float margin) {
        if (margin > 0.0f) {
            this.mMargin = margin;
        }
        return this;
    }
}

