/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.provider;

import android.graphics.Rect;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.zhpan.bannerview.utils.BannerUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ScrollDurationManger
extends LinearLayoutManager {
    private final LinearLayoutManager mParent;
    private final int scrollDuration;

    public ScrollDurationManger(ViewPager2 viewPager2, int scrollDuration, LinearLayoutManager linearLayoutManager) {
        super(viewPager2.getContext(), linearLayoutManager.getOrientation(), false);
        this.scrollDuration = scrollDuration;
        this.mParent = linearLayoutManager;
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            protected int calculateTimeForDeceleration(int dx) {
                return ScrollDurationManger.this.scrollDuration;
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    public boolean performAccessibilityAction(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, int action, @Nullable Bundle args) {
        return this.mParent.performAccessibilityAction(recycler, state, action, args);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull AccessibilityNodeInfoCompat info) {
        this.mParent.onInitializeAccessibilityNodeInfo(recycler, state, info);
    }

    protected void calculateExtraLayoutSpace(@NonNull RecyclerView.State state, @NonNull int[] extraLayoutSpace) {
        try {
            Method method = this.mParent.getClass().getDeclaredMethod("calculateExtraLayoutSpace", state.getClass(), extraLayoutSpace.getClass());
            method.setAccessible(true);
            method.invoke((Object)this.mParent, state, extraLayoutSpace);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            BannerUtils.log(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            BannerUtils.log(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            BannerUtils.log(e.getMessage());
        }
    }

    public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
        return false;
    }
}

