/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.utils;

import android.content.res.Resources;
import android.util.Log;

public class BannerUtils {
    private static boolean debugMode = false;
    private static final String TAG = "BVP";

    public static void setDebugMode(boolean isDebug) {
        debugMode = isDebug;
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    public static int dp2px(float dpValue) {
        return (int)(0.5f + dpValue * Resources.getSystem().getDisplayMetrics().density);
    }

    public static void log(String tag, String msg) {
        if (BannerUtils.isDebugMode()) {
            Log.e((String)tag, (String)msg);
        }
    }

    public static void log(String msg) {
        if (BannerUtils.isDebugMode()) {
            BannerUtils.log(TAG, msg);
        }
    }

    public static int getRealPosition(boolean isCanLoop, int position, int pageSize) {
        if (pageSize == 0) {
            return 0;
        }
        return isCanLoop ? (position + pageSize) % pageSize : (position + pageSize) % pageSize;
    }

    public static int getOriginalPosition(int pageSize) {
        return 250 - 250 % pageSize;
    }
}

