/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.provider;

import android.graphics.Rect;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import java.lang.reflect.Field;

public class ProxyLayoutManger
extends LinearLayoutManager {
    private LinearLayoutManager linearLayoutManager;
    private RecyclerView recyclerView;
    private ViewPager2 mViewPager2;
    private long scrollDuration;

    public static void setScrollProxy(ViewPager2 viewPager2, long scrollDuration) {
        RecyclerView recyclerView = (RecyclerView)viewPager2.getChildAt(0);
        recyclerView.setOverScrollMode(2);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager != null) {
            ProxyLayoutManger manger = new ProxyLayoutManger(viewPager2, scrollDuration, recyclerView, (LinearLayoutManager)layoutManager);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)manger);
        }
    }

    private ProxyLayoutManger(ViewPager2 viewPager2, long scrollDuration, RecyclerView recyclerView, LinearLayoutManager layoutManager) {
        super(viewPager2.getContext(), layoutManager.getOrientation(), false);
        this.mViewPager2 = viewPager2;
        this.scrollDuration = scrollDuration;
        this.recyclerView = recyclerView;
        this.linearLayoutManager = layoutManager;
        this.reflectLayoutManager();
    }

    private void reflectLayoutManager() {
        try {
            Field mRecyclerView = RecyclerView.LayoutManager.class.getDeclaredField("mRecyclerView");
            mRecyclerView.setAccessible(true);
            mRecyclerView.set(this.linearLayoutManager, this.recyclerView);
            Field LayoutMangerField = ViewPager2.class.getDeclaredField("mLayoutManager");
            LayoutMangerField.setAccessible(true);
            LayoutMangerField.set(this.mViewPager2, (Object)this);
            Field pageTransformerAdapterField = ViewPager2.class.getDeclaredField("mPageTransformerAdapter");
            pageTransformerAdapterField.setAccessible(true);
            Object mPageTransformerAdapter = pageTransformerAdapterField.get(this.mViewPager2);
            if (mPageTransformerAdapter != null) {
                Class<?> aClass = mPageTransformerAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mPageTransformerAdapter, (Object)this);
            }
            Field scrollEventAdapterField = ViewPager2.class.getDeclaredField("mScrollEventAdapter");
            scrollEventAdapterField.setAccessible(true);
            Object mScrollEventAdapter = scrollEventAdapterField.get(this.mViewPager2);
            if (mScrollEventAdapter != null) {
                Class<?> aClass = mScrollEventAdapter.getClass();
                Field layoutManager = aClass.getDeclaredField("mLayoutManager");
                layoutManager.setAccessible(true);
                layoutManager.set(mScrollEventAdapter, (Object)this);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public boolean performAccessibilityAction(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, int action, @Nullable Bundle args) {
        return this.linearLayoutManager.performAccessibilityAction(recycler, state, action, args);
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull RecyclerView.Recycler recycler, @NonNull RecyclerView.State state, @NonNull AccessibilityNodeInfoCompat info) {
        this.linearLayoutManager.onInitializeAccessibilityNodeInfo(recycler, state, info);
    }

    public boolean requestChildRectangleOnScreen(@NonNull RecyclerView parent, @NonNull View child, @NonNull Rect rect, boolean immediate, boolean focusedChildVisible) {
        return this.linearLayoutManager.requestChildRectangleOnScreen(parent, child, rect, immediate);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

            protected int calculateTimeForDeceleration(int dx) {
                return (int)((double)ProxyLayoutManger.this.scrollDuration * 0.6644);
            }
        };
        linearSmoothScroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
    }

    protected void calculateExtraLayoutSpace(@NonNull RecyclerView.State state, @NonNull int[] extraLayoutSpace) {
        int offscreenSpace;
        int pageLimit = this.mViewPager2.getOffscreenPageLimit();
        if (pageLimit == -1) {
            super.calculateExtraLayoutSpace(state, extraLayoutSpace);
            return;
        }
        extraLayoutSpace[0] = offscreenSpace = this.getPageSize() * pageLimit;
        extraLayoutSpace[1] = offscreenSpace;
    }

    private int getPageSize() {
        RecyclerView rv = (RecyclerView)this.mViewPager2.getChildAt(0);
        return this.getOrientation() == 0 ? rv.getWidth() - rv.getPaddingLeft() - rv.getPaddingRight() : rv.getHeight() - rv.getPaddingTop() - rv.getPaddingBottom();
    }
}

