/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator.drawer;

import android.graphics.Canvas;
import android.graphics.RectF;
import com.zhpan.bannerview.indicator.drawer.BaseDrawer;
import com.zhpan.bannerview.manager.IndicatorOptions;
import com.zhpan.bannerview.utils.BannerUtils;

public class CircleDrawer
extends BaseDrawer {
    private RectF rectF = new RectF();

    CircleDrawer(IndicatorOptions indicatorOptions) {
        super(indicatorOptions);
    }

    @Override
    protected int measureHeight() {
        return (int)this.maxWidth;
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.mIndicatorOptions.getPageSize() > 1) {
            this.drawNormal(canvas);
            this.drawSlider(canvas);
        }
    }

    private void drawNormal(Canvas canvas) {
        float normalIndicatorWidth = this.mIndicatorOptions.getNormalIndicatorWidth();
        this.mPaint.setColor(this.mIndicatorOptions.getNormalColor());
        for (int i = 0; i < this.mIndicatorOptions.getPageSize(); ++i) {
            float coordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, i);
            float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
            this.drawCircle(canvas, coordinateX, coordinateY, normalIndicatorWidth / 2.0f);
        }
    }

    private void drawSlider(Canvas canvas) {
        this.mPaint.setColor(this.mIndicatorOptions.getCheckedColor());
        switch (this.mIndicatorOptions.getSlideMode()) {
            case 0: 
            case 2: {
                this.drawCircleSlider(canvas);
                break;
            }
            case 3: {
                this.drawWormSlider(canvas, this.mIndicatorOptions.getNormalIndicatorWidth());
            }
        }
    }

    private void drawCircleSlider(Canvas canvas) {
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float endCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, (currentPosition + 1) % this.mIndicatorOptions.getPageSize());
        float coordinateX = startCoordinateX + (endCoordinateX - startCoordinateX) * this.mIndicatorOptions.getSlideProgress();
        float coordinateY = BannerUtils.getCoordinateY(this.maxWidth);
        float radius = this.mIndicatorOptions.getCheckedIndicatorWidth() / 2.0f;
        this.drawCircle(canvas, coordinateX, coordinateY, radius);
    }

    private void drawWormSlider(Canvas canvas, float sliderHeight) {
        float slideProgress = this.mIndicatorOptions.getSlideProgress();
        int currentPosition = this.mIndicatorOptions.getCurrentPosition();
        float distance = this.mIndicatorOptions.getIndicatorGap() + this.mIndicatorOptions.getNormalIndicatorWidth();
        float startCoordinateX = BannerUtils.getCoordinateX(this.mIndicatorOptions, this.maxWidth, currentPosition);
        float left = startCoordinateX + Math.max(distance * (slideProgress - 0.5f) * 2.0f, 0.0f) - this.mIndicatorOptions.getNormalIndicatorWidth() / 2.0f;
        float right = startCoordinateX + Math.min(distance * slideProgress * 2.0f, distance) + this.mIndicatorOptions.getNormalIndicatorWidth() / 2.0f;
        this.rectF.set(left, 0.0f, right, sliderHeight);
        canvas.drawRoundRect(this.rectF, sliderHeight, sliderHeight, this.mPaint);
    }

    private void drawCircle(Canvas canvas, float coordinateX, float coordinateY, float radius) {
        canvas.drawCircle(coordinateX, coordinateY, radius, this.mPaint);
    }
}

