/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.adapter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public class BannerPagerAdapter<T, VH extends ViewHolder>
extends PagerAdapter {
    private List<T> list;
    private HolderCreator holderCreator;
    private boolean isCanLoop;
    private PageClickListener mPageClickListener;
    private List<View> mViewList = new ArrayList<View>();
    private int mPageStyle;

    public BannerPagerAdapter(List<T> list, HolderCreator<VH> holderCreator) {
        this.list = list;
        this.holderCreator = holderCreator;
    }

    public int getCount() {
        if (this.isCanLoop && this.list.size() > 1) {
            if (this.mPageStyle == 0) {
                return this.list.size() + 2;
            }
            return this.list.size() + 4;
        }
        return this.list.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View itemView = this.findViewByPosition(container, position);
        container.addView(itemView);
        return itemView;
    }

    private View findViewByPosition(ViewGroup container, int position) {
        for (View view : this.mViewList) {
            if ((Integer)view.getTag() != position || view.getParent() != null) continue;
            return view;
        }
        View view = this.getView(position, container);
        view.setTag((Object)position);
        this.mViewList.add(view);
        return view;
    }

    private View getView(int position, ViewGroup container) {
        Object holder = this.holderCreator.createViewHolder();
        if (holder == null) {
            throw new RuntimeException("can not return a null holder");
        }
        return this.createView((ViewHolder<T>)holder, position, container);
    }

    private View createView(ViewHolder<T> holder, int position, ViewGroup container) {
        View view = null;
        if (this.list != null && this.list.size() > 0) {
            if (this.isCanLoop && this.list.size() > 1) {
                int size = this.list.size();
                if (this.mPageStyle == 0) {
                    if (position == 0) {
                        view = holder.createView(container, container.getContext(), this.list.size() - 1);
                        holder.onBind(container.getContext(), this.list.get(this.list.size() - 1), this.list.size() - 1, size);
                    } else if (position == this.list.size() + 1) {
                        view = holder.createView(container, container.getContext(), 0);
                        holder.onBind(container.getContext(), this.list.get(0), 0, size);
                    } else {
                        view = holder.createView(container, container.getContext(), position - 1);
                        holder.onBind(container.getContext(), this.list.get(position - 1), position - 1, size);
                    }
                } else if (position == 0) {
                    view = holder.createView(container, container.getContext(), this.list.size() - 2);
                    holder.onBind(container.getContext(), this.list.get(this.list.size() - 2), this.list.size() - 2, size);
                } else if (position == 1) {
                    view = holder.createView(container, container.getContext(), this.list.size() - 1);
                    holder.onBind(container.getContext(), this.list.get(this.list.size() - 1), this.list.size() - 1, size);
                } else if (position == size + 2) {
                    view = holder.createView(container, container.getContext(), 0);
                    holder.onBind(container.getContext(), this.list.get(0), 0, size);
                } else if (position == size + 3) {
                    view = holder.createView(container, container.getContext(), 1);
                    holder.onBind(container.getContext(), this.list.get(1), 1, size);
                } else {
                    view = holder.createView(container, container.getContext(), position - 2);
                    holder.onBind(container.getContext(), this.list.get(position - 2), position - 2, size);
                }
            } else {
                view = holder.createView(container, container.getContext(), position);
                holder.onBind(container.getContext(), this.list.get(position), position, this.list.size());
            }
            this.setViewListener(view, position);
        }
        return view;
    }

    private void setViewListener(View view, int position) {
        if (view != null) {
            view.setOnClickListener(v -> {
                if (null != this.mPageClickListener) {
                    this.mPageClickListener.onPageClick(position);
                }
            });
        }
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        super.finishUpdate(container);
    }

    public void setPageClickListener(PageClickListener pageClickListener) {
        this.mPageClickListener = pageClickListener;
    }

    public void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    public void setPageStyle(int pageStyle) {
        this.mPageStyle = pageStyle;
    }

    public static interface PageClickListener {
        public void onPageClick(int var1);
    }
}

