/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.indicator;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.zhpan.bannerview.enums.IndicatorSlideMode;
import com.zhpan.bannerview.indicator.IIndicator;
import com.zhpan.bannerview.utils.DpUtils;

public class BaseIndicatorView
extends View
implements IIndicator {
    protected int pageSize;
    protected int normalColor;
    protected int checkedColor;
    protected float indicatorGap;
    protected float slideProgress;
    protected int currentPosition;
    private int prePosition;
    protected boolean slideToRight;
    protected IndicatorSlideMode slideMode;
    protected float normalIndicatorWidth;
    protected float checkedIndicatorWidth;
    private static final String tag = "BaseIndicatorView";

    public BaseIndicatorView(Context context) {
        super(context);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseIndicatorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.checkedIndicatorWidth = this.normalIndicatorWidth = (float)DpUtils.dp2px(8.0f);
        this.indicatorGap = this.normalIndicatorWidth;
        this.normalColor = Color.parseColor((String)"#8C18171C");
        this.checkedColor = Color.parseColor((String)"#8C6C6D72");
        this.slideMode = IndicatorSlideMode.NORMAL;
    }

    public void onPageSelected(int position) {
        if (this.slideMode == IndicatorSlideMode.NORMAL) {
            this.currentPosition = position;
            this.slideProgress = 0.0f;
            this.invalidate();
        } else if (this.slideMode == IndicatorSlideMode.SMOOTH) {
            if (position == 0 && this.slideToRight) {
                this.currentPosition = 0;
                this.slideProgress = 0.0f;
                this.invalidate();
            } else if (position == this.pageSize - 1 && !this.slideToRight) {
                this.currentPosition = this.pageSize - 1;
                this.slideProgress = 0.0f;
                this.invalidate();
            }
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.slideMode == IndicatorSlideMode.SMOOTH) {
            if (this.prePosition == 0 && position == this.pageSize - 1) {
                this.slideToRight = false;
            } else if (this.prePosition == this.pageSize - 1 && position == 0) {
                this.slideToRight = true;
            } else {
                boolean bl = this.slideToRight = (float)position + positionOffset - (float)this.prePosition > 0.0f;
            }
            if (positionOffset == 0.0f) {
                this.prePosition = position;
            }
            if (!(position == this.pageSize - 1 && this.slideToRight || position == this.pageSize - 1 && !this.slideToRight)) {
                this.slideProgress = this.currentPosition == this.pageSize - 1 && this.slideToRight ? 0.0f : positionOffset;
                this.currentPosition = position;
                this.invalidate();
            }
        }
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.requestLayout();
    }

    @Override
    public void setNormalColor(int normalColor) {
        this.normalColor = normalColor;
    }

    @Override
    public void setCheckedColor(int checkedColor) {
        this.checkedColor = checkedColor;
    }

    @Override
    public void setIndicatorGap(int gapRes) {
        if (gapRes >= 0) {
            this.indicatorGap = gapRes;
        }
    }

    @Override
    public void setSlideMode(IndicatorSlideMode slideMode) {
        this.slideMode = slideMode;
    }

    @Override
    public void setIndicatorWidth(int normalIndicatorWidth, int checkedIndicatorWidth) {
        this.normalIndicatorWidth = normalIndicatorWidth;
        this.checkedIndicatorWidth = checkedIndicatorWidth;
    }

    @Override
    public void notifyDataChanged() {
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
    }
}

