/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.viewpager.widget.ViewPager;
import com.zhpan.bannerview.R;
import com.zhpan.bannerview.Utils.DpUtils;
import com.zhpan.bannerview.adapter.BannerPagerAdapter;
import com.zhpan.bannerview.holder.HolderCreator;
import com.zhpan.bannerview.holder.ViewHolder;
import com.zhpan.bannerview.provider.BannerScroller;
import com.zhpan.bannerview.provider.ViewStyleSetter;
import com.zhpan.bannerview.transform.PageTransformerFactory;
import com.zhpan.bannerview.transform.TransformerStyle;
import com.zhpan.bannerview.view.IndicatorView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BannerViewPager<T, VH extends ViewHolder>
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    public String tag = "BannerViewPager";
    private ViewPager mViewPager;
    private List<T> mList;
    private int interval;
    private int currentPosition;
    private boolean isLooping;
    private boolean isCanLoop;
    private boolean isAutoPlay = false;
    private boolean showIndicator = true;
    public static final int START = 1;
    public static final int END = 2;
    public static final int CENTER = 0;
    private int gravity;
    private int indicatorNormalColor;
    private int indicatorCheckedColor;
    private float indicatorRadius;
    private OnPageClickListener mOnPageClickListener;
    private IndicatorView mIndicatorView;
    RelativeLayout mRelativeLayout;
    private HolderCreator<VH> holderCreator;
    Handler mHandler = new Handler();
    Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (BannerViewPager.this.mList.size() > 1) {
                BannerViewPager.this.currentPosition = BannerViewPager.this.currentPosition % (BannerViewPager.this.mList.size() + 1) + 1;
                if (BannerViewPager.this.currentPosition == 1) {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, false);
                    BannerViewPager.this.mHandler.post(BannerViewPager.this.mRunnable);
                } else {
                    BannerViewPager.this.mViewPager.setCurrentItem(BannerViewPager.this.currentPosition, true);
                    BannerViewPager.this.mHandler.postDelayed(BannerViewPager.this.mRunnable, (long)BannerViewPager.this.interval);
                }
            }
        }
    };
    private BannerScroller mScroller;
    public static final int DEFAULT_SCROLL_DURATION = 800;
    private float indicatorMargin = 0.0f;

    public BannerViewPager(Context context) {
        this(context, null);
    }

    public BannerViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, context);
    }

    private void init(AttributeSet attrs, Context context) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.BannerViewPager);
            this.interval = typedArray.getInteger(R.styleable.BannerViewPager_interval, 3000);
            this.indicatorCheckedColor = typedArray.getColor(R.styleable.BannerViewPager_indicator_checked_color, Color.parseColor((String)"#18171C"));
            this.indicatorNormalColor = typedArray.getColor(R.styleable.BannerViewPager_indicator_normal_color, Color.parseColor((String)"#6C6D72"));
            this.indicatorRadius = typedArray.getDimension(R.styleable.BannerViewPager_indicator_radius, (float)DpUtils.dp2px(context, 4.0f));
            this.isAutoPlay = typedArray.getBoolean(R.styleable.BannerViewPager_isAutoPlay, true);
            this.isCanLoop = typedArray.getBoolean(R.styleable.BannerViewPager_isCanLoop, true);
            this.gravity = typedArray.getInt(R.styleable.BannerViewPager_indicator_gravity, 0);
            typedArray.recycle();
        }
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_banner_view_pager, (ViewGroup)this);
        this.mIndicatorView = (IndicatorView)view.findViewById(R.id.indicator_view);
        this.mViewPager = (ViewPager)view.findViewById(R.id.vp_main);
        this.mRelativeLayout = (RelativeLayout)view.findViewById(R.id.rl_banner);
        this.mList = new ArrayList<T>();
        this.initScroller();
    }

    private void initScroller() {
        try {
            this.mScroller = new BannerScroller(this.mViewPager.getContext());
            this.mScroller.setDuration(800);
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            mField.set(this.mViewPager, (Object)this.mScroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initData() {
        if (this.mList.size() > 0) {
            this.initIndicator();
            if (this.isCanLoop) {
                this.currentPosition = 1;
            }
            this.setupViewPager();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setTouchListener() {
        this.mViewPager.setOnTouchListener((v, event) -> {
            int action = event.getAction();
            switch (action) {
                case 0: 
                case 2: {
                    this.isLooping = true;
                    this.stopLoop();
                    break;
                }
                case 1: 
                case 3: {
                    this.isLooping = false;
                    this.startLoop();
                }
            }
            return false;
        });
    }

    private void initIndicator() {
        if (this.mList.size() > 1 && this.showIndicator) {
            this.mIndicatorView.setPageSize(this.mList.size()).setIndicatorRadius(this.indicatorRadius).setIndicatorMargin(this.indicatorMargin).setCheckedColor(this.indicatorCheckedColor).setNormalColor(this.indicatorNormalColor).invalidate();
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mIndicatorView.getLayoutParams();
            switch (this.gravity) {
                case 0: {
                    layoutParams.addRule(14);
                    break;
                }
                case 1: {
                    layoutParams.addRule(20);
                    break;
                }
                case 2: {
                    layoutParams.addRule(21);
                }
            }
        }
    }

    private void setupViewPager() {
        if (this.holderCreator != null) {
            BannerPagerAdapter<T, VH> bannerPagerAdapter = new BannerPagerAdapter<T, VH>(this.mList, this.holderCreator);
            bannerPagerAdapter.setPageClickListener(position -> {
                if (this.mOnPageClickListener != null) {
                    int realPosition;
                    int n = realPosition = this.isCanLoop ? position - 1 : position;
                    if (realPosition < this.mList.size() && realPosition >= 0) {
                        this.mOnPageClickListener.onPageClick(realPosition);
                    }
                }
            });
            bannerPagerAdapter.setCanLoop(this.isCanLoop);
            this.mViewPager.setAdapter(bannerPagerAdapter);
            this.mViewPager.setCurrentItem(this.currentPosition);
            this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            this.startLoop();
            this.setTouchListener();
        }
    }

    public void onPageSelected(int position) {
        this.currentPosition = position;
        if (this.showIndicator) {
            this.mIndicatorView.pageSelect(this.getRealPosition(position));
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.isCanLoop) {
            switch (state) {
                case 0: {
                    if (this.currentPosition == 0) {
                        this.mViewPager.setCurrentItem(this.mList.size(), false);
                        break;
                    }
                    if (this.currentPosition != this.mList.size() + 1) break;
                    this.mViewPager.setCurrentItem(1, false);
                    break;
                }
                case 1: {
                    if (this.currentPosition == this.mList.size() + 1) {
                        this.mViewPager.setCurrentItem(1, false);
                        break;
                    }
                    if (this.currentPosition != 0) break;
                    this.mViewPager.setCurrentItem(this.mList.size(), false);
                }
            }
        } else {
            this.mViewPager.setCurrentItem(this.currentPosition);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    private int getRealPosition(int position) {
        if (this.isCanLoop) {
            if (position == 0) {
                return this.mList.size() - 1;
            }
            if (position == this.mList.size() + 1) {
                return 0;
            }
            return --position;
        }
        return position;
    }

    private int getUnrealPosition(int position) {
        return this.isCanLoop ? (position < this.mList.size() ? ++position : this.mList.size()) : position;
    }

    public void startLoop() {
        if (!this.isLooping && this.isAutoPlay && this.mList.size() > 1) {
            this.mHandler.postDelayed(this.mRunnable, (long)this.interval);
            this.isLooping = true;
        }
    }

    public void stopLoop() {
        if (this.isLooping) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.isLooping = false;
        }
    }

    public BannerViewPager<T, VH> setHolderCreator(HolderCreator<VH> holderCreator) {
        this.holderCreator = holderCreator;
        return this;
    }

    public BannerViewPager<T, VH> setRoundCorner(@DimenRes int radius) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundCorner(this.getResources().getDimension(radius));
        }
        return this;
    }

    public BannerViewPager<T, VH> setRoundCorner(float radiusDp) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewStyleSetter viewStyleSetter = new ViewStyleSetter((View)this);
            viewStyleSetter.setRoundCorner(DpUtils.dp2px(this.getContext(), radiusDp));
        }
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorColor(@ColorInt int normalColor, @ColorInt int checkedColor) {
        this.indicatorCheckedColor = checkedColor;
        this.indicatorNormalColor = normalColor;
        return this;
    }

    public BannerViewPager<T, VH> setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
        return this;
    }

    public BannerViewPager<T, VH> setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
        return this;
    }

    public BannerViewPager<T, VH> setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public List<T> getList() {
        return this.mList;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(float radiusDp) {
        this.indicatorRadius = DpUtils.dp2px(this.getContext(), radiusDp);
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorRadius(@DimenRes int radiusRes) {
        this.indicatorRadius = this.getContext().getResources().getDimension(radiusRes);
        return this;
    }

    public BannerViewPager<T, VH> setScrollDuration(int scrollDuration) {
        this.mScroller.setDuration(scrollDuration);
        return this;
    }

    public BannerViewPager<T, VH> showIndicator(boolean showIndicator) {
        this.showIndicator = showIndicator;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformer(ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(true, transformer);
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformerStyle(TransformerStyle style) {
        this.setPageTransformer(new PageTransformerFactory().createPageTransformer(style));
        return this;
    }

    public BannerViewPager<T, VH> setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(true, transformer);
        return this;
    }

    public void setCurrentItem(int position) {
        this.mViewPager.post(() -> this.mViewPager.setCurrentItem(this.getUnrealPosition(position)));
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        this.mViewPager.post(() -> this.mViewPager.setCurrentItem(this.getUnrealPosition(position), smoothScroll));
    }

    public BannerViewPager<T, VH> setOnPageClickListener(OnPageClickListener onPageClickListener) {
        this.mOnPageClickListener = onPageClickListener;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(float indicatorMarginDp) {
        this.indicatorMargin = indicatorMarginDp;
        return this;
    }

    public BannerViewPager<T, VH> setIndicatorMargin(@DimenRes int marginRes) {
        this.indicatorMargin = this.getContext().getResources().getDimension(marginRes);
        return this;
    }

    public void create(List<T> list) {
        if (list != null) {
            this.mList.clear();
            this.mList.addAll(list);
            this.initData();
        }
    }

    public static interface OnPageClickListener {
        public void onPageClick(int var1);
    }
}

