/*
 * Decompiled with CFR 0.152.
 */
package com.zhpan.bannerview.manager;

import com.zhpan.bannerview.utils.BannerUtils;
import com.zhpan.indicator.option.IndicatorOptions;

public class BannerOptions {
    public static final int DEFAULT_REVEAL_WIDTH = -1000;
    private int offScreenPageLimit = -1;
    private int interval;
    private boolean isCanLoop;
    private boolean isAutoPlay = false;
    private int indicatorGravity;
    private int pageMargin;
    private int rightRevealWidth = -1000;
    private int leftRevealWidth = -1000;
    private int pageStyle = 0;
    private float pageScale = 0.85f;
    private IndicatorMargin mIndicatorMargin;
    private int mIndicatorVisibility = 0;
    private int scrollDuration;
    private float[] roundRadiusArray;
    private int roundRadius;
    private boolean userInputEnabled = true;
    private int orientation = 0;
    private boolean rtl;
    private boolean disallowParentInterceptDownEvent;
    private boolean stopLoopWhenDetachedFromWindow = true;
    private boolean autoScrollSmoothly = true;
    private final IndicatorOptions mIndicatorOptions = new IndicatorOptions();

    public BannerOptions() {
        this.pageMargin = BannerUtils.dp2px(20.0f);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isCanLoop() {
        return this.isCanLoop;
    }

    public void setCanLoop(boolean canLoop) {
        this.isCanLoop = canLoop;
    }

    public boolean isAutoPlay() {
        return this.isAutoPlay;
    }

    public void setAutoPlay(boolean autoPlay) {
        this.isAutoPlay = autoPlay;
    }

    public int getIndicatorGravity() {
        return this.indicatorGravity;
    }

    public void setIndicatorGravity(int indicatorGravity) {
        this.indicatorGravity = indicatorGravity;
    }

    public int getIndicatorNormalColor() {
        return this.mIndicatorOptions.getNormalSliderColor();
    }

    public int getIndicatorCheckedColor() {
        return this.mIndicatorOptions.getCheckedSliderColor();
    }

    public int getNormalIndicatorWidth() {
        return (int)this.mIndicatorOptions.getNormalSliderWidth();
    }

    public void setIndicatorSliderColor(int normalColor, int checkedColor) {
        this.mIndicatorOptions.setSliderColor(normalColor, checkedColor);
    }

    public void setIndicatorSliderWidth(int normalWidth, int checkedWidth) {
        this.mIndicatorOptions.setSliderWidth((float)normalWidth, (float)checkedWidth);
    }

    public void showIndicatorWhenOneItem(boolean showIndicatorWhenOneItem) {
        this.mIndicatorOptions.setShowIndicatorOneItem(showIndicatorWhenOneItem);
    }

    public int getCheckedIndicatorWidth() {
        return (int)this.mIndicatorOptions.getCheckedSliderWidth();
    }

    public IndicatorOptions getIndicatorOptions() {
        return this.mIndicatorOptions;
    }

    public int getPageMargin() {
        return this.pageMargin;
    }

    public void setPageMargin(int pageMargin) {
        this.pageMargin = pageMargin;
    }

    public int getRightRevealWidth() {
        return this.rightRevealWidth;
    }

    public void setRightRevealWidth(int rightRevealWidth) {
        this.rightRevealWidth = rightRevealWidth;
    }

    public int getLeftRevealWidth() {
        return this.leftRevealWidth;
    }

    public void setLeftRevealWidth(int leftRevealWidth) {
        this.leftRevealWidth = leftRevealWidth;
    }

    public int getIndicatorStyle() {
        return this.mIndicatorOptions.getIndicatorStyle();
    }

    public void setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorOptions.setIndicatorStyle(indicatorStyle);
    }

    public int getIndicatorSlideMode() {
        return this.mIndicatorOptions.getSlideMode();
    }

    public void setIndicatorSlideMode(int indicatorSlideMode) {
        this.mIndicatorOptions.setSlideMode(indicatorSlideMode);
    }

    public float getIndicatorGap() {
        return this.mIndicatorOptions.getSliderGap();
    }

    public void setIndicatorGap(float indicatorGap) {
        this.mIndicatorOptions.setSliderGap(indicatorGap);
    }

    public float getIndicatorHeight() {
        return this.mIndicatorOptions.getSliderHeight();
    }

    public void setIndicatorHeight(int indicatorHeight) {
        this.mIndicatorOptions.setSliderHeight((float)indicatorHeight);
    }

    public int getPageStyle() {
        return this.pageStyle;
    }

    public void setPageStyle(int pageStyle) {
        this.pageStyle = pageStyle;
    }

    public float getPageScale() {
        return this.pageScale;
    }

    public void setPageScale(float pageScale) {
        this.pageScale = pageScale;
    }

    public IndicatorMargin getIndicatorMargin() {
        return this.mIndicatorMargin;
    }

    public void setIndicatorMargin(int left, int top, int right, int bottom) {
        this.mIndicatorMargin = new IndicatorMargin(left, top, right, bottom);
    }

    public boolean isAutoScrollSmoothly() {
        return this.autoScrollSmoothly;
    }

    public void setAutoScrollSmoothly(boolean autoScrollSmoothly) {
        this.autoScrollSmoothly = autoScrollSmoothly;
    }

    public float[] getRoundRectRadiusArray() {
        return this.roundRadiusArray;
    }

    public int getRoundRectRadius() {
        return this.roundRadius;
    }

    public void setRoundRectRadius(int radius) {
        this.roundRadius = radius;
    }

    public void setRoundRectRadius(int topLeftRadius, int topRightRadius, int bottomLeftRadius, int bottomRightRadius) {
        this.roundRadiusArray = new float[8];
        this.roundRadiusArray[0] = topLeftRadius;
        this.roundRadiusArray[1] = topLeftRadius;
        this.roundRadiusArray[2] = topRightRadius;
        this.roundRadiusArray[3] = topRightRadius;
        this.roundRadiusArray[4] = bottomRightRadius;
        this.roundRadiusArray[5] = bottomRightRadius;
        this.roundRadiusArray[6] = bottomLeftRadius;
        this.roundRadiusArray[7] = bottomLeftRadius;
    }

    public int getScrollDuration() {
        return this.scrollDuration;
    }

    public void setScrollDuration(int scrollDuration) {
        this.scrollDuration = scrollDuration;
    }

    public int getIndicatorVisibility() {
        return this.mIndicatorVisibility;
    }

    public void setIndicatorVisibility(int indicatorVisibility) {
        this.mIndicatorVisibility = indicatorVisibility;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.mIndicatorOptions.setOrientation(orientation);
    }

    public boolean isUserInputEnabled() {
        return this.userInputEnabled;
    }

    public void setUserInputEnabled(boolean userInputEnabled) {
        this.userInputEnabled = userInputEnabled;
    }

    public void resetIndicatorOptions() {
        this.mIndicatorOptions.setCurrentPosition(0);
        this.mIndicatorOptions.setSlideProgress(0.0f);
    }

    public boolean isDisallowParentInterceptDownEvent() {
        return this.disallowParentInterceptDownEvent;
    }

    public void setDisallowParentInterceptDownEvent(boolean disallowParentInterceptDownEvent) {
        this.disallowParentInterceptDownEvent = disallowParentInterceptDownEvent;
    }

    public int getOffScreenPageLimit() {
        return this.offScreenPageLimit;
    }

    public void setOffScreenPageLimit(int offScreenPageLimit) {
        this.offScreenPageLimit = offScreenPageLimit;
    }

    public boolean isRtl() {
        return this.rtl;
    }

    public void setRtl(boolean rtl) {
        this.rtl = rtl;
        this.mIndicatorOptions.setOrientation(rtl ? 3 : 0);
    }

    public boolean isStopLoopWhenDetachedFromWindow() {
        return this.stopLoopWhenDetachedFromWindow;
    }

    public void setStopLoopWhenDetachedFromWindow(boolean stopLoopWhenDetachedFromWindow) {
        this.stopLoopWhenDetachedFromWindow = stopLoopWhenDetachedFromWindow;
    }

    public static class IndicatorMargin {
        private final int left;
        private final int right;
        private final int top;
        private final int bottom;

        public IndicatorMargin(int left, int top, int right, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }
    }
}

